<?php

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

// Try to load our extension if it's not already loaded.
if (!extension_loaded('gdal')) {
  if (strtolower(substr(PHP_OS, 0, 3)) === 'win') {
    if (!dl('php_gdal.dll')) return;
  } else {
    // PHP_SHLIB_SUFFIX gives 'dylib' on MacOS X but modules are 'so'.
    if (PHP_SHLIB_SUFFIX === 'dylib') {
      if (!dl('gdal.so')) return;
    } else {
      if (!dl('gdal.'.PHP_SHLIB_SUFFIX)) return;
    }
  }
}



abstract class gdal {
	static function Debug($msg_class,$message) {
		Debug($msg_class,$message);
	}

	static function Error($msg_class=null,$err_code=0,$msg="error") {
		switch (func_num_args()) {
		case 0: Error(); break;
		default: Error($msg_class,$err_code,$msg);
		}
	}

	static function PushErrorHandler($pszCallbackName=null) {
		switch (func_num_args()) {
		case 0: PushErrorHandler(); break;
		default: PushErrorHandler($pszCallbackName);
		}
	}

	static function PopErrorHandler() {
		PopErrorHandler();
	}

	static function ErrorReset() {
		ErrorReset();
	}

	static function EscapeString($len,$scheme=null) {
		switch (func_num_args()) {
		case 1: $r=EscapeString($len); break;
		default: $r=EscapeString($len,$scheme);
		}
		return $r;
	}

	static function GetLastErrorNo() {
		return GetLastErrorNo();
	}

	static function GetLastErrorType() {
		return GetLastErrorType();
	}

	static function GetLastErrorMsg() {
		return GetLastErrorMsg();
	}

	static function PushFinderLocation($utf8_path) {
		PushFinderLocation($utf8_path);
	}

	static function PopFinderLocation() {
		PopFinderLocation();
	}

	static function FinderClean() {
		FinderClean();
	}

	static function FindFile($pszClass,$utf8_path) {
		return FindFile($pszClass,$utf8_path);
	}

	static function ReadDir($utf8_path) {
		return ReadDir($utf8_path);
	}

	static function SetConfigOption($pszKey,$pszValue) {
		SetConfigOption($pszKey,$pszValue);
	}

	static function GetConfigOption($pszKey,$pszDefault=null) {
		switch (func_num_args()) {
		case 1: $r=GetConfigOption($pszKey); break;
		default: $r=GetConfigOption($pszKey,$pszDefault);
		}
		return $r;
	}

	static function CPLBinaryToHex($nBytes,$pabyData) {
		return CPLBinaryToHex($nBytes,$pabyData);
	}

	static function CPLHexToBinary($pszHex,$pnBytes) {
		return CPLHexToBinary($pszHex,$pnBytes);
	}

	static function FileFromMemBuffer($utf8_path,$nBytes,$pabyData) {
		FileFromMemBuffer($utf8_path,$nBytes,$pabyData);
	}

	static function Unlink($pszFilename) {
		return Unlink($pszFilename);
	}

	static function HasThreadSupport() {
		return HasThreadSupport();
	}

	static function Mkdir($utf8_path,$mode) {
		return Mkdir($utf8_path,$mode);
	}

	static function Rmdir($utf8_path) {
		return Rmdir($utf8_path);
	}

	static function Rename($pszOld,$pszNew) {
		return Rename($pszOld,$pszNew);
	}

	static function VSIFOpenL($utf8_path,$pszMode) {
		return VSIFOpenL($utf8_path,$pszMode);
	}

	static function VSIFCloseL($arg1) {
		VSIFCloseL($arg1);
	}

	static function VSIFSeekL($arg1,$arg2,$arg3) {
		return VSIFSeekL($arg1,$arg2,$arg3);
	}

	static function VSIFTellL($arg1) {
		return VSIFTellL($arg1);
	}

	static function VSIFWriteL($arg1,$arg2,$arg3,$arg4) {
		return VSIFWriteL($arg1,$arg2,$arg3,$arg4);
	}

	static function GDAL_GCP_GCPX_get($gcp) {
		return GDAL_GCP_GCPX_get($gcp);
	}

	static function GDAL_GCP_GCPX_set($gcp,$dfGCPX) {
		GDAL_GCP_GCPX_set($gcp,$dfGCPX);
	}

	static function GDAL_GCP_GCPY_get($gcp) {
		return GDAL_GCP_GCPY_get($gcp);
	}

	static function GDAL_GCP_GCPY_set($gcp,$dfGCPY) {
		GDAL_GCP_GCPY_set($gcp,$dfGCPY);
	}

	static function GDAL_GCP_GCPZ_get($gcp) {
		return GDAL_GCP_GCPZ_get($gcp);
	}

	static function GDAL_GCP_GCPZ_set($gcp,$dfGCPZ) {
		GDAL_GCP_GCPZ_set($gcp,$dfGCPZ);
	}

	static function GDAL_GCP_GCPPixel_get($gcp) {
		return GDAL_GCP_GCPPixel_get($gcp);
	}

	static function GDAL_GCP_GCPPixel_set($gcp,$dfGCPPixel) {
		GDAL_GCP_GCPPixel_set($gcp,$dfGCPPixel);
	}

	static function GDAL_GCP_GCPLine_get($gcp) {
		return GDAL_GCP_GCPLine_get($gcp);
	}

	static function GDAL_GCP_GCPLine_set($gcp,$dfGCPLine) {
		GDAL_GCP_GCPLine_set($gcp,$dfGCPLine);
	}

	static function GDAL_GCP_Info_get($gcp) {
		return GDAL_GCP_Info_get($gcp);
	}

	static function GDAL_GCP_Info_set($gcp,$pszInfo) {
		GDAL_GCP_Info_set($gcp,$pszInfo);
	}

	static function GDAL_GCP_Id_get($gcp) {
		return GDAL_GCP_Id_get($gcp);
	}

	static function GDAL_GCP_Id_set($gcp,$pszId) {
		GDAL_GCP_Id_set($gcp,$pszId);
	}

	static function GDAL_GCP_get_GCPX($gcp) {
		return GDAL_GCP_get_GCPX($gcp);
	}

	static function GDAL_GCP_set_GCPX($gcp,$dfGCPX) {
		GDAL_GCP_set_GCPX($gcp,$dfGCPX);
	}

	static function GDAL_GCP_get_GCPY($gcp) {
		return GDAL_GCP_get_GCPY($gcp);
	}

	static function GDAL_GCP_set_GCPY($gcp,$dfGCPY) {
		GDAL_GCP_set_GCPY($gcp,$dfGCPY);
	}

	static function GDAL_GCP_get_GCPZ($gcp) {
		return GDAL_GCP_get_GCPZ($gcp);
	}

	static function GDAL_GCP_set_GCPZ($gcp,$dfGCPZ) {
		GDAL_GCP_set_GCPZ($gcp,$dfGCPZ);
	}

	static function GDAL_GCP_get_GCPPixel($gcp) {
		return GDAL_GCP_get_GCPPixel($gcp);
	}

	static function GDAL_GCP_set_GCPPixel($gcp,$dfGCPPixel) {
		GDAL_GCP_set_GCPPixel($gcp,$dfGCPPixel);
	}

	static function GDAL_GCP_get_GCPLine($gcp) {
		return GDAL_GCP_get_GCPLine($gcp);
	}

	static function GDAL_GCP_set_GCPLine($gcp,$dfGCPLine) {
		GDAL_GCP_set_GCPLine($gcp,$dfGCPLine);
	}

	static function GDAL_GCP_get_Info($gcp) {
		return GDAL_GCP_get_Info($gcp);
	}

	static function GDAL_GCP_set_Info($gcp,$pszInfo) {
		GDAL_GCP_set_Info($gcp,$pszInfo);
	}

	static function GDAL_GCP_get_Id($gcp) {
		return GDAL_GCP_get_Id($gcp);
	}

	static function GDAL_GCP_set_Id($gcp,$pszId) {
		GDAL_GCP_set_Id($gcp,$pszId);
	}

	static function GCPsToGeoTransform($nGCPs,$bApproxOK=1) {
		return GCPsToGeoTransform($nGCPs,$bApproxOK);
	}

	static function TermProgress_nocb($dfProgress,$pszMessage=null,$pData=null) {
		switch (func_num_args()) {
		case 1: $r=TermProgress_nocb($dfProgress); break;
		default: $r=TermProgress_nocb($dfProgress,$pszMessage,$pData);
		}
		return $r;
	}

	const TermProgress = TermProgress;

	static function ComputeMedianCutPCT($red,$green,$blue,$num_colors,$colors,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 5: $r=ComputeMedianCutPCT($red,$green,$blue,$num_colors,$colors); break;
		default: $r=ComputeMedianCutPCT($red,$green,$blue,$num_colors,$colors,$callback,$callback_data);
		}
		return $r;
	}

	static function DitherRGB2PCT($red,$green,$blue,$target,$colors,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 5: $r=DitherRGB2PCT($red,$green,$blue,$target,$colors); break;
		default: $r=DitherRGB2PCT($red,$green,$blue,$target,$colors,$callback,$callback_data);
		}
		return $r;
	}

	static function ReprojectImage($src_ds,$dst_ds,$src_wkt=null,$dst_wkt=null,$eResampleAlg=null,$WarpMemoryLimit=0.0,$maxerror=0.0,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 2: $r=ReprojectImage($src_ds,$dst_ds); break;
		case 3: $r=ReprojectImage($src_ds,$dst_ds,$src_wkt); break;
		case 4: $r=ReprojectImage($src_ds,$dst_ds,$src_wkt,$dst_wkt); break;
		case 5: case 6: case 7: $r=ReprojectImage($src_ds,$dst_ds,$src_wkt,$dst_wkt,$eResampleAlg,$WarpMemoryLimit,$maxerror); break;
		default: $r=ReprojectImage($src_ds,$dst_ds,$src_wkt,$dst_wkt,$eResampleAlg,$WarpMemoryLimit,$maxerror,$callback,$callback_data);
		}
		return $r;
	}

	static function ComputeProximity($srcBand,$proximityBand,$options=null,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 2: case 3: $r=ComputeProximity($srcBand,$proximityBand,$options); break;
		default: $r=ComputeProximity($srcBand,$proximityBand,$options,$callback,$callback_data);
		}
		return $r;
	}

	static function RasterizeLayer($dataset,$bands,$layer,$pfnTransformer=null,$pTransformArg=null,$burn_values=0,$burn_values_list=null,$options=null,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 3: case 4: case 5: case 6: case 7: case 8: $r=RasterizeLayer($dataset,$bands,$layer,$pfnTransformer,$pTransformArg,$burn_values,$burn_values_list,$options); break;
		default: $r=RasterizeLayer($dataset,$bands,$layer,$pfnTransformer,$pTransformArg,$burn_values,$burn_values_list,$options,$callback,$callback_data);
		}
		return $r;
	}

	static function Polygonize($srcBand,$maskBand,$outLayer,$iPixValField,$options=null,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 4: case 5: $r=Polygonize($srcBand,$maskBand,$outLayer,$iPixValField,$options); break;
		default: $r=Polygonize($srcBand,$maskBand,$outLayer,$iPixValField,$options,$callback,$callback_data);
		}
		return $r;
	}

	static function FillNodata($targetBand,$maskBand,$maxSearchDist,$smoothingIterations,$options=null,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 4: case 5: $r=FillNodata($targetBand,$maskBand,$maxSearchDist,$smoothingIterations,$options); break;
		default: $r=FillNodata($targetBand,$maskBand,$maxSearchDist,$smoothingIterations,$options,$callback,$callback_data);
		}
		return $r;
	}

	static function SieveFilter($srcBand,$maskBand,$dstBand,$threshold,$connectedness=4,$options=null,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 4: case 5: case 6: $r=SieveFilter($srcBand,$maskBand,$dstBand,$threshold,$connectedness,$options); break;
		default: $r=SieveFilter($srcBand,$maskBand,$dstBand,$threshold,$connectedness,$options,$callback,$callback_data);
		}
		return $r;
	}

	static function RegenerateOverviews($srcBand,$overviewBandCount,$overviewBands,$resampling="average",$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 3: case 4: $r=RegenerateOverviews($srcBand,$overviewBandCount,$overviewBands,$resampling); break;
		default: $r=RegenerateOverviews($srcBand,$overviewBandCount,$overviewBands,$resampling,$callback,$callback_data);
		}
		return $r;
	}

	static function RegenerateOverview($srcBand,$overviewBand,$resampling="average",$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 2: case 3: $r=RegenerateOverview($srcBand,$overviewBand,$resampling); break;
		default: $r=RegenerateOverview($srcBand,$overviewBand,$resampling,$callback,$callback_data);
		}
		return $r;
	}

	static function ContourGenerate($srcBand,$contourInterval,$contourBase,$fixedLevelCount,$fixedLevels,$useNoData,$noDataValue,$dstLayer,$idField,$elevField,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 10: $r=ContourGenerate($srcBand,$contourInterval,$contourBase,$fixedLevelCount,$fixedLevels,$useNoData,$noDataValue,$dstLayer,$idField,$elevField); break;
		default: $r=ContourGenerate($srcBand,$contourInterval,$contourBase,$fixedLevelCount,$fixedLevels,$useNoData,$noDataValue,$dstLayer,$idField,$elevField,$callback,$callback_data);
		}
		return $r;
	}

	static function AutoCreateWarpedVRT($src_ds,$src_wkt=null,$dst_wkt=null,$eResampleAlg=null,$maxerror=0.0) {
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Dataset($r);
			}
			return new $c($r);
		}
		return $r;
	}

	static function ApplyGeoTransform($padfGeoTransform,$dfPixel,$dfLine) {
		ApplyGeoTransform($padfGeoTransform,$dfPixel,$dfLine);
	}

	static function InvGeoTransform($gt_in) {
		return InvGeoTransform($gt_in);
	}

	static function VersionInfo($request="VERSION_NUM") {
		return VersionInfo($request);
	}

	static function AllRegister() {
		AllRegister();
	}

	static function GDALDestroyDriverManager() {
		GDALDestroyDriverManager();
	}

	static function GetCacheMax() {
		return GetCacheMax();
	}

	static function GetCacheUsed() {
		return GetCacheUsed();
	}

	static function SetCacheMax($nBytes) {
		SetCacheMax($nBytes);
	}

	static function GetDataTypeSize($eDataType) {
		return GetDataTypeSize($eDataType);
	}

	static function DataTypeIsComplex($eDataType) {
		return DataTypeIsComplex($eDataType);
	}

	static function GetDataTypeName($eDataType) {
		return GetDataTypeName($eDataType);
	}

	static function GetDataTypeByName($pszDataTypeName) {
		return GetDataTypeByName($pszDataTypeName);
	}

	static function GetColorInterpretationName($eColorInterp) {
		return GetColorInterpretationName($eColorInterp);
	}

	static function GetPaletteInterpretationName($ePaletteInterp) {
		return GetPaletteInterpretationName($ePaletteInterp);
	}

	static function DecToDMS($arg1,$arg2,$arg3=2) {
		return DecToDMS($arg1,$arg2,$arg3);
	}

	static function PackedDMSToDec($dfPacked) {
		return PackedDMSToDec($dfPacked);
	}

	static function DecToPackedDMS($dfDec) {
		return DecToPackedDMS($dfDec);
	}

	static function ParseXMLString($pszXMLString) {
		return ParseXMLString($pszXMLString);
	}

	static function SerializeXMLTree($xmlnode) {
		return SerializeXMLTree($xmlnode);
	}

	static function GetDriverCount() {
		return GetDriverCount();
	}

	static function GetDriverByName($name) {
		$r=GetDriverByName($name);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Driver($r);
			}
			return new $c($r);
		}
		return $r;
	}

	static function GetDriver($i) {
		$r=GetDriver($i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Driver($r);
			}
			return new $c($r);
		}
		return $r;
	}

	static function Open($utf8_path,$eAccess=null) {
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Dataset($r);
			}
			return new $c($r);
		}
		return $r;
	}

	static function OpenShared($utf8_path,$eAccess=null) {
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Dataset($r);
			}
			return new $c($r);
		}
		return $r;
	}

	static function IdentifyDriver($utf8_path,$papszSiblings=null) {
		$r=IdentifyDriver($utf8_path,$papszSiblings);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Driver($r);
			}
			return new $c($r);
		}
		return $r;
	}

	static function GeneralCmdLineProcessor($papszArgv,$nOptions=0) {
		return GeneralCmdLineProcessor($papszArgv,$nOptions);
	}
}

/* PHP Proxy Classes */
class MajorObject {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	public function GetDescription() {
		return MajorObject_GetDescription($this->_cPtr);
	}

	public function SetDescription($pszNewDesc) {
		MajorObject_SetDescription($this->_cPtr,$pszNewDesc);
	}

	public function GetMetadata_Dict($pszDomain="") {
		return MajorObject_GetMetadata_Dict($this->_cPtr,$pszDomain);
	}

	public function GetMetadata_List($pszDomain="") {
		return MajorObject_GetMetadata_List($this->_cPtr,$pszDomain);
	}

	public function SetMetadata($papszMetadata_or_pszMetadataString,$pszDomain="") {
		$r=MajorObject_SetMetadata($this->_cPtr,$papszMetadata_or_pszMetadataString,$pszDomain);
		return $r;
	}

	public function GetMetadataItem($pszName,$pszDomain="") {
		return MajorObject_GetMetadataItem($this->_cPtr,$pszName,$pszDomain);
	}

	public function SetMetadataItem($pszName,$pszValue,$pszDomain="") {
		return MajorObject_SetMetadataItem($this->_cPtr,$pszName,$pszValue,$pszDomain);
	}
}

class Driver extends MajorObject {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		MajorObject::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return MajorObject::__isset($var);
	}

	function __get($var) {
		$func = 'Driver_'.$var.'_get';
		if (function_exists($func)) {
			$r = call_user_func($func,$this->_cPtr);
			if (!is_resource($r)) return $r;
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			return new $c($r);
		}
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return MajorObject::__get($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	public function Create($utf8_path,$xsize,$ysize,$bands=1,$eType=null,$options=null) {
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Dataset($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function CreateCopy($utf8_path,$src,$strict=1,$options=null,$callback=null,$callback_data=null) {
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Dataset($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function Delete($utf8_path) {
		return Driver_Delete($this->_cPtr,$utf8_path);
	}

	public function Rename($newName,$oldName) {
		return Driver_Rename($this->_cPtr,$newName,$oldName);
	}

	public function Register() {
		return Driver_Register($this->_cPtr);
	}

	public function Deregister() {
		Driver_Deregister($this->_cPtr);
	}
}

class ColorEntry {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'ColorEntry_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if (function_exists('ColorEntry_'.$var.'_set')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		$func = 'ColorEntry_'.$var.'_get';
		if (function_exists($func)) {
			$r = call_user_func($func,$this->_cPtr);
			if (!is_resource($r)) return $r;
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			return new $c($r);
		}
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	public function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_GDALColorEntry') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_ColorEntry();
	}
}

class GCP {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		$func = 'GCP_'.$var.'_set';
		if (function_exists($func)) return call_user_func($func,$this->_cPtr,$value);
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if (function_exists('GCP_'.$var.'_set')) return true;
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		$func = 'GCP_'.$var.'_get';
		if (function_exists($func)) {
			$r = call_user_func($func,$this->_cPtr);
			if (!is_resource($r)) return $r;
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			return new $c($r);
		}
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	public function __construct($x=0.0,$y=0.0,$z=0.0,$pixel=0.0,$line=0.0,$info="",$id="") {
		if (is_resource($x) && get_resource_type($x) === '_p_GDAL_GCP') {
			$this->_cPtr=$x;
			return;
		}
		$this->_cPtr=new_GCP($x,$y,$z,$pixel,$line,$info,$id);
	}
}

class AsyncReader {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	public function GetNextUpdatedRegion($timeout) {
		return AsyncReader_GetNextUpdatedRegion($this->_cPtr,$timeout);
	}

	public function LockBuffer($timeout) {
		return AsyncReader_LockBuffer($this->_cPtr,$timeout);
	}

	public function UnlockBuffer() {
		AsyncReader_UnlockBuffer($this->_cPtr);
	}
}

class Dataset extends MajorObject {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		MajorObject::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return MajorObject::__isset($var);
	}

	function __get($var) {
		$func = 'Dataset_'.$var.'_get';
		if (function_exists($func)) {
			$r = call_user_func($func,$this->_cPtr);
			if (!is_resource($r)) return $r;
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			return new $c($r);
		}
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return MajorObject::__get($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	public function GetDriver() {
		$r=Dataset_GetDriver($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Driver($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function GetRasterBand($nBand) {
		$r=Dataset_GetRasterBand($this->_cPtr,$nBand);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Band($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function GetProjection() {
		return Dataset_GetProjection($this->_cPtr);
	}

	public function GetProjectionRef() {
		return Dataset_GetProjectionRef($this->_cPtr);
	}

	public function SetProjection($prj) {
		return Dataset_SetProjection($this->_cPtr,$prj);
	}

	public function GetGeoTransform() {
		Dataset_GetGeoTransform($this->_cPtr);
	}

	public function SetGeoTransform($argin) {
		return Dataset_SetGeoTransform($this->_cPtr,$argin);
	}

	public function BuildOverviews($resampling="NEAREST",$overviewlist=0,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 0: case 1: case 2: $r=Dataset_BuildOverviews($this->_cPtr,$resampling,$overviewlist); break;
		default: $r=Dataset_BuildOverviews($this->_cPtr,$resampling,$overviewlist,$callback,$callback_data);
		}
		return $r;
	}

	public function GetGCPCount() {
		return Dataset_GetGCPCount($this->_cPtr);
	}

	public function GetGCPProjection() {
		return Dataset_GetGCPProjection($this->_cPtr);
	}

	public function GetGCPs() {
		Dataset_GetGCPs($this->_cPtr);
	}

	public function SetGCPs($nGCPs,$pszGCPProjection) {
		return Dataset_SetGCPs($this->_cPtr,$nGCPs,$pszGCPProjection);
	}

	public function FlushCache() {
		Dataset_FlushCache($this->_cPtr);
	}

	public function AddBand($datatype=null,$options=null) {
		switch (func_num_args()) {
		case 0: $r=Dataset_AddBand($this->_cPtr); break;
		default: $r=Dataset_AddBand($this->_cPtr,$datatype,$options);
		}
		return $r;
	}

	public function CreateMaskBand($nFlags) {
		return Dataset_CreateMaskBand($this->_cPtr,$nFlags);
	}

	public function GetFileList() {
		return Dataset_GetFileList($this->_cPtr);
	}

	public function WriteRaster($xoff,$yoff,$xsize,$ysize,$buf_len,$buf_xsize=null,$buf_ysize=null,$buf_type=null,$band_list=0,$buf_pixel_space=null,$buf_line_space=null,$buf_band_space=null) {
		return Dataset_WriteRaster($this->_cPtr,$xoff,$yoff,$xsize,$ysize,$buf_len,$buf_xsize,$buf_ysize,$buf_type,$band_list,$buf_pixel_space,$buf_line_space,$buf_band_space);
	}

	public function ReadRaster($xoff,$yoff,$xsize,$ysize,$buf_xsize=null,$buf_ysize=null,$buf_type=null,$band_list=0,$buf_pixel_space=null,$buf_line_space=null,$buf_band_space=null) {
		return Dataset_ReadRaster($this->_cPtr,$xoff,$yoff,$xsize,$ysize,$buf_xsize,$buf_ysize,$buf_type,$band_list,$buf_pixel_space,$buf_line_space,$buf_band_space);
	}
}

class Band extends MajorObject {
	public $_cPtr=null;

	function __set($var,$value) {
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		MajorObject::__set($var,$value);
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return MajorObject::__isset($var);
	}

	function __get($var) {
		$func = 'Band_'.$var.'_get';
		if (function_exists($func)) {
			$r = call_user_func($func,$this->_cPtr);
			if (!is_resource($r)) return $r;
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			return new $c($r);
		}
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return MajorObject::__get($var);
	}
	function __construct($h) {
		$this->_cPtr=$h;
	}

	public function GetBand() {
		return Band_GetBand($this->_cPtr);
	}

	public function GetBlockSize() {
		Band_GetBlockSize($this->_cPtr);
	}

	public function GetColorInterpretation() {
		return Band_GetColorInterpretation($this->_cPtr);
	}

	public function GetRasterColorInterpretation() {
		return Band_GetRasterColorInterpretation($this->_cPtr);
	}

	public function SetColorInterpretation($val) {
		return Band_SetColorInterpretation($this->_cPtr,$val);
	}

	public function SetRasterColorInterpretation($val) {
		return Band_SetRasterColorInterpretation($this->_cPtr,$val);
	}

	public function GetNoDataValue() {
		Band_GetNoDataValue($this->_cPtr);
	}

	public function SetNoDataValue($d) {
		return Band_SetNoDataValue($this->_cPtr,$d);
	}

	public function GetUnitType() {
		return Band_GetUnitType($this->_cPtr);
	}

	public function SetUnitType($val) {
		return Band_SetUnitType($this->_cPtr,$val);
	}

	public function GetRasterCategoryNames() {
		return Band_GetRasterCategoryNames($this->_cPtr);
	}

	public function SetRasterCategoryNames($names) {
		return Band_SetRasterCategoryNames($this->_cPtr,$names);
	}

	public function GetMinimum() {
		Band_GetMinimum($this->_cPtr);
	}

	public function GetMaximum() {
		Band_GetMaximum($this->_cPtr);
	}

	public function GetOffset() {
		Band_GetOffset($this->_cPtr);
	}

	public function GetScale() {
		Band_GetScale($this->_cPtr);
	}

	public function SetOffset($val) {
		return Band_SetOffset($this->_cPtr,$val);
	}

	public function SetScale($val) {
		return Band_SetScale($this->_cPtr,$val);
	}

	public function GetStatistics($approx_ok,$force) {
		return Band_GetStatistics($this->_cPtr,$approx_ok,$force);
	}

	public function ComputeStatistics($approx_ok,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 1: $r=Band_ComputeStatistics($this->_cPtr,$approx_ok); break;
		default: $r=Band_ComputeStatistics($this->_cPtr,$approx_ok,$callback,$callback_data);
		}
		return $r;
	}

	public function SetStatistics($min,$max,$mean,$stddev) {
		return Band_SetStatistics($this->_cPtr,$min,$max,$mean,$stddev);
	}

	public function GetOverviewCount() {
		return Band_GetOverviewCount($this->_cPtr);
	}

	public function GetOverview($i) {
		$r=Band_GetOverview($this->_cPtr,$i);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Band($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function Checksum($xoff=0,$yoff=0,$xsize=null,$ysize=null) {
		return Band_Checksum($this->_cPtr,$xoff,$yoff,$xsize,$ysize);
	}

	public function ComputeRasterMinMax($approx_ok=0) {
		Band_ComputeRasterMinMax($this->_cPtr,$approx_ok);
	}

	public function ComputeBandStats($samplestep=1) {
		Band_ComputeBandStats($this->_cPtr,$samplestep);
	}

	public function Fill($real_fill,$imag_fill=0.0) {
		return Band_Fill($this->_cPtr,$real_fill,$imag_fill);
	}

	public function ReadRaster($xoff,$yoff,$xsize,$ysize,$buf_xsize=null,$buf_ysize=null,$buf_type=null,$buf_pixel_space=null,$buf_line_space=null) {
		return Band_ReadRaster($this->_cPtr,$xoff,$yoff,$xsize,$ysize,$buf_xsize,$buf_ysize,$buf_type,$buf_pixel_space,$buf_line_space);
	}

	public function WriteRaster($xoff,$yoff,$xsize,$ysize,$buf_len,$buf_xsize=null,$buf_ysize=null,$buf_type=null,$buf_pixel_space=null,$buf_line_space=null) {
		return Band_WriteRaster($this->_cPtr,$xoff,$yoff,$xsize,$ysize,$buf_len,$buf_xsize,$buf_ysize,$buf_type,$buf_pixel_space,$buf_line_space);
	}

	public function FlushCache() {
		Band_FlushCache($this->_cPtr);
	}

	public function GetRasterColorTable() {
		$r=Band_GetRasterColorTable($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new ColorTable($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function GetColorTable() {
		$r=Band_GetColorTable($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new ColorTable($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function SetRasterColorTable($arg) {
		return Band_SetRasterColorTable($this->_cPtr,$arg);
	}

	public function SetColorTable($arg) {
		return Band_SetColorTable($this->_cPtr,$arg);
	}

	public function GetDefaultRAT() {
		$r=Band_GetDefaultRAT($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new RasterAttributeTable($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function SetDefaultRAT($table) {
		return Band_SetDefaultRAT($this->_cPtr,$table);
	}

	public function GetMaskBand() {
		$r=Band_GetMaskBand($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new Band($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function GetMaskFlags() {
		return Band_GetMaskFlags($this->_cPtr);
	}

	public function CreateMaskBand($nFlags) {
		return Band_CreateMaskBand($this->_cPtr,$nFlags);
	}

	public function GetHistogram($min=-0.5,$max=255.5,$buckets=256,$panHistogram=null,$include_out_of_range=0,$approx_ok=1,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 0: case 1: case 2: case 3: case 4: case 5: case 6: $r=Band_GetHistogram($this->_cPtr,$min,$max,$buckets,$panHistogram,$include_out_of_range,$approx_ok); break;
		default: $r=Band_GetHistogram($this->_cPtr,$min,$max,$buckets,$panHistogram,$include_out_of_range,$approx_ok,$callback,$callback_data);
		}
		return $r;
	}

	public function GetDefaultHistogram($min_ret=null,$max_ret=null,$buckets_ret=null,$ppanHistogram=null,$force=1,$callback=null,$callback_data=null) {
		switch (func_num_args()) {
		case 0: case 1: case 2: case 3: case 4: case 5: $r=Band_GetDefaultHistogram($this->_cPtr,$min_ret,$max_ret,$buckets_ret,$ppanHistogram,$force); break;
		default: $r=Band_GetDefaultHistogram($this->_cPtr,$min_ret,$max_ret,$buckets_ret,$ppanHistogram,$force,$callback,$callback_data);
		}
		return $r;
	}

	public function SetDefaultHistogram($min,$max,$buckets_in,$panHistogram_in) {
		return Band_SetDefaultHistogram($this->_cPtr,$min,$max,$buckets_in,$panHistogram_in);
	}

	public function HasArbitraryOverviews() {
		return Band_HasArbitraryOverviews($this->_cPtr);
	}
}

class ColorTable {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	public function __construct($palette=null) {
		if (is_resource($palette) && get_resource_type($palette) === '_p_GDALColorTableShadow') {
			$this->_cPtr=$palette;
			return;
		}
		$this->_cPtr=$r;
		switch (func_num_args()) {
		case 0: $this->_cPtr=new_ColorTable(); break;
		default: $this->_cPtr=new_ColorTable($palette);
		}
	}

	public function c_Clone() {
		$r=ColorTable_c_Clone($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new ColorTable($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function GetPaletteInterpretation() {
		return ColorTable_GetPaletteInterpretation($this->_cPtr);
	}

	public function GetCount() {
		return ColorTable_GetCount($this->_cPtr);
	}

	public function GetColorEntry($entry) {
		$r=ColorTable_GetColorEntry($this->_cPtr,$entry);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new ColorEntry($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function GetColorEntryAsRGB($entry,$centry) {
		return ColorTable_GetColorEntryAsRGB($this->_cPtr,$entry,$centry);
	}

	public function SetColorEntry($entry,$centry) {
		ColorTable_SetColorEntry($this->_cPtr,$entry,$centry);
	}

	public function CreateColorRamp($nStartIndex,$startcolor,$nEndIndex,$endcolor) {
		ColorTable_CreateColorRamp($this->_cPtr,$nStartIndex,$startcolor,$nEndIndex,$endcolor);
	}
}

class RasterAttributeTable {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	public function __construct($res=null) {
		if (is_resource($res) && get_resource_type($res) === '_p_GDALRasterAttributeTableShadow') {
			$this->_cPtr=$res;
			return;
		}
		$this->_cPtr=new_RasterAttributeTable();
	}

	public function c_Clone() {
		$r=RasterAttributeTable_c_Clone($this->_cPtr);
		if (is_resource($r)) {
			$c=substr(get_resource_type($r), (strpos(get_resource_type($r), '__') ? strpos(get_resource_type($r), '__') + 2 : 3));
			if (!class_exists($c)) {
				return new RasterAttributeTable($r);
			}
			return new $c($r);
		}
		return $r;
	}

	public function GetColumnCount() {
		return RasterAttributeTable_GetColumnCount($this->_cPtr);
	}

	public function GetNameOfCol($iCol) {
		return RasterAttributeTable_GetNameOfCol($this->_cPtr,$iCol);
	}

	public function GetUsageOfCol($iCol) {
		return RasterAttributeTable_GetUsageOfCol($this->_cPtr,$iCol);
	}

	public function GetTypeOfCol($iCol) {
		return RasterAttributeTable_GetTypeOfCol($this->_cPtr,$iCol);
	}

	public function GetColOfUsage($eUsage) {
		return RasterAttributeTable_GetColOfUsage($this->_cPtr,$eUsage);
	}

	public function GetRowCount() {
		return RasterAttributeTable_GetRowCount($this->_cPtr);
	}

	public function GetValueAsString($iRow,$iCol) {
		return RasterAttributeTable_GetValueAsString($this->_cPtr,$iRow,$iCol);
	}

	public function GetValueAsInt($iRow,$iCol) {
		return RasterAttributeTable_GetValueAsInt($this->_cPtr,$iRow,$iCol);
	}

	public function GetValueAsDouble($iRow,$iCol) {
		return RasterAttributeTable_GetValueAsDouble($this->_cPtr,$iRow,$iCol);
	}

	public function SetValueAsString($iRow,$iCol,$pszValue) {
		RasterAttributeTable_SetValueAsString($this->_cPtr,$iRow,$iCol,$pszValue);
	}

	public function SetValueAsInt($iRow,$iCol,$nValue) {
		RasterAttributeTable_SetValueAsInt($this->_cPtr,$iRow,$iCol,$nValue);
	}

	public function SetValueAsDouble($iRow,$iCol,$dfValue) {
		RasterAttributeTable_SetValueAsDouble($this->_cPtr,$iRow,$iCol,$dfValue);
	}

	public function SetRowCount($nCount) {
		RasterAttributeTable_SetRowCount($this->_cPtr,$nCount);
	}

	public function CreateColumn($pszName,$eType,$eUsage) {
		return RasterAttributeTable_CreateColumn($this->_cPtr,$pszName,$eType,$eUsage);
	}

	public function GetLinearBinning() {
		return RasterAttributeTable_GetLinearBinning($this->_cPtr);
	}

	public function SetLinearBinning($dfRow0Min,$dfBinSize) {
		return RasterAttributeTable_SetLinearBinning($this->_cPtr,$dfRow0Min,$dfBinSize);
	}

	public function GetRowOfValue($dfValue) {
		return RasterAttributeTable_GetRowOfValue($this->_cPtr,$dfValue);
	}
}

class Transformer {
	public $_cPtr=null;
	protected $_pData=array();

	function __set($var,$value) {
		if ($var === 'thisown') return swig_gdal_alter_newobject($this->_cPtr,$value);
		$this->_pData[$var] = $value;
	}

	function __isset($var) {
		if ($var === 'thisown') return true;
		return array_key_exists($var, $this->_pData);
	}

	function __get($var) {
		if ($var === 'thisown') return swig_gdal_get_newobject($this->_cPtr);
		return $this->_pData[$var];
	}

	public function __construct($src,$dst,$options) {
		if (is_resource($src) && get_resource_type($src) === '_p_GDALTransformerInfoShadow') {
			$this->_cPtr=$src;
			return;
		}
		$this->_cPtr=new_Transformer($src,$dst,$options);
	}

	public function TransformPoint($bDstToSrc,$inout_or_x,$y=null,$z=0.0) {
		switch (func_num_args()) {
		case 2: $r=Transformer_TransformPoint($this->_cPtr,$bDstToSrc,$inout_or_x); break;
		default: $r=Transformer_TransformPoint($this->_cPtr,$bDstToSrc,$inout_or_x,$y,$z);
		}
		return $r;
	}

	public function TransformPoints($bDstToSrc,$nCount,$x,$y,$z,$panSuccess) {
		return Transformer_TransformPoints($this->_cPtr,$bDstToSrc,$nCount,$x,$y,$z,$panSuccess);
	}
}


?>
