! { dg-do run }
!
! Test the fix for PR72709 in which the type of the component 'header' is cast
! as character[1:0], which makes it slightly more difficult than usual to
! obtain the element length. This is one and the same bug as PR70752.
!
! Contributed by 'zmi'  <zmi007@gmail.com>
!
program    read_exp_data
   implicit none

   type experimental_data_t
      integer :: nh = 0
      character(len=:), dimension(:), allocatable :: header

   end type experimental_data_t

   character(*), parameter :: str(3) = ["#Generated by X      ", &
                                        "#from file 'Y'       ", &
                                        "# Experimental 4 mg/g"]
   type(experimental_data_t) :: ex
   integer :: nh_len
   integer :: i


   nh_len = 255
   ex % nh = 3
   allocate(character(len=nh_len) :: ex % header(ex % nh))

   ex % header(1) = str(1)
   ex % header(2) = str(2)
   ex % header(3) = str(3)

! Test that the string length is OK
   if (len (ex%header) .ne. nh_len) stop 1

! Test the array indexing
   do i = 1, ex % nh
      if (trim (ex%header(i)) .ne. trim (str(i))) stop i + 1
   enddo

end program read_exp_data
