/* { dg-do compile } */
/* { dg-require-effective-target analyzer } */
/* { dg-additional-options "-Wno-pedantic" } */

/* See notes in this header.  */
#include "taint-CVE-2011-0521.h"

/* Adapted from drivers/media/dvb/ttpci/av7110_ca.c  */

int dvb_ca_ioctl(struct file *file, unsigned int cmd, void *parg)
{
	struct dvb_device *dvbdev = file->private_data;
	struct av7110 *av7110 = dvbdev->priv;
	unsigned long arg = (unsigned long) parg;

	/* case CA_GET_SLOT_INFO:  */
	{
		ca_slot_info_t *info=(ca_slot_info_t *)parg;

		if (info->num > 1)
			return -EINVAL;
		av7110->ci_slot[info->num].num = info->num; /* { dg-warning "attacker-controlled value" "" { xfail *-*-* } } */
		/* TODO(xfail).  */
		av7110->ci_slot[info->num].type = FW_CI_LL_SUPPORT(av7110->arm_app) ?
							CA_CI_LINK : CA_CI;
		memcpy(info, &av7110->ci_slot[info->num], sizeof(ca_slot_info_t));
	}
	return 0;
}

/* Adapted from drivers/media/dvb/dvb-core/dvbdev.c
   Further simplified from -2; always use an on-stack buffer.  */

static DEFINE_MUTEX(dvbdev_mutex);

int dvb_usercopy(struct file *file,
		 unsigned int cmd, unsigned long arg)
{
	char    sbuf[128];
	void    *parg = sbuf;
	int     err = -EFAULT;
	if (copy_from_user(parg, (void __user *)arg, sizeof(sbuf)))
	  goto out;

	mutex_lock(&dvbdev_mutex);
	if ((err = dvb_ca_ioctl(file, cmd, parg)) == -ENOIOCTLCMD)
		err = -EINVAL;
	mutex_unlock(&dvbdev_mutex);

	if (err < 0)
		goto out;

	if (copy_to_user((void __user *)arg, parg, sizeof(sbuf)))
	  err = -EFAULT;

out:
	return err;
}
