/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.emboss.jemboss.Jemboss;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.SetUpMenuBar;
import org.emboss.jemboss.gui.filetree.LocalAndRemoteFileTreeFrame;
import org.emboss.jemboss.gui.form.Separator;

public class AdvancedOptions
extends JPanel {
    public static JCheckBox prefJNI;
    public static JCheckBox prefShadeGUI;
    public static JCheckBox nimbusLF;
    public static JComboBox jobMgr;
    private JCheckBox saveUserHome;
    private JTextField userHome = new JTextField();
    private JTextField resultsHome = new JTextField();
    private String cwd;
    private String[] time = new String[]{"5 s", "10 s", "15 s", "20 s", "30 s", "60 s"};
    Preferences preferences = Preferences.userNodeForPackage(AdvancedOptions.class);
    private static final String SHADE_GUI = "SHADE_GUI";
    public static final String NIMBUS_LF = "NIMBUS_LF";
    private static final String CALCULATE_JNI_DEPENDENCIES = "CALCULATE_JNI_DEPENDENCIES";
    private static final String SAVE_DIRECTORY_MODIFICATIONS = "SAVE_DIRECTORY_MODIFICATIONS";
    private static final String JOBMANAGER_FREQUENCY = "JOBMANAGER_FREQUENCY";
    JButton setUserHome;
    boolean usersChangedDirectory = false;
    static JDialog dialog;

    public AdvancedOptions(final JembossParams mysettings) {
        this.cwd = mysettings.getUserHome();
        Box bdown = Box.createVerticalBox();
        Box bleft = Box.createHorizontalBox();
        if (this.preferences.getBoolean(NIMBUS_LF, false)) {
            try {
                UIManager.LookAndFeelInfo[] l = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < l.length; ++i) {
                    UIManager.LookAndFeelInfo info = l[i];
                    if (!"Nimbus".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        nimbusLF = new JCheckBox("Use Nimbus Look and Feel if available");
        nimbusLF.setSelected(this.preferences.getBoolean(NIMBUS_LF, false));
        nimbusLF.setToolTipText("Changes applied after Jembos restarted");
        nimbusLF.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AdvancedOptions.this.preferences.putBoolean(AdvancedOptions.NIMBUS_LF, nimbusLF.isSelected());
            }
        });
        bleft.add(nimbusLF);
        bleft.add(Box.createHorizontalGlue());
        bdown.add(bleft);
        bdown.add(Box.createVerticalStrut(4));
        prefShadeGUI = new JCheckBox("Shade unused parameters");
        prefShadeGUI.setSelected(this.preferences.getBoolean(SHADE_GUI, true));
        prefShadeGUI.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AdvancedOptions.this.preferences.putBoolean(AdvancedOptions.SHADE_GUI, prefShadeGUI.isSelected());
            }
        });
        bleft = Box.createHorizontalBox();
        bleft.add(prefShadeGUI);
        bleft.add(Box.createHorizontalGlue());
        bdown.add(bleft);
        bdown.add(Box.createVerticalStrut(4));
        prefJNI = new JCheckBox("Calculate dependencies (JNI)");
        prefJNI.setSelected(this.preferences.getBoolean(CALCULATE_JNI_DEPENDENCIES, true));
        prefJNI.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AdvancedOptions.this.preferences.putBoolean(AdvancedOptions.CALCULATE_JNI_DEPENDENCIES, prefJNI.isSelected());
            }
        });
        bleft = Box.createHorizontalBox();
        bleft.add(prefJNI);
        bleft.add(Box.createHorizontalGlue());
        bdown.add(bleft);
        bdown.add(Box.createVerticalStrut(5));
        jobMgr = new JComboBox<String>(this.time);
        int hgt = new Double(jobMgr.getPreferredSize().getHeight()).intValue();
        jobMgr.setPreferredSize(new Dimension(70, hgt));
        jobMgr.setMaximumSize(new Dimension(70, hgt));
        jobMgr.setSelectedIndex(this.preferences.getInt(JOBMANAGER_FREQUENCY, 2));
        jobMgr.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AdvancedOptions.this.preferences.putInt(AdvancedOptions.JOBMANAGER_FREQUENCY, jobMgr.getSelectedIndex());
            }
        });
        bleft = Box.createHorizontalBox();
        bleft.add(jobMgr);
        JLabel ljobMgr = new JLabel(" Job Manager update frequency");
        ljobMgr.setForeground(Color.black);
        bleft.add(ljobMgr);
        bleft.add(Box.createHorizontalGlue());
        bdown.add(bleft);
        bdown.add(Box.createVerticalStrut(5));
        bdown.add(new Separator(new Dimension(400, 10)));
        bdown.add(Box.createVerticalStrut(5));
        if (!Jemboss.withSoap) {
            bleft = Box.createHorizontalBox();
            JLabel lresults = new JLabel("Local Results Directory:");
            lresults.setToolTipText("Root directory where EMBOSS job results are stored\nKnown as Working Directory in the local file manager");
            lresults.setForeground(Color.black);
            bleft.add(lresults);
            bleft.add(Box.createHorizontalGlue());
            bdown.add(bleft);
            this.resultsHome.setText(mysettings.getResultsHome());
            bleft = Box.createHorizontalBox();
            bleft.add(this.resultsHome);
            bdown.add(bleft);
            JButton setResultsHome = new JButton("Set");
            setResultsHome.setToolTipText("Updates Results Home directory in local file manager\nResults of new EMBOSS jobs are stored in the updated Results Home directory\nTo have your settings persist across Jemboss sessions don't forget to check\n'Remember between Jemboss sessions' option");
            setResultsHome.setEnabled(false);
            bleft = Box.createHorizontalBox();
            bleft.add(setResultsHome);
            bleft.add(Box.createHorizontalGlue());
            bdown.add(bleft);
            this.resultsHome.getDocument().addDocumentListener(new MyDocumentListener(setResultsHome));
            setResultsHome.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AdvancedOptions.this.updateResultsHome(mysettings);
                }
            });
        }
        bleft = Box.createHorizontalBox();
        JLabel lhome = new JLabel("Local Home Directory:");
        lhome.setToolTipText("User Home directory in local file manager");
        lhome.setForeground(Color.black);
        bleft.add(lhome);
        bleft.add(Box.createHorizontalGlue());
        bdown.add(bleft);
        this.userHome.setText(this.cwd);
        bleft = Box.createHorizontalBox();
        bleft.add(this.userHome);
        bdown.add(bleft);
        this.setUserHome = new JButton("Set");
        this.setUserHome.setToolTipText("Updates User Home directory in local file manager\nTo have your settings persist across Jemboss sessions don't forget to check\n'Remember between Jemboss sessions' option");
        this.setUserHome.setEnabled(false);
        this.userHome.getDocument().addDocumentListener(new MyDocumentListener(this.setUserHome));
        bleft = Box.createHorizontalBox();
        bleft.add(this.setUserHome);
        JButton jreset = new JButton("Reset");
        jreset.setToolTipText("Resets User Home directory to its system defaults");
        bleft.add(jreset);
        bleft.add(Box.createHorizontalGlue());
        bdown.add(bleft);
        this.setUserHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptions.this.updateUserHome(mysettings);
            }
        });
        jreset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptions.this.cwd = System.getProperty("user.home");
                mysettings.setUserHome(AdvancedOptions.this.cwd);
                Jemboss.tree.newRoot(AdvancedOptions.this.cwd);
                if (SetUpMenuBar.localAndRemoteTree != null) {
                    LocalAndRemoteFileTreeFrame.getLocalDragTree().newRoot(AdvancedOptions.this.cwd);
                }
                AdvancedOptions.this.userHome.setText(AdvancedOptions.this.cwd);
            }
        });
        this.saveUserHome = new JCheckBox("Remember between Jemboss sessions");
        this.saveUserHome.setToolTipText("If this option is selected\nJemboss records above directory changes\nin the jemboss.properties file under your home directory");
        this.saveUserHome.setSelected(this.preferences.getBoolean(SAVE_DIRECTORY_MODIFICATIONS, true));
        this.saveUserHome.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AdvancedOptions.this.preferences.putBoolean(AdvancedOptions.SAVE_DIRECTORY_MODIFICATIONS, AdvancedOptions.this.saveUserHome.isSelected());
            }
        });
        bleft = Box.createHorizontalBox();
        bleft.add(this.saveUserHome);
        bleft.add(Box.createHorizontalGlue());
        bdown.add(bleft);
        bdown.add(Box.createVerticalStrut(5));
        bdown.add(new Separator(new Dimension(400, 10)));
        bdown.add(Box.createVerticalStrut(5));
        this.add(bdown);
    }

    public String getResultsDirectory() {
        return this.resultsHome.getText();
    }

    public String getHomeDirectory() {
        return this.userHome.getText();
    }

    public void userHomeSave() {
        if (!this.usersChangedDirectory) {
            return;
        }
        String uhome = System.getProperty("user.home");
        String fs = System.getProperty("file.separator");
        String jemProp = uhome + fs + "jemboss.properties";
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(jemProp));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            p.put("user.home", this.getHomeDirectory());
            if (!Jemboss.withSoap) {
                p.put("results.home", this.getResultsDirectory());
            }
            p.store(new FileOutputStream(jemProp), "jemboss properties");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void showDiaolog(final JembossParams mysettings, boolean withSoap, JFrame f, int x, int y) {
        if (dialog == null) {
            dialog = new JDialog((Frame)f, "Advanced Options");
            JButton ok = new JButton("Apply");
            ok.setToolTipText("Applies your change(s) (if any) and closes this dialog");
            JButton cancel = new JButton("Cancel");
            cancel.setToolTipText("Closes this dialog without applying your change(s)");
            Object[] options = new Object[]{ok, cancel};
            JOptionPane optionPane = new JOptionPane(this, -1, 2, null, options, options[0]);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                }
            });
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    AdvancedOptions.this.updateUserHome(mysettings);
                    AdvancedOptions.this.updateResultsHome(mysettings);
                }
            });
            dialog.setLocation(x, y);
            dialog.setContentPane(optionPane);
            dialog.pack();
        }
        dialog.setVisible(true);
    }

    private void updateUserHome(JembossParams mysettings) {
        if (this.getHomeDirectory().equals(mysettings.getUserHome())) {
            return;
        }
        String userHome = this.getHomeDirectory();
        File f = new File(userHome);
        if (f.exists() && f.canRead()) {
            mysettings.setUserHome(userHome);
            this.usersChangedDirectory = true;
            Jemboss.tree.newRoot(userHome);
            if (SetUpMenuBar.localAndRemoteTree != null) {
                LocalAndRemoteFileTreeFrame.getLocalDragTree().newRoot(userHome);
            }
            if (!f.canWrite()) {
                JOptionPane.showMessageDialog(null, "You cannot write to directory: " + userHome, "Warning: Write", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "No access to directory: " + userHome, "Error: accessing User Home directory", 0);
        }
    }

    private void updateResultsHome(JembossParams mysettings) {
        if (Jemboss.withSoap || this.getResultsDirectory().equals(mysettings.getResultsHome())) {
            return;
        }
        String resultsHome = this.getResultsDirectory();
        File f = new File(resultsHome);
        if (f.exists() && f.canRead()) {
            mysettings.setUserHome(resultsHome);
            this.usersChangedDirectory = true;
            Jemboss.tree.newRoot(resultsHome);
            if (SetUpMenuBar.localAndRemoteTree != null) {
                LocalAndRemoteFileTreeFrame.getLocalDragTree().newRoot(resultsHome);
            }
            if (!f.canWrite()) {
                JOptionPane.showMessageDialog(null, "You cannot write to directory: " + resultsHome, "Warning: Write", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "No access to directory: " + resultsHome, "Error: accessing Results Home directory", 0);
        }
    }

    protected class MyDocumentListener
    implements DocumentListener {
        private JButton b;

        public MyDocumentListener(JButton b) {
            this.b = b;
        }

        public void insertUpdate(DocumentEvent e) {
            this.enableJButton(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.enableJButton(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.enableJButton(e);
        }

        private void enableJButton(DocumentEvent e) {
            this.b.setEnabled(true);
        }
    }
}

