/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;

public class FileSave {
    private File f;
    private boolean fileWritten = false;
    private boolean fExists = false;
    private boolean canDo = true;

    public FileSave(File f) {
        this.f = f;
        if (f.exists()) {
            this.fExists = true;
            if (!f.canWrite()) {
                this.canDo = false;
                JOptionPane.showMessageDialog(null, "Unable to overwite file or directory", "Message", 2);
            } else {
                this.canDo = false;
                int ok = JOptionPane.showConfirmDialog(null, f.toString() + " already exists. Overwrite?", "Overwrite file", 0);
                if (ok == 0) {
                    this.canDo = true;
                }
            }
        }
    }

    public void fileSaving(Object file) {
        if (this.canDo) {
            if (file.getClass().equals(String.class)) {
                try {
                    FileWriter out = new FileWriter(this.f);
                    out.write((String)file);
                    out.close();
                    this.fileWritten = true;
                }
                catch (IOException ioe) {
                    this.fileWritten = false;
                }
            } else {
                try {
                    FileOutputStream out = new FileOutputStream(this.f);
                    out.write((byte[])file);
                    out.close();
                    this.fileWritten = true;
                }
                catch (IOException ioe) {
                    this.fileWritten = false;
                }
            }
        }
    }

    public boolean doWrite() {
        return this.canDo;
    }

    public boolean writeOK() {
        return this.fileWritten;
    }

    public boolean fileExists() {
        return this.fExists;
    }
}

