/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/list_test_suite_traversal.hpp
 *
 * @brief [LEVEL: beta] @ref diagnostics::unittest::List_Test_Suite_Traversal class
 *
 * $Id: list_test_suite_traversal.hpp,v 1.12 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @test diagnostics/unittest/test_system/list_test_suite_traversal.t.cpp
 *
 */
#ifndef DIAGNOSTICS__UNITTEST__TEST_SYSTEM__LIST_TEST_SUITE_TRAVERSAL_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__TEST_SYSTEM__LIST_TEST_SUITE_TRAVERSAL_HPP__INCLUDE_GUARD

// used as base class
#include <diagnostics/unittest/test_system/test_suite_traversal.hpp>

// used in the interface by reference
#include <vector>

// used in the interface by reference
#include <string>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

// used in the interface by reference
// <diagnostics/unittest/test_system/test_list_result.hpp>
class Test_List_Result;

/**
 * @class List_Test_Suite_Traversal diagnostics/unittest/test_system/list_test_suite_traversal.hpp
 *
 * @brief Provides a Traversal through a @ref Test_Suite which adds
 * @ref Test_List_Result to a vector which describe the visited
 * Test_Cases which match the mask and build-level. The path in each
 * Test_List_Result will can be used to match the corresponding @ref
 * Test_Case. 
 *
 * In particular, if the traversed Test_Suite comes with an
 * empty-named root-Test_Suite, it is not reflected in the paths (it
 * is also ignored in the matching algorithm of @ref
 * Test_Suite_Traversal).
 *
 * @nosubgrouping
 */
class List_Test_Suite_Traversal :
    public Test_Suite_Traversal
{
    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Types
     * @{
     */
private:
	typedef List_Test_Suite_Traversal Self;
public:
    typedef ::std::vector<Test_List_Result*> Test_List_Results_t;
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Creation
     * @{
     */
public:
    /**
     * @brief do nothing
     *
     * @throw never
     */
    virtual ~List_Test_Suite_Traversal();

    /**
     * @brief takes @a results -- this vector will be expanded each
     * time a call to traverse finds a matching @ref Test_Case.
     *
     * @throw never
     */
    explicit List_Test_Suite_Traversal(Test_List_Results_t & results);

private:
	/**
	 * @brief not available 
	 */
	Self & operator=(Self const & other);
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Hooks
     * @{
     */
protected:
    /**
     * @brief add to @ref m_results a new @ref Test_List_Result
     * corresponding to the visited @ref Test_Case
     *
     * @throw never
     */
    virtual void visit_hook(Test_Case const & test_case,
			    Path_t const & path,
			    Level_t const level);
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Encapsulated State
     * @{
     */
private:
    Test_List_Results_t & m_results;
    // @}
};


UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
