/*
 *  dancer-XML parser
 *  Copyright (C) 2000,2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * memory leak testing module
 * tests leakage of memory through trying to read a file for an infinite
 * amount of time, trying to unload it every time as well.
 */

#include <stdio.h>
#include "dancer-xml.h"
static dxml_element * 
read_open (const char * filename)
{
  FILE * f = fopen (filename, "r");
  dxml_element * e;
  
  if (f)
    {
      e = dxml_read_xml(f);
      fclose(f);
      return e;
    }
  else
    return NULL;
}


int main(int ac, char ** av)
{
  while (1)
    {
      dxml_free_xml(read_open(av[1]));
      printf ("Iteration finished\n");
    }  
}
