DACS_AUTOLOGIN_SSL(8)      DACS Web Services Manual      DACS_AUTOLOGIN_SSL(8)



[1mNAME[0m
       dacs_autologin_ssl - use an SSL client certificate to automatically
       obtain [1mDACS [22mcredentials

[1mSYNOPSIS[0m
       [1mdacs_autologin_ssl [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacs_autologin_ssl [22mCGI program, in conjunction with appropriate
       [1mDACS [22mconfiguration and a valid SSL client certificate, can be used for
       user-transparent [1mDACS [22mauthentication. A user is not prompted for a
       username or password, and no user-visible sign-on procedure takes
       place.

       At present, the program merely acts as glue to indirectly invoke
       [34m[1mdacs_authenticate(8)[0m[1m[22m[2]. Any valid X.509 certificate can be used for
       this purpose, including a self-signed certificate. Please refer to the
       [34m[1mOpenSSL[0m[1m[22m[3] documentation for additional information about certificates.

       This program can be used to automatically and transparently
       authenticate a user that has been issued an SSL client certificate.
       When an unauthenticated user is denied access to a [1mDACS[22m-wrapped
       resource, she can be automatically authenticated and redirected back to
       the resource without any user input or action. This assumes that the
       client certificate is sent automatically by the browser and that no
       additional user prompting is needed by the authenticating jurisdiction.
       For redirection to the original resource to work properly. the original
       request must have used the GET method.

           [1mNote[0m
           The cert style of authentication [4mmust[24m be configured when
           [1mdacs_autologin_ssl [22mis being used as described. See
           [34m[1mdacs_authenticate(8)[0m[1m[22m[4].

[1mOPTIONS[0m
       Only the standard [34m[4mdacsoptions[0m[4m[24m[1] command line arguments are recognized.

   [1mWeb Service Arguments[0m
       [1mdasc_autologin_ssl [22munderstands the following CGI arguments.

       [4mDACS_ERROR_URL[0m
           When [1mdacs_autologin_ssl [22mis invoked as a result of [1mDACS [22mevent
           handling, [4mDACS_ERROR_URL[24m is automatically passed to it by
           [34m[1mdacs_acs(8)[0m[1m[22m[5] and represents the original URL to which access was
           denied. In typical use, [1mdacs_autologin_ssl [22mis configured as the
           handler for a [1mdacs_acs 902 [22merror code (NO_AUTH, "Authentication by
           DACS is required").  [1mdacs_autologin_ssl [22mthen invokes
           [1mdacs_authenticate[22m. If [1mDACS [22mauthentication is successful,
           [1mdacs_authenticate [22mordinarily issues a browser redirect to the value
           of [4mDACS_ERROR_URL[24m and a cookie bearing the credentials are set in
           the browser (but see the [4mNOREDIRECT[24m argument). This argument is
           optional; if not provided, the jurisdiction's configured
           post-authentication action will occur.

       [4mNOREDIRECT[0m
           If this optional argument is present (its value is immaterial),
           [1mdacs_autologin_ssl [22minstructs [1mdacs_authenticate [22mto [4mnot[24m issue a
           browser redirect to the value of [4mDACS_ERROR_URL[24m.

       [4mAUTH_JURISDICTION[0m
           If this optional argument is present, it gives the name of the
           jurisdiction at which authentication should take place. By default,
           [1mdacs_authenticate [22mis invoked at the same jurisdiction as
           [1mdacs_autologin_ssl[22m.

       [4mCERT_NAME_ATTR[0m
           This optional argument explicitly names the attribute in the
           certificate from which to set [4mUSERNAME[24m. The default value is
           [4mSSL_CLIENT_S_DN_CN[24m. It is an error if the specified attribute name
           does not exist. Giving the value of [4mCERT_NAME_ATTR[24m as the empty
           string results in the empty string being passed as the value of
           [4mUSERNAME[24m.

[1mEXAMPLE[0m
       A typical use of [1mdacs_autologin_ssl [22mis to transparently authenticate a
       user via his SSL client certificate.

       In the [1mDACS [22mconfiguration file, dacs.conf, jurisdiction EXAMPLE is
       configured as follows (this excerpt from a configuration file uses
       fictitious domain names):

           <Jurisdiction uri="example.com">

           JURISDICTION_NAME "EXAMPLE"

           ACS_ERROR_HANDLER "NO_AUTH https://example.com/cgi-bin/dacs/dacs_autologin_ssl"

           <!-- Authenticate using an SSL certificate. -->
           <Auth id="cert">
           URL "https://example.com/cgi-bin/dacs/local_cert_authenticate"
           STYLE "cert"
           CONTROL "sufficient"
           CERT_CA_PATH "/usr/local/apache2.2/conf/ssl.crt"
           CERT_NAME_ATTR "SSL_CLIENT_S_DN_CN"
           </Auth>

           </Jurisdiction>

       Assume the following access control rule applies to the request:

           <acl_rule status="enabled">
             <services>
               <service url_pattern='/foo.html'/>
             </services>

             <rule order="allow,deny">
               <allow>
                 user("auth")
               </allow>
             </rule>
           </acl_rule>



       The preceding configuration results in the following behaviour. An
       unauthenticated user accessing foo.html (https://example.com/foo.html)
       is denied access because the rule governing that web page tests for
       authentication and no credentials are sent with the request. As a
       result, the [34m[1mACS_ERROR_HANDLER[0m[1m[22m[6] directive causes the user to be
       redirected to [1mdacs_autologin_ssl[22m, which redirects the user to
       [1mdacs_authenticate[22m, passing arguments as necessary.

       [1mdacs_authenticate [22mthen invokes [34m[1mlocal_cert_authenticate[0m[1m[22m[4], passing it
       the client's certificate. The certificate is validated and a username
       is extracted from it and mapped to a valid [1mDACS [22musername.

       If authentication succeeds, [1mDACS [22mcredentials for the jurisdiction
       EXAMPLE are generated. These credentials are returned to the browser
       within a cookie and the browser is redirected to the value of
       [4mDACS_ERROR_URL[24m (recall that [4mDACS_ERROR_URL[24m was passed to
       [1mdacs_autologin_ssl [22mby [1mdacs_acs [22mwhen the [1m902 [22mhandler was invoked and was
       forwarded to [1mdacs_authenticate[22m). In this example the user is redirected
       to https://example.com/foo.html. Given the rule above, this time the
       user's request for foo.html will be granted.

       [1mdacs_autologin_ssl [22mmay also be used as the target of an explicit
       authentication link. For example:

           <a href="https://example.com/cgi-bin/dacs/dacs_autologin_ssl?\
           AUTH_JURISDICTION=EXAMPLE&\
           DACS_ERROR_URL=https://example.com/cgi-bin/dacs/dacs_current_credentials">Login</a>

       Following the link should result in the user being authenticated and
       redirected to the specified URL.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs_authenticate(8)[0m[1m[22m[2], [34m[1mdacs_acs(8)[0m[1m[22m[5], [34m[1mdacs.conf(5)[0m[1m[22m[7],
       [34m[1mautologin(8)[0m[1m[22m[8]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[9])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[10] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        3. OpenSSL
           http://www.openssl.org

        4. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_cert_authenticate

        5. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        6. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ERROR_HANDLER

        7. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        8. autologin(8)
           http://dacs.dss.ca/man/autologin.8.html

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013             DACS_AUTOLOGIN_SSL(8)
