/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_intr.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:09p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:44 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_intr.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 8:09p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_INTR_H__
#define BCHP_INTR_H__

/***************************************************************************
 *INTR - TGT L2 Interrupt Controller Registers
 ***************************************************************************/
#define BCHP_INTR_INTR_STATUS                    0x00500700 /* Interrupt Status Register */
#define BCHP_INTR_INTR_SET                       0x00500704 /* Interrupt Set Register */
#define BCHP_INTR_INTR_CLR_REG                   0x00500708 /* Interrupt Clear Register */
#define BCHP_INTR_INTR_MSK_STS_REG               0x0050070c /* Interrupt Mask Status Register */
#define BCHP_INTR_INTR_MSK_SET_REG               0x00500710 /* Interrupt Mask Set Register */
#define BCHP_INTR_INTR_MSK_CLR_REG               0x00500714 /* Interrupt Mask Clear Register */
#define BCHP_INTR_EOI_CTRL                       0x00500718 /* End of interrupt control register */
#define BCHP_INTR_CPU_INTR_STATUS                0x00500720 /* CPU_Interrupt Status Register */
#define BCHP_INTR_CPU_INTR_SET                   0x00500724 /* CPU_Interrupt Set Register */
#define BCHP_INTR_CPU_INTR_CLR_REG               0x00500728 /* CPU_Interrupt Clear Register */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG           0x0050072c /* CPU_Interrupt Mask Status Register */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG           0x00500730 /* CPU Interrupt Mask Set Register */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG           0x00500734 /* CPU Interrupt Mask Clear Register */

/***************************************************************************
 *INTR_STATUS - Interrupt Status Register
 ***************************************************************************/
/* INTR :: INTR_STATUS :: reserved0 [31:27] */
#define BCHP_INTR_INTR_STATUS_reserved0_MASK                       0xf8000000
#define BCHP_INTR_INTR_STATUS_reserved0_SHIFT                      27

/* INTR :: INTR_STATUS :: HAT_INTR [26:26] */
#define BCHP_INTR_INTR_STATUS_HAT_INTR_MASK                        0x04000000
#define BCHP_INTR_INTR_STATUS_HAT_INTR_SHIFT                       26

/* INTR :: INTR_STATUS :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_INTR_STATUS_PCIE_TGT_CA_ATTN_MASK                0x02000000
#define BCHP_INTR_INTR_STATUS_PCIE_TGT_CA_ATTN_SHIFT               25

/* INTR :: INTR_STATUS :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_INTR_STATUS_PCIE_TGT_UR_ATTN_MASK                0x01000000
#define BCHP_INTR_INTR_STATUS_PCIE_TGT_UR_ATTN_SHIFT               24

/* INTR :: INTR_STATUS :: reserved1 [23:20] */
#define BCHP_INTR_INTR_STATUS_reserved1_MASK                       0x00f00000
#define BCHP_INTR_INTR_STATUS_reserved1_SHIFT                      20

/* INTR :: INTR_STATUS :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_INTR_STATUS_ARM_MBOX3_INTR_MASK                  0x00080000
#define BCHP_INTR_INTR_STATUS_ARM_MBOX3_INTR_SHIFT                 19

/* INTR :: INTR_STATUS :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_INTR_STATUS_ARM_MBOX2_INTR_MASK                  0x00040000
#define BCHP_INTR_INTR_STATUS_ARM_MBOX2_INTR_SHIFT                 18

/* INTR :: INTR_STATUS :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_INTR_STATUS_ARM_MBOX1_INTR_MASK                  0x00020000
#define BCHP_INTR_INTR_STATUS_ARM_MBOX1_INTR_SHIFT                 17

/* INTR :: INTR_STATUS :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_INTR_STATUS_ARM_MBOX0_INTR_MASK                  0x00010000
#define BCHP_INTR_INTR_STATUS_ARM_MBOX0_INTR_SHIFT                 16

/* INTR :: INTR_STATUS :: reserved2 [15:14] */
#define BCHP_INTR_INTR_STATUS_reserved2_MASK                       0x0000c000
#define BCHP_INTR_INTR_STATUS_reserved2_SHIFT                      14

/* INTR :: INTR_STATUS :: L1_HIF_RX_DMA_ERR_INTR [13:13] */
#define BCHP_INTR_INTR_STATUS_L1_HIF_RX_DMA_ERR_INTR_MASK          0x00002000
#define BCHP_INTR_INTR_STATUS_L1_HIF_RX_DMA_ERR_INTR_SHIFT         13

/* INTR :: INTR_STATUS :: L1_HIF_RX_DMA_DONE_INTR [12:12] */
#define BCHP_INTR_INTR_STATUS_L1_HIF_RX_DMA_DONE_INTR_MASK         0x00001000
#define BCHP_INTR_INTR_STATUS_L1_HIF_RX_DMA_DONE_INTR_SHIFT        12

/* INTR :: INTR_STATUS :: L1_Y_RX_DMA_ERR_INTR [11:11] */
#define BCHP_INTR_INTR_STATUS_L1_Y_RX_DMA_ERR_INTR_MASK            0x00000800
#define BCHP_INTR_INTR_STATUS_L1_Y_RX_DMA_ERR_INTR_SHIFT           11

/* INTR :: INTR_STATUS :: L1_Y_RX_DMA_DONE_INTR [10:10] */
#define BCHP_INTR_INTR_STATUS_L1_Y_RX_DMA_DONE_INTR_MASK           0x00000400
#define BCHP_INTR_INTR_STATUS_L1_Y_RX_DMA_DONE_INTR_SHIFT          10

/* INTR :: INTR_STATUS :: L1_TX_DMA_ERR_INTR [09:09] */
#define BCHP_INTR_INTR_STATUS_L1_TX_DMA_ERR_INTR_MASK              0x00000200
#define BCHP_INTR_INTR_STATUS_L1_TX_DMA_ERR_INTR_SHIFT             9

/* INTR :: INTR_STATUS :: L1_TX_DMA_DONE_INTR [08:08] */
#define BCHP_INTR_INTR_STATUS_L1_TX_DMA_DONE_INTR_MASK             0x00000100
#define BCHP_INTR_INTR_STATUS_L1_TX_DMA_DONE_INTR_SHIFT            8

/* INTR :: INTR_STATUS :: reserved3 [07:06] */
#define BCHP_INTR_INTR_STATUS_reserved3_MASK                       0x000000c0
#define BCHP_INTR_INTR_STATUS_reserved3_SHIFT                      6

/* INTR :: INTR_STATUS :: L0_HIF_RX_DMA_ERR_INTR [05:05] */
#define BCHP_INTR_INTR_STATUS_L0_HIF_RX_DMA_ERR_INTR_MASK          0x00000020
#define BCHP_INTR_INTR_STATUS_L0_HIF_RX_DMA_ERR_INTR_SHIFT         5

/* INTR :: INTR_STATUS :: L0_HIF_RX_DMA_DONE_INTR [04:04] */
#define BCHP_INTR_INTR_STATUS_L0_HIF_RX_DMA_DONE_INTR_MASK         0x00000010
#define BCHP_INTR_INTR_STATUS_L0_HIF_RX_DMA_DONE_INTR_SHIFT        4

/* INTR :: INTR_STATUS :: L0_Y_RX_DMA_ERR_INTR [03:03] */
#define BCHP_INTR_INTR_STATUS_L0_Y_RX_DMA_ERR_INTR_MASK            0x00000008
#define BCHP_INTR_INTR_STATUS_L0_Y_RX_DMA_ERR_INTR_SHIFT           3

/* INTR :: INTR_STATUS :: L0_Y_RX_DMA_DONE_INTR [02:02] */
#define BCHP_INTR_INTR_STATUS_L0_Y_RX_DMA_DONE_INTR_MASK           0x00000004
#define BCHP_INTR_INTR_STATUS_L0_Y_RX_DMA_DONE_INTR_SHIFT          2

/* INTR :: INTR_STATUS :: L0_TX_DMA_ERR_INTR [01:01] */
#define BCHP_INTR_INTR_STATUS_L0_TX_DMA_ERR_INTR_MASK              0x00000002
#define BCHP_INTR_INTR_STATUS_L0_TX_DMA_ERR_INTR_SHIFT             1

/* INTR :: INTR_STATUS :: L0_TX_DMA_DONE_INTR [00:00] */
#define BCHP_INTR_INTR_STATUS_L0_TX_DMA_DONE_INTR_MASK             0x00000001
#define BCHP_INTR_INTR_STATUS_L0_TX_DMA_DONE_INTR_SHIFT            0

/***************************************************************************
 *INTR_SET - Interrupt Set Register
 ***************************************************************************/
/* INTR :: INTR_SET :: reserved0 [31:27] */
#define BCHP_INTR_INTR_SET_reserved0_MASK                          0xf8000000
#define BCHP_INTR_INTR_SET_reserved0_SHIFT                         27

/* INTR :: INTR_SET :: HAT_INTR [26:26] */
#define BCHP_INTR_INTR_SET_HAT_INTR_MASK                           0x04000000
#define BCHP_INTR_INTR_SET_HAT_INTR_SHIFT                          26

/* INTR :: INTR_SET :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_INTR_SET_PCIE_TGT_CA_ATTN_MASK                   0x02000000
#define BCHP_INTR_INTR_SET_PCIE_TGT_CA_ATTN_SHIFT                  25

/* INTR :: INTR_SET :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_INTR_SET_PCIE_TGT_UR_ATTN_MASK                   0x01000000
#define BCHP_INTR_INTR_SET_PCIE_TGT_UR_ATTN_SHIFT                  24

/* INTR :: INTR_SET :: reserved1 [23:20] */
#define BCHP_INTR_INTR_SET_reserved1_MASK                          0x00f00000
#define BCHP_INTR_INTR_SET_reserved1_SHIFT                         20

/* INTR :: INTR_SET :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_INTR_SET_ARM_MBOX3_INTR_MASK                     0x00080000
#define BCHP_INTR_INTR_SET_ARM_MBOX3_INTR_SHIFT                    19

/* INTR :: INTR_SET :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_INTR_SET_ARM_MBOX2_INTR_MASK                     0x00040000
#define BCHP_INTR_INTR_SET_ARM_MBOX2_INTR_SHIFT                    18

/* INTR :: INTR_SET :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_INTR_SET_ARM_MBOX1_INTR_MASK                     0x00020000
#define BCHP_INTR_INTR_SET_ARM_MBOX1_INTR_SHIFT                    17

/* INTR :: INTR_SET :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_INTR_SET_ARM_MBOX0_INTR_MASK                     0x00010000
#define BCHP_INTR_INTR_SET_ARM_MBOX0_INTR_SHIFT                    16

/* INTR :: INTR_SET :: reserved2 [15:14] */
#define BCHP_INTR_INTR_SET_reserved2_MASK                          0x0000c000
#define BCHP_INTR_INTR_SET_reserved2_SHIFT                         14

/* INTR :: INTR_SET :: HIF_RX_DMA_L1_ERR_INTR [13:13] */
#define BCHP_INTR_INTR_SET_HIF_RX_DMA_L1_ERR_INTR_MASK             0x00002000
#define BCHP_INTR_INTR_SET_HIF_RX_DMA_L1_ERR_INTR_SHIFT            13

/* INTR :: INTR_SET :: HIF_RX_DMA_L1_DONE_INTR [12:12] */
#define BCHP_INTR_INTR_SET_HIF_RX_DMA_L1_DONE_INTR_MASK            0x00001000
#define BCHP_INTR_INTR_SET_HIF_RX_DMA_L1_DONE_INTR_SHIFT           12

/* INTR :: INTR_SET :: Y_RX_DMA_L1_ERR_INTR [11:11] */
#define BCHP_INTR_INTR_SET_Y_RX_DMA_L1_ERR_INTR_MASK               0x00000800
#define BCHP_INTR_INTR_SET_Y_RX_DMA_L1_ERR_INTR_SHIFT              11

/* INTR :: INTR_SET :: Y_RX_DMA_L1_DONE_INTR [10:10] */
#define BCHP_INTR_INTR_SET_Y_RX_DMA_L1_DONE_INTR_MASK              0x00000400
#define BCHP_INTR_INTR_SET_Y_RX_DMA_L1_DONE_INTR_SHIFT             10

/* INTR :: INTR_SET :: TX_DMA_L1_ERR_INTR [09:09] */
#define BCHP_INTR_INTR_SET_TX_DMA_L1_ERR_INTR_MASK                 0x00000200
#define BCHP_INTR_INTR_SET_TX_DMA_L1_ERR_INTR_SHIFT                9

/* INTR :: INTR_SET :: TX_DMA_L1_DONE_INTR [08:08] */
#define BCHP_INTR_INTR_SET_TX_DMA_L1_DONE_INTR_MASK                0x00000100
#define BCHP_INTR_INTR_SET_TX_DMA_L1_DONE_INTR_SHIFT               8

/* INTR :: INTR_SET :: reserved3 [07:06] */
#define BCHP_INTR_INTR_SET_reserved3_MASK                          0x000000c0
#define BCHP_INTR_INTR_SET_reserved3_SHIFT                         6

/* INTR :: INTR_SET :: HIF_RX_DMA_L0_ERR_INTR [05:05] */
#define BCHP_INTR_INTR_SET_HIF_RX_DMA_L0_ERR_INTR_MASK             0x00000020
#define BCHP_INTR_INTR_SET_HIF_RX_DMA_L0_ERR_INTR_SHIFT            5

/* INTR :: INTR_SET :: HIF_RX_DMA_L0_DONE_INTR [04:04] */
#define BCHP_INTR_INTR_SET_HIF_RX_DMA_L0_DONE_INTR_MASK            0x00000010
#define BCHP_INTR_INTR_SET_HIF_RX_DMA_L0_DONE_INTR_SHIFT           4

/* INTR :: INTR_SET :: Y_RX_DMA_L0_ERR_INTR [03:03] */
#define BCHP_INTR_INTR_SET_Y_RX_DMA_L0_ERR_INTR_MASK               0x00000008
#define BCHP_INTR_INTR_SET_Y_RX_DMA_L0_ERR_INTR_SHIFT              3

/* INTR :: INTR_SET :: Y_RX_DMA_L0_DONE_INTR [02:02] */
#define BCHP_INTR_INTR_SET_Y_RX_DMA_L0_DONE_INTR_MASK              0x00000004
#define BCHP_INTR_INTR_SET_Y_RX_DMA_L0_DONE_INTR_SHIFT             2

/* INTR :: INTR_SET :: TX_DMA_L0_ERR_INTR [01:01] */
#define BCHP_INTR_INTR_SET_TX_DMA_L0_ERR_INTR_MASK                 0x00000002
#define BCHP_INTR_INTR_SET_TX_DMA_L0_ERR_INTR_SHIFT                1

/* INTR :: INTR_SET :: TX_DMA_L0_DONE_INTR [00:00] */
#define BCHP_INTR_INTR_SET_TX_DMA_L0_DONE_INTR_MASK                0x00000001
#define BCHP_INTR_INTR_SET_TX_DMA_L0_DONE_INTR_SHIFT               0

/***************************************************************************
 *INTR_CLR_REG - Interrupt Clear Register
 ***************************************************************************/
/* INTR :: INTR_CLR_REG :: reserved0 [31:27] */
#define BCHP_INTR_INTR_CLR_REG_reserved0_MASK                      0xf8000000
#define BCHP_INTR_INTR_CLR_REG_reserved0_SHIFT                     27

/* INTR :: INTR_CLR_REG :: HAT_INTR [26:26] */
#define BCHP_INTR_INTR_CLR_REG_HAT_INTR_MASK                       0x04000000
#define BCHP_INTR_INTR_CLR_REG_HAT_INTR_SHIFT                      26

/* INTR :: INTR_CLR_REG :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_INTR_CLR_REG_PCIE_TGT_CA_ATTN_MASK               0x02000000
#define BCHP_INTR_INTR_CLR_REG_PCIE_TGT_CA_ATTN_SHIFT              25

/* INTR :: INTR_CLR_REG :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_INTR_CLR_REG_PCIE_TGT_UR_ATTN_MASK               0x01000000
#define BCHP_INTR_INTR_CLR_REG_PCIE_TGT_UR_ATTN_SHIFT              24

/* INTR :: INTR_CLR_REG :: reserved1 [23:20] */
#define BCHP_INTR_INTR_CLR_REG_reserved1_MASK                      0x00f00000
#define BCHP_INTR_INTR_CLR_REG_reserved1_SHIFT                     20

/* INTR :: INTR_CLR_REG :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_INTR_CLR_REG_ARM_MBOX3_INTR_MASK                 0x00080000
#define BCHP_INTR_INTR_CLR_REG_ARM_MBOX3_INTR_SHIFT                19

/* INTR :: INTR_CLR_REG :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_INTR_CLR_REG_ARM_MBOX2_INTR_MASK                 0x00040000
#define BCHP_INTR_INTR_CLR_REG_ARM_MBOX2_INTR_SHIFT                18

/* INTR :: INTR_CLR_REG :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_INTR_CLR_REG_ARM_MBOX1_INTR_MASK                 0x00020000
#define BCHP_INTR_INTR_CLR_REG_ARM_MBOX1_INTR_SHIFT                17

/* INTR :: INTR_CLR_REG :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_INTR_CLR_REG_ARM_MBOX0_INTR_MASK                 0x00010000
#define BCHP_INTR_INTR_CLR_REG_ARM_MBOX0_INTR_SHIFT                16

/* INTR :: INTR_CLR_REG :: reserved2 [15:14] */
#define BCHP_INTR_INTR_CLR_REG_reserved2_MASK                      0x0000c000
#define BCHP_INTR_INTR_CLR_REG_reserved2_SHIFT                     14

/* INTR :: INTR_CLR_REG :: L1_HIF_RX_DMA_ERR_INTR_CLR [13:13] */
#define BCHP_INTR_INTR_CLR_REG_L1_HIF_RX_DMA_ERR_INTR_CLR_MASK     0x00002000
#define BCHP_INTR_INTR_CLR_REG_L1_HIF_RX_DMA_ERR_INTR_CLR_SHIFT    13

/* INTR :: INTR_CLR_REG :: L1_HIF_RX_DMA_DONE_INTR_CLR [12:12] */
#define BCHP_INTR_INTR_CLR_REG_L1_HIF_RX_DMA_DONE_INTR_CLR_MASK    0x00001000
#define BCHP_INTR_INTR_CLR_REG_L1_HIF_RX_DMA_DONE_INTR_CLR_SHIFT   12

/* INTR :: INTR_CLR_REG :: L1_Y_RX_DMA_ERR_INTR_CLR [11:11] */
#define BCHP_INTR_INTR_CLR_REG_L1_Y_RX_DMA_ERR_INTR_CLR_MASK       0x00000800
#define BCHP_INTR_INTR_CLR_REG_L1_Y_RX_DMA_ERR_INTR_CLR_SHIFT      11

/* INTR :: INTR_CLR_REG :: L1_Y_RX_DMA_DONE_INTR_CLR [10:10] */
#define BCHP_INTR_INTR_CLR_REG_L1_Y_RX_DMA_DONE_INTR_CLR_MASK      0x00000400
#define BCHP_INTR_INTR_CLR_REG_L1_Y_RX_DMA_DONE_INTR_CLR_SHIFT     10

/* INTR :: INTR_CLR_REG :: L1_TX_DMA_ERR_INTR_CLR [09:09] */
#define BCHP_INTR_INTR_CLR_REG_L1_TX_DMA_ERR_INTR_CLR_MASK         0x00000200
#define BCHP_INTR_INTR_CLR_REG_L1_TX_DMA_ERR_INTR_CLR_SHIFT        9

/* INTR :: INTR_CLR_REG :: L1_TX_DMA_DONE_INTR_CLR [08:08] */
#define BCHP_INTR_INTR_CLR_REG_L1_TX_DMA_DONE_INTR_CLR_MASK        0x00000100
#define BCHP_INTR_INTR_CLR_REG_L1_TX_DMA_DONE_INTR_CLR_SHIFT       8

/* INTR :: INTR_CLR_REG :: reserved3 [07:06] */
#define BCHP_INTR_INTR_CLR_REG_reserved3_MASK                      0x000000c0
#define BCHP_INTR_INTR_CLR_REG_reserved3_SHIFT                     6

/* INTR :: INTR_CLR_REG :: L0_HIF_RX_DMA_ERR_INTR_CLR [05:05] */
#define BCHP_INTR_INTR_CLR_REG_L0_HIF_RX_DMA_ERR_INTR_CLR_MASK     0x00000020
#define BCHP_INTR_INTR_CLR_REG_L0_HIF_RX_DMA_ERR_INTR_CLR_SHIFT    5

/* INTR :: INTR_CLR_REG :: L0_HIF_RX_DMA_DONE_INTR_CLR [04:04] */
#define BCHP_INTR_INTR_CLR_REG_L0_HIF_RX_DMA_DONE_INTR_CLR_MASK    0x00000010
#define BCHP_INTR_INTR_CLR_REG_L0_HIF_RX_DMA_DONE_INTR_CLR_SHIFT   4

/* INTR :: INTR_CLR_REG :: L0_Y_RX_DMA_ERR_INTR_CLR [03:03] */
#define BCHP_INTR_INTR_CLR_REG_L0_Y_RX_DMA_ERR_INTR_CLR_MASK       0x00000008
#define BCHP_INTR_INTR_CLR_REG_L0_Y_RX_DMA_ERR_INTR_CLR_SHIFT      3

/* INTR :: INTR_CLR_REG :: L0_Y_RX_DMA_DONE_INTR_CLR [02:02] */
#define BCHP_INTR_INTR_CLR_REG_L0_Y_RX_DMA_DONE_INTR_CLR_MASK      0x00000004
#define BCHP_INTR_INTR_CLR_REG_L0_Y_RX_DMA_DONE_INTR_CLR_SHIFT     2

/* INTR :: INTR_CLR_REG :: L0_TX_DMA_ERR_INTR_CLR [01:01] */
#define BCHP_INTR_INTR_CLR_REG_L0_TX_DMA_ERR_INTR_CLR_MASK         0x00000002
#define BCHP_INTR_INTR_CLR_REG_L0_TX_DMA_ERR_INTR_CLR_SHIFT        1

/* INTR :: INTR_CLR_REG :: L0_TX_DMA_DONE_INTR_CLR [00:00] */
#define BCHP_INTR_INTR_CLR_REG_L0_TX_DMA_DONE_INTR_CLR_MASK        0x00000001
#define BCHP_INTR_INTR_CLR_REG_L0_TX_DMA_DONE_INTR_CLR_SHIFT       0

/***************************************************************************
 *INTR_MSK_STS_REG - Interrupt Mask Status Register
 ***************************************************************************/
/* INTR :: INTR_MSK_STS_REG :: reserved0 [31:27] */
#define BCHP_INTR_INTR_MSK_STS_REG_reserved0_MASK                  0xf8000000
#define BCHP_INTR_INTR_MSK_STS_REG_reserved0_SHIFT                 27

/* INTR :: INTR_MSK_STS_REG :: HAT_INTR [26:26] */
#define BCHP_INTR_INTR_MSK_STS_REG_HAT_INTR_MASK                   0x04000000
#define BCHP_INTR_INTR_MSK_STS_REG_HAT_INTR_SHIFT                  26

/* INTR :: INTR_MSK_STS_REG :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_INTR_MSK_STS_REG_PCIE_TGT_CA_ATTN_MASK           0x02000000
#define BCHP_INTR_INTR_MSK_STS_REG_PCIE_TGT_CA_ATTN_SHIFT          25

/* INTR :: INTR_MSK_STS_REG :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_INTR_MSK_STS_REG_PCIE_TGT_UR_ATTN_MASK           0x01000000
#define BCHP_INTR_INTR_MSK_STS_REG_PCIE_TGT_UR_ATTN_SHIFT          24

/* INTR :: INTR_MSK_STS_REG :: reserved1 [23:20] */
#define BCHP_INTR_INTR_MSK_STS_REG_reserved1_MASK                  0x00f00000
#define BCHP_INTR_INTR_MSK_STS_REG_reserved1_SHIFT                 20

/* INTR :: INTR_MSK_STS_REG :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_INTR_MSK_STS_REG_ARM_MBOX3_INTR_MASK             0x00080000
#define BCHP_INTR_INTR_MSK_STS_REG_ARM_MBOX3_INTR_SHIFT            19

/* INTR :: INTR_MSK_STS_REG :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_INTR_MSK_STS_REG_ARM_MBOX2_INTR_MASK             0x00040000
#define BCHP_INTR_INTR_MSK_STS_REG_ARM_MBOX2_INTR_SHIFT            18

/* INTR :: INTR_MSK_STS_REG :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_INTR_MSK_STS_REG_ARM_MBOX1_INTR_MASK             0x00020000
#define BCHP_INTR_INTR_MSK_STS_REG_ARM_MBOX1_INTR_SHIFT            17

/* INTR :: INTR_MSK_STS_REG :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_INTR_MSK_STS_REG_ARM_MBOX0_INTR_MASK             0x00010000
#define BCHP_INTR_INTR_MSK_STS_REG_ARM_MBOX0_INTR_SHIFT            16

/* INTR :: INTR_MSK_STS_REG :: reserved2 [15:14] */
#define BCHP_INTR_INTR_MSK_STS_REG_reserved2_MASK                  0x0000c000
#define BCHP_INTR_INTR_MSK_STS_REG_reserved2_SHIFT                 14

/* INTR :: INTR_MSK_STS_REG :: L1_HIF_RX_DMA_ERR_INTR_MSK [13:13] */
#define BCHP_INTR_INTR_MSK_STS_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_MASK 0x00002000
#define BCHP_INTR_INTR_MSK_STS_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_SHIFT 13

/* INTR :: INTR_MSK_STS_REG :: L1_HIF_RX_DMA_DONE_INTR_MSK [12:12] */
#define BCHP_INTR_INTR_MSK_STS_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_MASK 0x00001000
#define BCHP_INTR_INTR_MSK_STS_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_SHIFT 12

/* INTR :: INTR_MSK_STS_REG :: LIST1_Y_RX_DMA_ERR_INTR_MSK [11:11] */
#define BCHP_INTR_INTR_MSK_STS_REG_LIST1_Y_RX_DMA_ERR_INTR_MSK_MASK 0x00000800
#define BCHP_INTR_INTR_MSK_STS_REG_LIST1_Y_RX_DMA_ERR_INTR_MSK_SHIFT 11

/* INTR :: INTR_MSK_STS_REG :: L1_Y_RX_DMA_DONE_INTR_MSK [10:10] */
#define BCHP_INTR_INTR_MSK_STS_REG_L1_Y_RX_DMA_DONE_INTR_MSK_MASK  0x00000400
#define BCHP_INTR_INTR_MSK_STS_REG_L1_Y_RX_DMA_DONE_INTR_MSK_SHIFT 10

/* INTR :: INTR_MSK_STS_REG :: L1_TX_DMA_ERR_INTR_MSK [09:09] */
#define BCHP_INTR_INTR_MSK_STS_REG_L1_TX_DMA_ERR_INTR_MSK_MASK     0x00000200
#define BCHP_INTR_INTR_MSK_STS_REG_L1_TX_DMA_ERR_INTR_MSK_SHIFT    9

/* INTR :: INTR_MSK_STS_REG :: L1_TX_DMA_DONE_INTR_MSK [08:08] */
#define BCHP_INTR_INTR_MSK_STS_REG_L1_TX_DMA_DONE_INTR_MSK_MASK    0x00000100
#define BCHP_INTR_INTR_MSK_STS_REG_L1_TX_DMA_DONE_INTR_MSK_SHIFT   8

/* INTR :: INTR_MSK_STS_REG :: reserved3 [07:06] */
#define BCHP_INTR_INTR_MSK_STS_REG_reserved3_MASK                  0x000000c0
#define BCHP_INTR_INTR_MSK_STS_REG_reserved3_SHIFT                 6

/* INTR :: INTR_MSK_STS_REG :: L0_HIF_RX_DMA_ERR_INTR_MSK [05:05] */
#define BCHP_INTR_INTR_MSK_STS_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_MASK 0x00000020
#define BCHP_INTR_INTR_MSK_STS_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_SHIFT 5

/* INTR :: INTR_MSK_STS_REG :: L0_HIF_RX_DMA_DONE_INTR_MSK [04:04] */
#define BCHP_INTR_INTR_MSK_STS_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_MASK 0x00000010
#define BCHP_INTR_INTR_MSK_STS_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_SHIFT 4

/* INTR :: INTR_MSK_STS_REG :: LIST0_Y_RX_DMA_ERR_INTR_MSK [03:03] */
#define BCHP_INTR_INTR_MSK_STS_REG_LIST0_Y_RX_DMA_ERR_INTR_MSK_MASK 0x00000008
#define BCHP_INTR_INTR_MSK_STS_REG_LIST0_Y_RX_DMA_ERR_INTR_MSK_SHIFT 3

/* INTR :: INTR_MSK_STS_REG :: L0_Y_RX_DMA_DONE_INTR_MSK [02:02] */
#define BCHP_INTR_INTR_MSK_STS_REG_L0_Y_RX_DMA_DONE_INTR_MSK_MASK  0x00000004
#define BCHP_INTR_INTR_MSK_STS_REG_L0_Y_RX_DMA_DONE_INTR_MSK_SHIFT 2

/* INTR :: INTR_MSK_STS_REG :: L0_TX_DMA_ERR_INTR_MSK [01:01] */
#define BCHP_INTR_INTR_MSK_STS_REG_L0_TX_DMA_ERR_INTR_MSK_MASK     0x00000002
#define BCHP_INTR_INTR_MSK_STS_REG_L0_TX_DMA_ERR_INTR_MSK_SHIFT    1

/* INTR :: INTR_MSK_STS_REG :: L0_TX_DMA_DONE_INTR_MSK [00:00] */
#define BCHP_INTR_INTR_MSK_STS_REG_L0_TX_DMA_DONE_INTR_MSK_MASK    0x00000001
#define BCHP_INTR_INTR_MSK_STS_REG_L0_TX_DMA_DONE_INTR_MSK_SHIFT   0

/***************************************************************************
 *INTR_MSK_SET_REG - Interrupt Mask Set Register
 ***************************************************************************/
/* INTR :: INTR_MSK_SET_REG :: reserved0 [31:27] */
#define BCHP_INTR_INTR_MSK_SET_REG_reserved0_MASK                  0xf8000000
#define BCHP_INTR_INTR_MSK_SET_REG_reserved0_SHIFT                 27

/* INTR :: INTR_MSK_SET_REG :: HAT_INTR [26:26] */
#define BCHP_INTR_INTR_MSK_SET_REG_HAT_INTR_MASK                   0x04000000
#define BCHP_INTR_INTR_MSK_SET_REG_HAT_INTR_SHIFT                  26

/* INTR :: INTR_MSK_SET_REG :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_INTR_MSK_SET_REG_PCIE_TGT_CA_ATTN_MASK           0x02000000
#define BCHP_INTR_INTR_MSK_SET_REG_PCIE_TGT_CA_ATTN_SHIFT          25

/* INTR :: INTR_MSK_SET_REG :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_INTR_MSK_SET_REG_PCIE_TGT_UR_ATTN_MASK           0x01000000
#define BCHP_INTR_INTR_MSK_SET_REG_PCIE_TGT_UR_ATTN_SHIFT          24

/* INTR :: INTR_MSK_SET_REG :: reserved1 [23:20] */
#define BCHP_INTR_INTR_MSK_SET_REG_reserved1_MASK                  0x00f00000
#define BCHP_INTR_INTR_MSK_SET_REG_reserved1_SHIFT                 20

/* INTR :: INTR_MSK_SET_REG :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_INTR_MSK_SET_REG_ARM_MBOX3_INTR_MASK             0x00080000
#define BCHP_INTR_INTR_MSK_SET_REG_ARM_MBOX3_INTR_SHIFT            19

/* INTR :: INTR_MSK_SET_REG :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_INTR_MSK_SET_REG_ARM_MBOX2_INTR_MASK             0x00040000
#define BCHP_INTR_INTR_MSK_SET_REG_ARM_MBOX2_INTR_SHIFT            18

/* INTR :: INTR_MSK_SET_REG :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_INTR_MSK_SET_REG_ARM_MBOX1_INTR_MASK             0x00020000
#define BCHP_INTR_INTR_MSK_SET_REG_ARM_MBOX1_INTR_SHIFT            17

/* INTR :: INTR_MSK_SET_REG :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_INTR_MSK_SET_REG_ARM_MBOX0_INTR_MASK             0x00010000
#define BCHP_INTR_INTR_MSK_SET_REG_ARM_MBOX0_INTR_SHIFT            16

/* INTR :: INTR_MSK_SET_REG :: reserved2 [15:14] */
#define BCHP_INTR_INTR_MSK_SET_REG_reserved2_MASK                  0x0000c000
#define BCHP_INTR_INTR_MSK_SET_REG_reserved2_SHIFT                 14

/* INTR :: INTR_MSK_SET_REG :: L1_HIF_RX_DMA_ERR_INTR_MSK_SET [13:13] */
#define BCHP_INTR_INTR_MSK_SET_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_SET_MASK 0x00002000
#define BCHP_INTR_INTR_MSK_SET_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_SET_SHIFT 13

/* INTR :: INTR_MSK_SET_REG :: L1_HIF_RX_DMA_DONE_INTR_MSK_SET [12:12] */
#define BCHP_INTR_INTR_MSK_SET_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_SET_MASK 0x00001000
#define BCHP_INTR_INTR_MSK_SET_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_SET_SHIFT 12

/* INTR :: INTR_MSK_SET_REG :: L1_Y_RX_DMA_ERR_INTR_MSK_SET [11:11] */
#define BCHP_INTR_INTR_MSK_SET_REG_L1_Y_RX_DMA_ERR_INTR_MSK_SET_MASK 0x00000800
#define BCHP_INTR_INTR_MSK_SET_REG_L1_Y_RX_DMA_ERR_INTR_MSK_SET_SHIFT 11

/* INTR :: INTR_MSK_SET_REG :: L1_Y_RX_DMA_DONE_INTR_MSK_SET [10:10] */
#define BCHP_INTR_INTR_MSK_SET_REG_L1_Y_RX_DMA_DONE_INTR_MSK_SET_MASK 0x00000400
#define BCHP_INTR_INTR_MSK_SET_REG_L1_Y_RX_DMA_DONE_INTR_MSK_SET_SHIFT 10

/* INTR :: INTR_MSK_SET_REG :: L1_TX_DMA_ERR_INTR_MSK_SET [09:09] */
#define BCHP_INTR_INTR_MSK_SET_REG_L1_TX_DMA_ERR_INTR_MSK_SET_MASK 0x00000200
#define BCHP_INTR_INTR_MSK_SET_REG_L1_TX_DMA_ERR_INTR_MSK_SET_SHIFT 9

/* INTR :: INTR_MSK_SET_REG :: L1_TX_DMA_DONE_INTR_MSK_SET [08:08] */
#define BCHP_INTR_INTR_MSK_SET_REG_L1_TX_DMA_DONE_INTR_MSK_SET_MASK 0x00000100
#define BCHP_INTR_INTR_MSK_SET_REG_L1_TX_DMA_DONE_INTR_MSK_SET_SHIFT 8

/* INTR :: INTR_MSK_SET_REG :: reserved3 [07:06] */
#define BCHP_INTR_INTR_MSK_SET_REG_reserved3_MASK                  0x000000c0
#define BCHP_INTR_INTR_MSK_SET_REG_reserved3_SHIFT                 6

/* INTR :: INTR_MSK_SET_REG :: L0_HIF_RX_DMA_ERR_INTR_MSK_SET [05:05] */
#define BCHP_INTR_INTR_MSK_SET_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_SET_MASK 0x00000020
#define BCHP_INTR_INTR_MSK_SET_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_SET_SHIFT 5

/* INTR :: INTR_MSK_SET_REG :: L0_HIF_RX_DMA_DONE_INTR_MSK_SET [04:04] */
#define BCHP_INTR_INTR_MSK_SET_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_SET_MASK 0x00000010
#define BCHP_INTR_INTR_MSK_SET_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_SET_SHIFT 4

/* INTR :: INTR_MSK_SET_REG :: L0_Y_RX_DMA_ERR_INTR_MSK_SET [03:03] */
#define BCHP_INTR_INTR_MSK_SET_REG_L0_Y_RX_DMA_ERR_INTR_MSK_SET_MASK 0x00000008
#define BCHP_INTR_INTR_MSK_SET_REG_L0_Y_RX_DMA_ERR_INTR_MSK_SET_SHIFT 3

/* INTR :: INTR_MSK_SET_REG :: L0_Y_RX_DMA_DONE_INTR_MSK_SET [02:02] */
#define BCHP_INTR_INTR_MSK_SET_REG_L0_Y_RX_DMA_DONE_INTR_MSK_SET_MASK 0x00000004
#define BCHP_INTR_INTR_MSK_SET_REG_L0_Y_RX_DMA_DONE_INTR_MSK_SET_SHIFT 2

/* INTR :: INTR_MSK_SET_REG :: L0_TX_DMA_ERR_INTR_MSK_SET [01:01] */
#define BCHP_INTR_INTR_MSK_SET_REG_L0_TX_DMA_ERR_INTR_MSK_SET_MASK 0x00000002
#define BCHP_INTR_INTR_MSK_SET_REG_L0_TX_DMA_ERR_INTR_MSK_SET_SHIFT 1

/* INTR :: INTR_MSK_SET_REG :: L0_TX_DMA_DONE_INTR_MSK_SET [00:00] */
#define BCHP_INTR_INTR_MSK_SET_REG_L0_TX_DMA_DONE_INTR_MSK_SET_MASK 0x00000001
#define BCHP_INTR_INTR_MSK_SET_REG_L0_TX_DMA_DONE_INTR_MSK_SET_SHIFT 0

/***************************************************************************
 *INTR_MSK_CLR_REG - Interrupt Mask Clear Register
 ***************************************************************************/
/* INTR :: INTR_MSK_CLR_REG :: reserved0 [31:27] */
#define BCHP_INTR_INTR_MSK_CLR_REG_reserved0_MASK                  0xf8000000
#define BCHP_INTR_INTR_MSK_CLR_REG_reserved0_SHIFT                 27

/* INTR :: INTR_MSK_CLR_REG :: HAT_INTR [26:26] */
#define BCHP_INTR_INTR_MSK_CLR_REG_HAT_INTR_MASK                   0x04000000
#define BCHP_INTR_INTR_MSK_CLR_REG_HAT_INTR_SHIFT                  26

/* INTR :: INTR_MSK_CLR_REG :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_INTR_MSK_CLR_REG_PCIE_TGT_CA_ATTN_MASK           0x02000000
#define BCHP_INTR_INTR_MSK_CLR_REG_PCIE_TGT_CA_ATTN_SHIFT          25

/* INTR :: INTR_MSK_CLR_REG :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_INTR_MSK_CLR_REG_PCIE_TGT_UR_ATTN_MASK           0x01000000
#define BCHP_INTR_INTR_MSK_CLR_REG_PCIE_TGT_UR_ATTN_SHIFT          24

/* INTR :: INTR_MSK_CLR_REG :: reserved1 [23:20] */
#define BCHP_INTR_INTR_MSK_CLR_REG_reserved1_MASK                  0x00f00000
#define BCHP_INTR_INTR_MSK_CLR_REG_reserved1_SHIFT                 20

/* INTR :: INTR_MSK_CLR_REG :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_INTR_MSK_CLR_REG_ARM_MBOX3_INTR_MASK             0x00080000
#define BCHP_INTR_INTR_MSK_CLR_REG_ARM_MBOX3_INTR_SHIFT            19

/* INTR :: INTR_MSK_CLR_REG :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_INTR_MSK_CLR_REG_ARM_MBOX2_INTR_MASK             0x00040000
#define BCHP_INTR_INTR_MSK_CLR_REG_ARM_MBOX2_INTR_SHIFT            18

/* INTR :: INTR_MSK_CLR_REG :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_INTR_MSK_CLR_REG_ARM_MBOX1_INTR_MASK             0x00020000
#define BCHP_INTR_INTR_MSK_CLR_REG_ARM_MBOX1_INTR_SHIFT            17

/* INTR :: INTR_MSK_CLR_REG :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_INTR_MSK_CLR_REG_ARM_MBOX0_INTR_MASK             0x00010000
#define BCHP_INTR_INTR_MSK_CLR_REG_ARM_MBOX0_INTR_SHIFT            16

/* INTR :: INTR_MSK_CLR_REG :: reserved2 [15:14] */
#define BCHP_INTR_INTR_MSK_CLR_REG_reserved2_MASK                  0x0000c000
#define BCHP_INTR_INTR_MSK_CLR_REG_reserved2_SHIFT                 14

/* INTR :: INTR_MSK_CLR_REG :: L1_HIF_RX_DMA_ERR_INTR_MSK_CLR [13:13] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_CLR_MASK 0x00002000
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_CLR_SHIFT 13

/* INTR :: INTR_MSK_CLR_REG :: L1_HIF_RX_DMA_DONE_INTR_MSK_CLR [12:12] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_CLR_MASK 0x00001000
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_CLR_SHIFT 12

/* INTR :: INTR_MSK_CLR_REG :: L1_Y_RX_DMA_ERR_INTR_MSK_CLR [11:11] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_Y_RX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000800
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_Y_RX_DMA_ERR_INTR_MSK_CLR_SHIFT 11

/* INTR :: INTR_MSK_CLR_REG :: L1_Y_RX_DMA_DONE_INTR_MSK_CLR [10:10] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_Y_RX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000400
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_Y_RX_DMA_DONE_INTR_MSK_CLR_SHIFT 10

/* INTR :: INTR_MSK_CLR_REG :: L1_TX_DMA_ERR_INTR_MSK_CLR [09:09] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_TX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000200
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_TX_DMA_ERR_INTR_MSK_CLR_SHIFT 9

/* INTR :: INTR_MSK_CLR_REG :: L1_TX_DMA_DONE_INTR_MSK_CLR [08:08] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_TX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000100
#define BCHP_INTR_INTR_MSK_CLR_REG_L1_TX_DMA_DONE_INTR_MSK_CLR_SHIFT 8

/* INTR :: INTR_MSK_CLR_REG :: reserved3 [07:06] */
#define BCHP_INTR_INTR_MSK_CLR_REG_reserved3_MASK                  0x000000c0
#define BCHP_INTR_INTR_MSK_CLR_REG_reserved3_SHIFT                 6

/* INTR :: INTR_MSK_CLR_REG :: L0_HIF_RX_DMA_ERR_INTR_MSK_CLR [05:05] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000020
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_CLR_SHIFT 5

/* INTR :: INTR_MSK_CLR_REG :: L0_HIF_RX_DMA_DONE_INTR_MSK_CLR [04:04] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000010
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_CLR_SHIFT 4

/* INTR :: INTR_MSK_CLR_REG :: L0_Y_RX_DMA_ERR_INTR_MSK_CLR [03:03] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_Y_RX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000008
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_Y_RX_DMA_ERR_INTR_MSK_CLR_SHIFT 3

/* INTR :: INTR_MSK_CLR_REG :: L0_Y_RX_DMA_DONE_INTR_MSK_CLR [02:02] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_Y_RX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000004
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_Y_RX_DMA_DONE_INTR_MSK_CLR_SHIFT 2

/* INTR :: INTR_MSK_CLR_REG :: L0_TX_DMA_ERR_INTR_MSK_CLR [01:01] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_TX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000002
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_TX_DMA_ERR_INTR_MSK_CLR_SHIFT 1

/* INTR :: INTR_MSK_CLR_REG :: L0_TX_DMA_DONE_INTR_MSK_CLR [00:00] */
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_TX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000001
#define BCHP_INTR_INTR_MSK_CLR_REG_L0_TX_DMA_DONE_INTR_MSK_CLR_SHIFT 0

/***************************************************************************
 *EOI_CTRL - End of interrupt control register
 ***************************************************************************/
/* INTR :: EOI_CTRL :: reserved0 [31:01] */
#define BCHP_INTR_EOI_CTRL_reserved0_MASK                          0xfffffffe
#define BCHP_INTR_EOI_CTRL_reserved0_SHIFT                         1

/* INTR :: EOI_CTRL :: EOI [00:00] */
#define BCHP_INTR_EOI_CTRL_EOI_MASK                                0x00000001
#define BCHP_INTR_EOI_CTRL_EOI_SHIFT                               0

/***************************************************************************
 *CPU_INTR_STATUS - CPU_Interrupt Status Register
 ***************************************************************************/
/* INTR :: CPU_INTR_STATUS :: reserved0 [31:27] */
#define BCHP_INTR_CPU_INTR_STATUS_reserved0_MASK                   0xf8000000
#define BCHP_INTR_CPU_INTR_STATUS_reserved0_SHIFT                  27

/* INTR :: CPU_INTR_STATUS :: HAT_INTR [26:26] */
#define BCHP_INTR_CPU_INTR_STATUS_HAT_INTR_MASK                    0x04000000
#define BCHP_INTR_CPU_INTR_STATUS_HAT_INTR_SHIFT                   26

/* INTR :: CPU_INTR_STATUS :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_CPU_INTR_STATUS_PCIE_TGT_CA_ATTN_MASK            0x02000000
#define BCHP_INTR_CPU_INTR_STATUS_PCIE_TGT_CA_ATTN_SHIFT           25

/* INTR :: CPU_INTR_STATUS :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_CPU_INTR_STATUS_PCIE_TGT_UR_ATTN_MASK            0x01000000
#define BCHP_INTR_CPU_INTR_STATUS_PCIE_TGT_UR_ATTN_SHIFT           24

/* INTR :: CPU_INTR_STATUS :: reserved1 [23:20] */
#define BCHP_INTR_CPU_INTR_STATUS_reserved1_MASK                   0x00f00000
#define BCHP_INTR_CPU_INTR_STATUS_reserved1_SHIFT                  20

/* INTR :: CPU_INTR_STATUS :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_CPU_INTR_STATUS_ARM_MBOX3_INTR_MASK              0x00080000
#define BCHP_INTR_CPU_INTR_STATUS_ARM_MBOX3_INTR_SHIFT             19

/* INTR :: CPU_INTR_STATUS :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_CPU_INTR_STATUS_ARM_MBOX2_INTR_MASK              0x00040000
#define BCHP_INTR_CPU_INTR_STATUS_ARM_MBOX2_INTR_SHIFT             18

/* INTR :: CPU_INTR_STATUS :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_CPU_INTR_STATUS_ARM_MBOX1_INTR_MASK              0x00020000
#define BCHP_INTR_CPU_INTR_STATUS_ARM_MBOX1_INTR_SHIFT             17

/* INTR :: CPU_INTR_STATUS :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_CPU_INTR_STATUS_ARM_MBOX0_INTR_MASK              0x00010000
#define BCHP_INTR_CPU_INTR_STATUS_ARM_MBOX0_INTR_SHIFT             16

/* INTR :: CPU_INTR_STATUS :: reserved2 [15:14] */
#define BCHP_INTR_CPU_INTR_STATUS_reserved2_MASK                   0x0000c000
#define BCHP_INTR_CPU_INTR_STATUS_reserved2_SHIFT                  14

/* INTR :: CPU_INTR_STATUS :: L1_HIF_RX_DMA_ERR_INTR [13:13] */
#define BCHP_INTR_CPU_INTR_STATUS_L1_HIF_RX_DMA_ERR_INTR_MASK      0x00002000
#define BCHP_INTR_CPU_INTR_STATUS_L1_HIF_RX_DMA_ERR_INTR_SHIFT     13

/* INTR :: CPU_INTR_STATUS :: L1_HIF_RX_DMA_DONE_INTR [12:12] */
#define BCHP_INTR_CPU_INTR_STATUS_L1_HIF_RX_DMA_DONE_INTR_MASK     0x00001000
#define BCHP_INTR_CPU_INTR_STATUS_L1_HIF_RX_DMA_DONE_INTR_SHIFT    12

/* INTR :: CPU_INTR_STATUS :: L1_Y_RX_DMA_ERR_INTR [11:11] */
#define BCHP_INTR_CPU_INTR_STATUS_L1_Y_RX_DMA_ERR_INTR_MASK        0x00000800
#define BCHP_INTR_CPU_INTR_STATUS_L1_Y_RX_DMA_ERR_INTR_SHIFT       11

/* INTR :: CPU_INTR_STATUS :: L1_Y_RX_DMA_DONE_INTR [10:10] */
#define BCHP_INTR_CPU_INTR_STATUS_L1_Y_RX_DMA_DONE_INTR_MASK       0x00000400
#define BCHP_INTR_CPU_INTR_STATUS_L1_Y_RX_DMA_DONE_INTR_SHIFT      10

/* INTR :: CPU_INTR_STATUS :: L1_TX_DMA_ERR_INTR [09:09] */
#define BCHP_INTR_CPU_INTR_STATUS_L1_TX_DMA_ERR_INTR_MASK          0x00000200
#define BCHP_INTR_CPU_INTR_STATUS_L1_TX_DMA_ERR_INTR_SHIFT         9

/* INTR :: CPU_INTR_STATUS :: L1_TX_DMA_DONE_INTR [08:08] */
#define BCHP_INTR_CPU_INTR_STATUS_L1_TX_DMA_DONE_INTR_MASK         0x00000100
#define BCHP_INTR_CPU_INTR_STATUS_L1_TX_DMA_DONE_INTR_SHIFT        8

/* INTR :: CPU_INTR_STATUS :: reserved3 [07:06] */
#define BCHP_INTR_CPU_INTR_STATUS_reserved3_MASK                   0x000000c0
#define BCHP_INTR_CPU_INTR_STATUS_reserved3_SHIFT                  6

/* INTR :: CPU_INTR_STATUS :: L0_HIF_RX_DMA_ERR_INTR [05:05] */
#define BCHP_INTR_CPU_INTR_STATUS_L0_HIF_RX_DMA_ERR_INTR_MASK      0x00000020
#define BCHP_INTR_CPU_INTR_STATUS_L0_HIF_RX_DMA_ERR_INTR_SHIFT     5

/* INTR :: CPU_INTR_STATUS :: L0_HIF_RX_DMA_DONE_INTR [04:04] */
#define BCHP_INTR_CPU_INTR_STATUS_L0_HIF_RX_DMA_DONE_INTR_MASK     0x00000010
#define BCHP_INTR_CPU_INTR_STATUS_L0_HIF_RX_DMA_DONE_INTR_SHIFT    4

/* INTR :: CPU_INTR_STATUS :: L0_Y_RX_DMA_ERR_INTR [03:03] */
#define BCHP_INTR_CPU_INTR_STATUS_L0_Y_RX_DMA_ERR_INTR_MASK        0x00000008
#define BCHP_INTR_CPU_INTR_STATUS_L0_Y_RX_DMA_ERR_INTR_SHIFT       3

/* INTR :: CPU_INTR_STATUS :: L0_Y_RX_DMA_DONE_INTR [02:02] */
#define BCHP_INTR_CPU_INTR_STATUS_L0_Y_RX_DMA_DONE_INTR_MASK       0x00000004
#define BCHP_INTR_CPU_INTR_STATUS_L0_Y_RX_DMA_DONE_INTR_SHIFT      2

/* INTR :: CPU_INTR_STATUS :: L0_TX_DMA_ERR_INTR [01:01] */
#define BCHP_INTR_CPU_INTR_STATUS_L0_TX_DMA_ERR_INTR_MASK          0x00000002
#define BCHP_INTR_CPU_INTR_STATUS_L0_TX_DMA_ERR_INTR_SHIFT         1

/* INTR :: CPU_INTR_STATUS :: L0_TX_DMA_DONE_INTR [00:00] */
#define BCHP_INTR_CPU_INTR_STATUS_L0_TX_DMA_DONE_INTR_MASK         0x00000001
#define BCHP_INTR_CPU_INTR_STATUS_L0_TX_DMA_DONE_INTR_SHIFT        0

/***************************************************************************
 *CPU_INTR_SET - CPU_Interrupt Set Register
 ***************************************************************************/
/* INTR :: CPU_INTR_SET :: reserved0 [31:27] */
#define BCHP_INTR_CPU_INTR_SET_reserved0_MASK                      0xf8000000
#define BCHP_INTR_CPU_INTR_SET_reserved0_SHIFT                     27

/* INTR :: CPU_INTR_SET :: HAT_INTR [26:26] */
#define BCHP_INTR_CPU_INTR_SET_HAT_INTR_MASK                       0x04000000
#define BCHP_INTR_CPU_INTR_SET_HAT_INTR_SHIFT                      26

/* INTR :: CPU_INTR_SET :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_CPU_INTR_SET_PCIE_TGT_CA_ATTN_MASK               0x02000000
#define BCHP_INTR_CPU_INTR_SET_PCIE_TGT_CA_ATTN_SHIFT              25

/* INTR :: CPU_INTR_SET :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_CPU_INTR_SET_PCIE_TGT_UR_ATTN_MASK               0x01000000
#define BCHP_INTR_CPU_INTR_SET_PCIE_TGT_UR_ATTN_SHIFT              24

/* INTR :: CPU_INTR_SET :: reserved1 [23:20] */
#define BCHP_INTR_CPU_INTR_SET_reserved1_MASK                      0x00f00000
#define BCHP_INTR_CPU_INTR_SET_reserved1_SHIFT                     20

/* INTR :: CPU_INTR_SET :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_CPU_INTR_SET_ARM_MBOX3_INTR_MASK                 0x00080000
#define BCHP_INTR_CPU_INTR_SET_ARM_MBOX3_INTR_SHIFT                19

/* INTR :: CPU_INTR_SET :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_CPU_INTR_SET_ARM_MBOX2_INTR_MASK                 0x00040000
#define BCHP_INTR_CPU_INTR_SET_ARM_MBOX2_INTR_SHIFT                18

/* INTR :: CPU_INTR_SET :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_CPU_INTR_SET_ARM_MBOX1_INTR_MASK                 0x00020000
#define BCHP_INTR_CPU_INTR_SET_ARM_MBOX1_INTR_SHIFT                17

/* INTR :: CPU_INTR_SET :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_CPU_INTR_SET_ARM_MBOX0_INTR_MASK                 0x00010000
#define BCHP_INTR_CPU_INTR_SET_ARM_MBOX0_INTR_SHIFT                16

/* INTR :: CPU_INTR_SET :: reserved2 [15:14] */
#define BCHP_INTR_CPU_INTR_SET_reserved2_MASK                      0x0000c000
#define BCHP_INTR_CPU_INTR_SET_reserved2_SHIFT                     14

/* INTR :: CPU_INTR_SET :: HIF_RX_DMA_L1_ERR_INTR [13:13] */
#define BCHP_INTR_CPU_INTR_SET_HIF_RX_DMA_L1_ERR_INTR_MASK         0x00002000
#define BCHP_INTR_CPU_INTR_SET_HIF_RX_DMA_L1_ERR_INTR_SHIFT        13

/* INTR :: CPU_INTR_SET :: HIF_RX_DMA_L1_DONE_INTR [12:12] */
#define BCHP_INTR_CPU_INTR_SET_HIF_RX_DMA_L1_DONE_INTR_MASK        0x00001000
#define BCHP_INTR_CPU_INTR_SET_HIF_RX_DMA_L1_DONE_INTR_SHIFT       12

/* INTR :: CPU_INTR_SET :: Y_RX_DMA_L1_ERR_INTR [11:11] */
#define BCHP_INTR_CPU_INTR_SET_Y_RX_DMA_L1_ERR_INTR_MASK           0x00000800
#define BCHP_INTR_CPU_INTR_SET_Y_RX_DMA_L1_ERR_INTR_SHIFT          11

/* INTR :: CPU_INTR_SET :: Y_RX_DMA_L1_DONE_INTR [10:10] */
#define BCHP_INTR_CPU_INTR_SET_Y_RX_DMA_L1_DONE_INTR_MASK          0x00000400
#define BCHP_INTR_CPU_INTR_SET_Y_RX_DMA_L1_DONE_INTR_SHIFT         10

/* INTR :: CPU_INTR_SET :: TX_DMA_L1_ERR_INTR [09:09] */
#define BCHP_INTR_CPU_INTR_SET_TX_DMA_L1_ERR_INTR_MASK             0x00000200
#define BCHP_INTR_CPU_INTR_SET_TX_DMA_L1_ERR_INTR_SHIFT            9

/* INTR :: CPU_INTR_SET :: TX_DMA_L1_DONE_INTR [08:08] */
#define BCHP_INTR_CPU_INTR_SET_TX_DMA_L1_DONE_INTR_MASK            0x00000100
#define BCHP_INTR_CPU_INTR_SET_TX_DMA_L1_DONE_INTR_SHIFT           8

/* INTR :: CPU_INTR_SET :: reserved3 [07:06] */
#define BCHP_INTR_CPU_INTR_SET_reserved3_MASK                      0x000000c0
#define BCHP_INTR_CPU_INTR_SET_reserved3_SHIFT                     6

/* INTR :: CPU_INTR_SET :: HIF_RX_DMA_L0_ERR_INTR [05:05] */
#define BCHP_INTR_CPU_INTR_SET_HIF_RX_DMA_L0_ERR_INTR_MASK         0x00000020
#define BCHP_INTR_CPU_INTR_SET_HIF_RX_DMA_L0_ERR_INTR_SHIFT        5

/* INTR :: CPU_INTR_SET :: HIF_RX_DMA_L0_DONE_INTR [04:04] */
#define BCHP_INTR_CPU_INTR_SET_HIF_RX_DMA_L0_DONE_INTR_MASK        0x00000010
#define BCHP_INTR_CPU_INTR_SET_HIF_RX_DMA_L0_DONE_INTR_SHIFT       4

/* INTR :: CPU_INTR_SET :: Y_RX_DMA_L0_ERR_INTR [03:03] */
#define BCHP_INTR_CPU_INTR_SET_Y_RX_DMA_L0_ERR_INTR_MASK           0x00000008
#define BCHP_INTR_CPU_INTR_SET_Y_RX_DMA_L0_ERR_INTR_SHIFT          3

/* INTR :: CPU_INTR_SET :: Y_RX_DMA_L0_DONE_INTR [02:02] */
#define BCHP_INTR_CPU_INTR_SET_Y_RX_DMA_L0_DONE_INTR_MASK          0x00000004
#define BCHP_INTR_CPU_INTR_SET_Y_RX_DMA_L0_DONE_INTR_SHIFT         2

/* INTR :: CPU_INTR_SET :: TX_DMA_L0_ERR_INTR [01:01] */
#define BCHP_INTR_CPU_INTR_SET_TX_DMA_L0_ERR_INTR_MASK             0x00000002
#define BCHP_INTR_CPU_INTR_SET_TX_DMA_L0_ERR_INTR_SHIFT            1

/* INTR :: CPU_INTR_SET :: TX_DMA_L0_DONE_INTR [00:00] */
#define BCHP_INTR_CPU_INTR_SET_TX_DMA_L0_DONE_INTR_MASK            0x00000001
#define BCHP_INTR_CPU_INTR_SET_TX_DMA_L0_DONE_INTR_SHIFT           0

/***************************************************************************
 *CPU_INTR_CLR_REG - CPU_Interrupt Clear Register
 ***************************************************************************/
/* INTR :: CPU_INTR_CLR_REG :: reserved0 [31:27] */
#define BCHP_INTR_CPU_INTR_CLR_REG_reserved0_MASK                  0xf8000000
#define BCHP_INTR_CPU_INTR_CLR_REG_reserved0_SHIFT                 27

/* INTR :: CPU_INTR_CLR_REG :: HAT_INTR [26:26] */
#define BCHP_INTR_CPU_INTR_CLR_REG_HAT_INTR_MASK                   0x04000000
#define BCHP_INTR_CPU_INTR_CLR_REG_HAT_INTR_SHIFT                  26

/* INTR :: CPU_INTR_CLR_REG :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_CPU_INTR_CLR_REG_PCIE_TGT_CA_ATTN_MASK           0x02000000
#define BCHP_INTR_CPU_INTR_CLR_REG_PCIE_TGT_CA_ATTN_SHIFT          25

/* INTR :: CPU_INTR_CLR_REG :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_CPU_INTR_CLR_REG_PCIE_TGT_UR_ATTN_MASK           0x01000000
#define BCHP_INTR_CPU_INTR_CLR_REG_PCIE_TGT_UR_ATTN_SHIFT          24

/* INTR :: CPU_INTR_CLR_REG :: reserved1 [23:20] */
#define BCHP_INTR_CPU_INTR_CLR_REG_reserved1_MASK                  0x00f00000
#define BCHP_INTR_CPU_INTR_CLR_REG_reserved1_SHIFT                 20

/* INTR :: CPU_INTR_CLR_REG :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_CPU_INTR_CLR_REG_ARM_MBOX3_INTR_MASK             0x00080000
#define BCHP_INTR_CPU_INTR_CLR_REG_ARM_MBOX3_INTR_SHIFT            19

/* INTR :: CPU_INTR_CLR_REG :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_CPU_INTR_CLR_REG_ARM_MBOX2_INTR_MASK             0x00040000
#define BCHP_INTR_CPU_INTR_CLR_REG_ARM_MBOX2_INTR_SHIFT            18

/* INTR :: CPU_INTR_CLR_REG :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_CPU_INTR_CLR_REG_ARM_MBOX1_INTR_MASK             0x00020000
#define BCHP_INTR_CPU_INTR_CLR_REG_ARM_MBOX1_INTR_SHIFT            17

/* INTR :: CPU_INTR_CLR_REG :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_CPU_INTR_CLR_REG_ARM_MBOX0_INTR_MASK             0x00010000
#define BCHP_INTR_CPU_INTR_CLR_REG_ARM_MBOX0_INTR_SHIFT            16

/* INTR :: CPU_INTR_CLR_REG :: reserved2 [15:14] */
#define BCHP_INTR_CPU_INTR_CLR_REG_reserved2_MASK                  0x0000c000
#define BCHP_INTR_CPU_INTR_CLR_REG_reserved2_SHIFT                 14

/* INTR :: CPU_INTR_CLR_REG :: L1_HIF_RX_DMA_ERR_INTR_CLR [13:13] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_HIF_RX_DMA_ERR_INTR_CLR_MASK 0x00002000
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_HIF_RX_DMA_ERR_INTR_CLR_SHIFT 13

/* INTR :: CPU_INTR_CLR_REG :: L1_HIF_RX_DMA_DONE_INTR_CLR [12:12] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_HIF_RX_DMA_DONE_INTR_CLR_MASK 0x00001000
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_HIF_RX_DMA_DONE_INTR_CLR_SHIFT 12

/* INTR :: CPU_INTR_CLR_REG :: L1_Y_RX_DMA_ERR_INTR_CLR [11:11] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_Y_RX_DMA_ERR_INTR_CLR_MASK   0x00000800
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_Y_RX_DMA_ERR_INTR_CLR_SHIFT  11

/* INTR :: CPU_INTR_CLR_REG :: L1_Y_RX_DMA_DONE_INTR_CLR [10:10] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_Y_RX_DMA_DONE_INTR_CLR_MASK  0x00000400
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_Y_RX_DMA_DONE_INTR_CLR_SHIFT 10

/* INTR :: CPU_INTR_CLR_REG :: L1_TX_DMA_ERR_INTR_CLR [09:09] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_TX_DMA_ERR_INTR_CLR_MASK     0x00000200
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_TX_DMA_ERR_INTR_CLR_SHIFT    9

/* INTR :: CPU_INTR_CLR_REG :: L1_TX_DMA_DONE_INTR_CLR [08:08] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_TX_DMA_DONE_INTR_CLR_MASK    0x00000100
#define BCHP_INTR_CPU_INTR_CLR_REG_L1_TX_DMA_DONE_INTR_CLR_SHIFT   8

/* INTR :: CPU_INTR_CLR_REG :: reserved3 [07:06] */
#define BCHP_INTR_CPU_INTR_CLR_REG_reserved3_MASK                  0x000000c0
#define BCHP_INTR_CPU_INTR_CLR_REG_reserved3_SHIFT                 6

/* INTR :: CPU_INTR_CLR_REG :: L0_HIF_RX_DMA_ERR_INTR_CLR [05:05] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_HIF_RX_DMA_ERR_INTR_CLR_MASK 0x00000020
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_HIF_RX_DMA_ERR_INTR_CLR_SHIFT 5

/* INTR :: CPU_INTR_CLR_REG :: L0_HIF_RX_DMA_DONE_INTR_CLR [04:04] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_HIF_RX_DMA_DONE_INTR_CLR_MASK 0x00000010
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_HIF_RX_DMA_DONE_INTR_CLR_SHIFT 4

/* INTR :: CPU_INTR_CLR_REG :: L0_Y_RX_DMA_ERR_INTR_CLR [03:03] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_Y_RX_DMA_ERR_INTR_CLR_MASK   0x00000008
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_Y_RX_DMA_ERR_INTR_CLR_SHIFT  3

/* INTR :: CPU_INTR_CLR_REG :: L0_Y_RX_DMA_DONE_INTR_CLR [02:02] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_Y_RX_DMA_DONE_INTR_CLR_MASK  0x00000004
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_Y_RX_DMA_DONE_INTR_CLR_SHIFT 2

/* INTR :: CPU_INTR_CLR_REG :: L0_TX_DMA_ERR_INTR_CLR [01:01] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_TX_DMA_ERR_INTR_CLR_MASK     0x00000002
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_TX_DMA_ERR_INTR_CLR_SHIFT    1

/* INTR :: CPU_INTR_CLR_REG :: L0_TX_DMA_DONE_INTR_CLR [00:00] */
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_TX_DMA_DONE_INTR_CLR_MASK    0x00000001
#define BCHP_INTR_CPU_INTR_CLR_REG_L0_TX_DMA_DONE_INTR_CLR_SHIFT   0

/***************************************************************************
 *CPU_INTR_MSK_STS_REG - CPU_Interrupt Mask Status Register
 ***************************************************************************/
/* INTR :: CPU_INTR_MSK_STS_REG :: reserved0 [31:27] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_reserved0_MASK              0xf8000000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_reserved0_SHIFT             27

/* INTR :: CPU_INTR_MSK_STS_REG :: HAT_INTR [26:26] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_HAT_INTR_MASK               0x04000000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_HAT_INTR_SHIFT              26

/* INTR :: CPU_INTR_MSK_STS_REG :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_PCIE_TGT_CA_ATTN_MASK       0x02000000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_PCIE_TGT_CA_ATTN_SHIFT      25

/* INTR :: CPU_INTR_MSK_STS_REG :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_PCIE_TGT_UR_ATTN_MASK       0x01000000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_PCIE_TGT_UR_ATTN_SHIFT      24

/* INTR :: CPU_INTR_MSK_STS_REG :: reserved1 [23:20] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_reserved1_MASK              0x00f00000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_reserved1_SHIFT             20

/* INTR :: CPU_INTR_MSK_STS_REG :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_ARM_MBOX3_INTR_MASK         0x00080000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_ARM_MBOX3_INTR_SHIFT        19

/* INTR :: CPU_INTR_MSK_STS_REG :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_ARM_MBOX2_INTR_MASK         0x00040000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_ARM_MBOX2_INTR_SHIFT        18

/* INTR :: CPU_INTR_MSK_STS_REG :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_ARM_MBOX1_INTR_MASK         0x00020000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_ARM_MBOX1_INTR_SHIFT        17

/* INTR :: CPU_INTR_MSK_STS_REG :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_ARM_MBOX0_INTR_MASK         0x00010000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_ARM_MBOX0_INTR_SHIFT        16

/* INTR :: CPU_INTR_MSK_STS_REG :: reserved2 [15:14] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_reserved2_MASK              0x0000c000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_reserved2_SHIFT             14

/* INTR :: CPU_INTR_MSK_STS_REG :: L1_HIF_RX_DMA_ERR_INTR_MSK [13:13] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_MASK 0x00002000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_SHIFT 13

/* INTR :: CPU_INTR_MSK_STS_REG :: L1_HIF_RX_DMA_DONE_INTR_MSK [12:12] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_MASK 0x00001000
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_SHIFT 12

/* INTR :: CPU_INTR_MSK_STS_REG :: LIST1_Y_RX_DMA_ERR_INTR_MSK [11:11] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_LIST1_Y_RX_DMA_ERR_INTR_MSK_MASK 0x00000800
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_LIST1_Y_RX_DMA_ERR_INTR_MSK_SHIFT 11

/* INTR :: CPU_INTR_MSK_STS_REG :: L1_Y_RX_DMA_DONE_INTR_MSK [10:10] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_Y_RX_DMA_DONE_INTR_MSK_MASK 0x00000400
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_Y_RX_DMA_DONE_INTR_MSK_SHIFT 10

/* INTR :: CPU_INTR_MSK_STS_REG :: L1_TX_DMA_ERR_INTR_MSK [09:09] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_TX_DMA_ERR_INTR_MSK_MASK 0x00000200
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_TX_DMA_ERR_INTR_MSK_SHIFT 9

/* INTR :: CPU_INTR_MSK_STS_REG :: L1_TX_DMA_DONE_INTR_MSK [08:08] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_TX_DMA_DONE_INTR_MSK_MASK 0x00000100
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L1_TX_DMA_DONE_INTR_MSK_SHIFT 8

/* INTR :: CPU_INTR_MSK_STS_REG :: reserved3 [07:06] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_reserved3_MASK              0x000000c0
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_reserved3_SHIFT             6

/* INTR :: CPU_INTR_MSK_STS_REG :: L0_HIF_RX_DMA_ERR_INTR_MSK [05:05] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_MASK 0x00000020
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_SHIFT 5

/* INTR :: CPU_INTR_MSK_STS_REG :: L0_HIF_RX_DMA_DONE_INTR_MSK [04:04] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_MASK 0x00000010
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_SHIFT 4

/* INTR :: CPU_INTR_MSK_STS_REG :: LIST0_Y_RX_DMA_ERR_INTR_MSK [03:03] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_LIST0_Y_RX_DMA_ERR_INTR_MSK_MASK 0x00000008
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_LIST0_Y_RX_DMA_ERR_INTR_MSK_SHIFT 3

/* INTR :: CPU_INTR_MSK_STS_REG :: L0_Y_RX_DMA_DONE_INTR_MSK [02:02] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_Y_RX_DMA_DONE_INTR_MSK_MASK 0x00000004
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_Y_RX_DMA_DONE_INTR_MSK_SHIFT 2

/* INTR :: CPU_INTR_MSK_STS_REG :: L0_TX_DMA_ERR_INTR_MSK [01:01] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_TX_DMA_ERR_INTR_MSK_MASK 0x00000002
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_TX_DMA_ERR_INTR_MSK_SHIFT 1

/* INTR :: CPU_INTR_MSK_STS_REG :: L0_TX_DMA_DONE_INTR_MSK [00:00] */
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_TX_DMA_DONE_INTR_MSK_MASK 0x00000001
#define BCHP_INTR_CPU_INTR_MSK_STS_REG_L0_TX_DMA_DONE_INTR_MSK_SHIFT 0

/***************************************************************************
 *CPU_INTR_MSK_SET_REG - CPU Interrupt Mask Set Register
 ***************************************************************************/
/* INTR :: CPU_INTR_MSK_SET_REG :: reserved0 [31:27] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_reserved0_MASK              0xf8000000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_reserved0_SHIFT             27

/* INTR :: CPU_INTR_MSK_SET_REG :: HAT_INTR [26:26] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_HAT_INTR_MASK               0x04000000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_HAT_INTR_SHIFT              26

/* INTR :: CPU_INTR_MSK_SET_REG :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_PCIE_TGT_CA_ATTN_MASK       0x02000000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_PCIE_TGT_CA_ATTN_SHIFT      25

/* INTR :: CPU_INTR_MSK_SET_REG :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_PCIE_TGT_UR_ATTN_MASK       0x01000000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_PCIE_TGT_UR_ATTN_SHIFT      24

/* INTR :: CPU_INTR_MSK_SET_REG :: reserved1 [23:20] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_reserved1_MASK              0x00f00000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_reserved1_SHIFT             20

/* INTR :: CPU_INTR_MSK_SET_REG :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_ARM_MBOX3_INTR_MASK         0x00080000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_ARM_MBOX3_INTR_SHIFT        19

/* INTR :: CPU_INTR_MSK_SET_REG :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_ARM_MBOX2_INTR_MASK         0x00040000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_ARM_MBOX2_INTR_SHIFT        18

/* INTR :: CPU_INTR_MSK_SET_REG :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_ARM_MBOX1_INTR_MASK         0x00020000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_ARM_MBOX1_INTR_SHIFT        17

/* INTR :: CPU_INTR_MSK_SET_REG :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_ARM_MBOX0_INTR_MASK         0x00010000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_ARM_MBOX0_INTR_SHIFT        16

/* INTR :: CPU_INTR_MSK_SET_REG :: reserved2 [15:14] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_reserved2_MASK              0x0000c000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_reserved2_SHIFT             14

/* INTR :: CPU_INTR_MSK_SET_REG :: L1_HIF_RX_DMA_ERR_INTR_MSK_SET [13:13] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_SET_MASK 0x00002000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_SET_SHIFT 13

/* INTR :: CPU_INTR_MSK_SET_REG :: L1_HIF_RX_DMA_DONE_INTR_MSK_SET [12:12] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_SET_MASK 0x00001000
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_SET_SHIFT 12

/* INTR :: CPU_INTR_MSK_SET_REG :: L1_Y_RX_DMA_ERR_INTR_MSK_SET [11:11] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_Y_RX_DMA_ERR_INTR_MSK_SET_MASK 0x00000800
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_Y_RX_DMA_ERR_INTR_MSK_SET_SHIFT 11

/* INTR :: CPU_INTR_MSK_SET_REG :: L1_Y_RX_DMA_DONE_INTR_MSK_SET [10:10] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_Y_RX_DMA_DONE_INTR_MSK_SET_MASK 0x00000400
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_Y_RX_DMA_DONE_INTR_MSK_SET_SHIFT 10

/* INTR :: CPU_INTR_MSK_SET_REG :: L1_TX_DMA_ERR_INTR_MSK_SET [09:09] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_TX_DMA_ERR_INTR_MSK_SET_MASK 0x00000200
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_TX_DMA_ERR_INTR_MSK_SET_SHIFT 9

/* INTR :: CPU_INTR_MSK_SET_REG :: L1_TX_DMA_DONE_INTR_MSK_SET [08:08] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_TX_DMA_DONE_INTR_MSK_SET_MASK 0x00000100
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L1_TX_DMA_DONE_INTR_MSK_SET_SHIFT 8

/* INTR :: CPU_INTR_MSK_SET_REG :: reserved3 [07:06] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_reserved3_MASK              0x000000c0
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_reserved3_SHIFT             6

/* INTR :: CPU_INTR_MSK_SET_REG :: L0_HIF_RX_DMA_ERR_INTR_MSK_SET [05:05] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_SET_MASK 0x00000020
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_SET_SHIFT 5

/* INTR :: CPU_INTR_MSK_SET_REG :: L0_HIF_RX_DMA_DONE_INTR_MSK_SET [04:04] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_SET_MASK 0x00000010
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_SET_SHIFT 4

/* INTR :: CPU_INTR_MSK_SET_REG :: L0_Y_RX_DMA_ERR_INTR_MSK_SET [03:03] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_Y_RX_DMA_ERR_INTR_MSK_SET_MASK 0x00000008
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_Y_RX_DMA_ERR_INTR_MSK_SET_SHIFT 3

/* INTR :: CPU_INTR_MSK_SET_REG :: L0_Y_RX_DMA_DONE_INTR_MSK_SET [02:02] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_Y_RX_DMA_DONE_INTR_MSK_SET_MASK 0x00000004
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_Y_RX_DMA_DONE_INTR_MSK_SET_SHIFT 2

/* INTR :: CPU_INTR_MSK_SET_REG :: L0_TX_DMA_ERR_INTR_MSK_SET [01:01] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_TX_DMA_ERR_INTR_MSK_SET_MASK 0x00000002
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_TX_DMA_ERR_INTR_MSK_SET_SHIFT 1

/* INTR :: CPU_INTR_MSK_SET_REG :: L0_TX_DMA_DONE_INTR_MSK_SET [00:00] */
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_TX_DMA_DONE_INTR_MSK_SET_MASK 0x00000001
#define BCHP_INTR_CPU_INTR_MSK_SET_REG_L0_TX_DMA_DONE_INTR_MSK_SET_SHIFT 0

/***************************************************************************
 *CPU_INTR_MSK_CLR_REG - CPU Interrupt Mask Clear Register
 ***************************************************************************/
/* INTR :: CPU_INTR_MSK_CLR_REG :: reserved0 [31:27] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_reserved0_MASK              0xf8000000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_reserved0_SHIFT             27

/* INTR :: CPU_INTR_MSK_CLR_REG :: HAT_INTR [26:26] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_HAT_INTR_MASK               0x04000000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_HAT_INTR_SHIFT              26

/* INTR :: CPU_INTR_MSK_CLR_REG :: PCIE_TGT_CA_ATTN [25:25] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_PCIE_TGT_CA_ATTN_MASK       0x02000000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_PCIE_TGT_CA_ATTN_SHIFT      25

/* INTR :: CPU_INTR_MSK_CLR_REG :: PCIE_TGT_UR_ATTN [24:24] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_PCIE_TGT_UR_ATTN_MASK       0x01000000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_PCIE_TGT_UR_ATTN_SHIFT      24

/* INTR :: CPU_INTR_MSK_CLR_REG :: reserved1 [23:20] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_reserved1_MASK              0x00f00000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_reserved1_SHIFT             20

/* INTR :: CPU_INTR_MSK_CLR_REG :: ARM_MBOX3_INTR [19:19] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_ARM_MBOX3_INTR_MASK         0x00080000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_ARM_MBOX3_INTR_SHIFT        19

/* INTR :: CPU_INTR_MSK_CLR_REG :: ARM_MBOX2_INTR [18:18] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_ARM_MBOX2_INTR_MASK         0x00040000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_ARM_MBOX2_INTR_SHIFT        18

/* INTR :: CPU_INTR_MSK_CLR_REG :: ARM_MBOX1_INTR [17:17] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_ARM_MBOX1_INTR_MASK         0x00020000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_ARM_MBOX1_INTR_SHIFT        17

/* INTR :: CPU_INTR_MSK_CLR_REG :: ARM_MBOX0_INTR [16:16] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_ARM_MBOX0_INTR_MASK         0x00010000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_ARM_MBOX0_INTR_SHIFT        16

/* INTR :: CPU_INTR_MSK_CLR_REG :: reserved2 [15:14] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_reserved2_MASK              0x0000c000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_reserved2_SHIFT             14

/* INTR :: CPU_INTR_MSK_CLR_REG :: L1_HIF_RX_DMA_ERR_INTR_MSK_CLR [13:13] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_CLR_MASK 0x00002000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_HIF_RX_DMA_ERR_INTR_MSK_CLR_SHIFT 13

/* INTR :: CPU_INTR_MSK_CLR_REG :: L1_HIF_RX_DMA_DONE_INTR_MSK_CLR [12:12] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_CLR_MASK 0x00001000
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_HIF_RX_DMA_DONE_INTR_MSK_CLR_SHIFT 12

/* INTR :: CPU_INTR_MSK_CLR_REG :: L1_Y_RX_DMA_ERR_INTR_MSK_CLR [11:11] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_Y_RX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000800
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_Y_RX_DMA_ERR_INTR_MSK_CLR_SHIFT 11

/* INTR :: CPU_INTR_MSK_CLR_REG :: L1_Y_RX_DMA_DONE_INTR_MSK_CLR [10:10] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_Y_RX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000400
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_Y_RX_DMA_DONE_INTR_MSK_CLR_SHIFT 10

/* INTR :: CPU_INTR_MSK_CLR_REG :: L1_TX_DMA_ERR_INTR_MSK_CLR [09:09] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_TX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000200
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_TX_DMA_ERR_INTR_MSK_CLR_SHIFT 9

/* INTR :: CPU_INTR_MSK_CLR_REG :: L1_TX_DMA_DONE_INTR_MSK_CLR [08:08] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_TX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000100
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L1_TX_DMA_DONE_INTR_MSK_CLR_SHIFT 8

/* INTR :: CPU_INTR_MSK_CLR_REG :: reserved3 [07:06] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_reserved3_MASK              0x000000c0
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_reserved3_SHIFT             6

/* INTR :: CPU_INTR_MSK_CLR_REG :: L0_HIF_RX_DMA_ERR_INTR_MSK_CLR [05:05] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000020
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_HIF_RX_DMA_ERR_INTR_MSK_CLR_SHIFT 5

/* INTR :: CPU_INTR_MSK_CLR_REG :: L0_HIF_RX_DMA_DONE_INTR_MSK_CLR [04:04] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000010
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_HIF_RX_DMA_DONE_INTR_MSK_CLR_SHIFT 4

/* INTR :: CPU_INTR_MSK_CLR_REG :: L0_Y_RX_DMA_ERR_INTR_MSK_CLR [03:03] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_Y_RX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000008
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_Y_RX_DMA_ERR_INTR_MSK_CLR_SHIFT 3

/* INTR :: CPU_INTR_MSK_CLR_REG :: L0_Y_RX_DMA_DONE_INTR_MSK_CLR [02:02] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_Y_RX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000004
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_Y_RX_DMA_DONE_INTR_MSK_CLR_SHIFT 2

/* INTR :: CPU_INTR_MSK_CLR_REG :: L0_TX_DMA_ERR_INTR_MSK_CLR [01:01] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_TX_DMA_ERR_INTR_MSK_CLR_MASK 0x00000002
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_TX_DMA_ERR_INTR_MSK_CLR_SHIFT 1

/* INTR :: CPU_INTR_MSK_CLR_REG :: L0_TX_DMA_DONE_INTR_MSK_CLR [00:00] */
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_TX_DMA_DONE_INTR_MSK_CLR_MASK 0x00000001
#define BCHP_INTR_CPU_INTR_MSK_CLR_REG_L0_TX_DMA_DONE_INTR_MSK_CLR_SHIFT 0

#endif /* #ifndef BCHP_INTR_H__ */

/* End of File */
