struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 400,
		.content = "Processor\t: ARMv7 Processor rev 0 (v7l)\n"
			   "processor\t: 0\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "processor\t: 1\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "processor\t: 2\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "processor\t: 3\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 \n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x1\n"
			   "CPU part\t: 0x06f\n"
			   "CPU revision\t: 0\n"
			   "\n"
			   "Hardware\t: QCT APQ8064 MTP\n"
			   "Revision\t: 000a\n"
			   "Serial\t\t: 0000000000000000\n",
	},
	{
		.path = "/system/build.prop",
		.size = 11529,
		.content =
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=KOT49I.E98020i\n"
			"ro.build.display.id=KOT49I.E98020i\n"
			"ro.build.version.incremental=E98020i.1441288955\n"
			"ro.build.version.sdk=19\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.release=4.4.2\n"
			"ro.build.date=Thu Sep  3 23:07:57 KST 2015\n"
			"ro.build.date.utc=1441289277\n"
			"ro.build.type=user\n"
			"ro.build.user=hyunjin0828.hwang\n"
			"ro.build.host=betaserver-desktop\n"
			"ro.build.tags=release-keys\n"
			"ro.product.model=LG-E980\n"
			"ro.product.brand=lge\n"
			"ro.product.name=geefhd_att_us\n"
			"ro.product.device=geefhd\n"
			"ro.product.board=GKATT\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.manufacturer=LGE\n"
			"ro.product.locale.language=en\n"
			"ro.product.locale.region=US\n"
			"ro.wifi.channels=11 11\n"
			"ro.board.platform=msm8960\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=geefhd\n"
			"# Do not try to parse ro.build.description or .fingerprint\n"
			"ro.build.description=geefhd_att_us-user 4.4.2 KOT49I.E98020i E98020i.1441288955 release-keys\n"
			"ro.build.fingerprint=lge/geefhd_att_us/geefhd:4.4.2/KOT49I.E98020i/E98020i.1441288955:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"# end build properties\n"
			"#\n"
			"# from device/lge/geefhd/system.prop\n"
			"#\n"
			"################################################################\n"
			"# COMMON system property for this device (geefhd).\n"
			"# operator-specific property MUST NOT be here.\n"
			"################################################################\n"
			"#\n"
			"# system.prop for surf\n"
			"#\n"
			"\n"
			"rild.libpath=/system/lib/libril-qc-qmi-1.so\n"
			"rild.libargs=-d /dev/smd0\n"
			"persist.rild.nitz_plmn=\n"
			"persist.rild.nitz_long_ons_0=\n"
			"persist.rild.nitz_long_ons_1=\n"
			"persist.rild.nitz_long_ons_2=\n"
			"persist.rild.nitz_long_ons_3=\n"
			"persist.rild.nitz_short_ons_0=\n"
			"persist.rild.nitz_short_ons_1=\n"
			"persist.rild.nitz_short_ons_2=\n"
			"persist.rild.nitz_short_ons_3=\n"
			"ril.subscription.types=NV,RUIM\n"
			"DEVICE_PROVISIONED=1\n"
			"debug.sf.hw=1\n"
			"debug.egl.hw=1\n"
			"debug.composition.type=dyn\n"
			"dalvik.vm.heapsize=36m\n"
			"debug.enable.wl_log=1\n"
			"# 3 layer bypass applied, 2013.01.07\n"
			"debug.mdpcomp.logs=0\n"
			"persist.hwc.mdpcomp.enable=true\n"
			"# 2013-02-02 [GK] default_Web_Browser_set chunghyuk.ahn@lge.com\n"
			"persist.web.set=1\n"
			"# LGE_CHANGE_END\n"
			"\n"
			"#\n"
			"# [GK/G/GV] system Prop for add_power_save in KOR(SKT/KT) added by gangui.lee@lge.com, 20140113\n"
			"#\n"
			"persist.radio.add_power_save=1\n"
			"\n"
			"#\n"
			"# system props for the cne module\n"
			"#\n"
			"persist.cne.feature=1\n"
			"\n"
			"ro.hdmi.enable=true\n"
			"lpa.decode=true\n"
			"tunnel.decode=false\n"
			"tunnel.audiovideo.decode=false\n"
			"lpa.use-stagefright=true\n"
			"qcom.hw.aac.encoder=true\n"
			"\n"
			"#system props for the MM modules\n"
			"\n"
			"media.stagefright.enable-player=true\n"
			"media.stagefright.enable-http=true\n"
			"media.stagefright.enable-aac=true\n"
			"media.stagefright.enable-qcp=true\n"
			"media.stagefright.enable-fma2dp=true\n"
			"media.stagefright.enable-scan=true\n"
			"mmp.enable.3g2=true\n"
			"# Add MOV container feature [hanjun11.cho@lge.com]\n"
			"mmp.enable.mov=true\n"
			"\n"
			"media.aac_51_output_enabled=true\n"
			"#33395 is sum of supported format flags in AAL\n"
			"#Formats: AVI AC3 ASF AAC QCP DTS 3G2\n"
			"mm.enable.qcom_parser=33395\n"
			"\n"
			"#\n"
			"# system props for the data modules\n"
			"#\n"
			"ro.use_data_netmgrd=true\n"
			"\n"
			"#2013-08-31 kwangbin.yim@lge.com LGP_DATA_TEMPORARY_PATCH_FOR_KK_APP_TEST[START]\n"
			"#persist.data.netmgrd.qos.enable=true\n"
			"persist.data.netmgrd.qos.enable=false\n"
			"#2013-08-31 kwangbin.yim@lge.com LGP_DATA_TEMPORARY_PATCH_FOR_KK_APP_TEST[END]\n"
			"\n"
			"#system props for time-services\n"
			"persist.timed.enable=true\n"
			"\n"
			"# System props for audio\n"
			"persist.audio.fluence.mode=endfire\n"
			"persist.audio.vr.enable=false\n"
			"persist.audio.handset.mic=digital\n"
			"persist.audio.lowlatency.rec=false\n"
			"\n"
			"# System prop to select audio resampler quality\n"
			"af.resampler.quality=255\n"
			"# System prop to select MPQAudioPlayer by default on mpq8064\n"
			"#mpq.audio.decode=true\n"
			"\n"
			"#\n"
			"# system prop for opengles version\n"
			"#\n"
			"# 196608 is decimal for 0x30000 to report version 3\n"
			"ro.opengles.version=196608\n"
			"\n"
			"# system prop for requesting Master role in incoming Bluetooth connection.\n"
			"#\n"
			"ro.bluetooth.request.master=true\n"
			"#\n"
			"# system prop for Bluetooth Auto connect for remote initated connections\n"
			"#\n"
			"ro.bluetooth.remote.autoconnect=true\n"
			"# system property for Bluetooth discoverability time out in seconds\n"
			"# 0: Always discoverable\n"
			"#debug.bt.discoverable_time=0\n"
			"\n"
			"# System prop to disable a2dp sink which is enabled by default\n"
			"bluetooth.a2dp.sink.enabled=false\n"
			"\n"
			"#system prop for switching gps driver to qmi\n"
			"persist.gps.qmienabled=true\n"
			"\n"
			"# System property for cabl\n"
			"#LGE_CHANGE_S jh.chun@lge.com 2012.1.4  CABL off\n"
			"ro.qualcomm.cabl=2\n"
			"#LGE_CHANGE_E jh.chun@lge.com 2012.1.4  CABL off\n"
			"\n"
			"# System props for telephony\n"
			"# System prop to turn on CdmaLTEPhone always\n"
			"telephony.lteOnCdmaDevice=1\n"
			"#\n"
			"# System prop for sending transmit power request to RIL during WiFi hotspot on/off\n"
			"#\n"
			"ro.ril.transmitpower=true\n"
			"\n"
			"#\n"
			"#Simulate sdcard on /data/media\n"
			"#\n"
			"# LGE_CHANGE_S\n"
			"# If you use Internal-SD with FUSE, comment-out below\n"
			"# 2012-01-08 warkap.seo@lge.com\n"
			"#persist.fuse_sdcard=false\n"
			"# LGE_CHANGE_E\n"
			"ro.hwui.text_cache_width=2048\n"
			"\n"
			"#\n"
			"# Supports warmboot capabilities\n"
			"#\n"
			"ro.warmboot.capability=1\n"
			"\n"
			"#\n"
			"#snapdragon value add features\n"
			"#\n"
			"ro.qc.sdk.audio.ssr=false\n"
			"ro.qc.sdk.camera.facialproc=true\n"
			"ro.qc.sdk.gestures.camera=false\n"
			"\n"
			"# LGE_CHANGE_S hongsabu.hong@lge.com 2012.4.22  LGE sound profile scenario.\n"
			"ro.lge.audio_soundprofile=true\n"
			"# LGE_CHANGE_E hongsabu.hong@lge.com 2012.4.22  LGE sound profile scenario.\n"
			"\n"
			"#LGBT_COMMON_SCENARIO supported Bluetooth PAN profile 2012-05-22\n"
			"ro.bluetooth.PANenable = 1\n"
			"#LGBT_COMMON_SCENARIO\n"
			"# System prop for sensor\n"
			"ro.qc.sdk.sensors.gestures=true\n"
			"\n"
			"# LGE_CHANGE_S 2012-12-11, chaeuk.lee@lge.com, HDMI block\n"
			"sys.hdmi.block=unblock\n"
			"# LGE_CHANGE_E 2012-12-11, chaeuk.lee@lge.com, HDMI block\n"
			"\n"
			"#hwui properties\n"
			"ro.hwui.texture_cache_size=72\n"
			"\n"
			"#property to check if dynamic resolution change is  supported in framework\n"
			"ro.streaming.video.drs=true\n"
			"#property to enable user to access Google WFD settings.\n"
			"persist.debug.wfd.enable=1\n"
			"#property to choose between virtual/external wfd display\n"
			"persist.sys.wfd.virtual=0\n"
			"\n"
			"#system prop for setting rmnet mux mode\n"
			"persist.rmnet.mux=disabled\n"
			"\n"
			"# LGE_CHANGE_S, [WiFi][hayun.kim@lge.com], 2013-01-22, Wifi Bring Up\n"
			"# reserved wifi related property\n"
			"dhcp.ap.macaddress=\n"
			"dhcp.wlan0.dns1=\n"
			"dhcp.wlan0.dns2=\n"
			"dhcp.wlan0.dns3=\n"
			"dhcp.wlan0.dns4=\n"
			"dhcp.wlan0.gateway=\n"
			"dhcp.wlan0.ipaddress=\n"
			"dhcp.wlan0.leasetime=\n"
			"dhcp.wlan0.mask=\n"
			"dhcp.wlan0.pid=\n"
			"dhcp.wlan0.reason=\n"
			"dhcp.wlan0.result=\n"
			"dhcp.wlan0.server=\n"
			"dhcp.wlan0.vendorInfo=\n"
			"dhcp.p2p.dns1=\n"
			"dhcp.p2p.dns2=\n"
			"dhcp.p2p.dns3=\n"
			"dhcp.p2p.dns4=\n"
			"dhcp.p2p.gateway=\n"
			"dhcp.p2p.ipaddress=\n"
			"dhcp.p2p.leasetime=\n"
			"dhcp.p2p.mask=\n"
			"dhcp.p2p.pid=\n"
			"dhcp.p2p.reason=\n"
			"dhcp.p2p.result=\n"
			"dhcp.p2p.server=\n"
			"dhcp.p2p.vendorInfo=\n"
			"init.svc.dhcpcd_wlan0=\n"
			"init.svc.dhcpcd_p2p=\n"
			"init.svc.p2p_supplicant=\n"
			"init.svc.iprenew_wlan0=\n"
			"net.dns1=\n"
			"net.dns2=\n"
			"net.dnschange=\n"
			"net.p2p-p2p0-0.dns1=\n"
			"net.p2p-p2p0-0.dns2=\n"
			"net.wlan0.dns1=\n"
			"net.wlan0.dns2=\n"
			"wlan.driver.status=\n"
			"persist.sys.security=\n"
			"persist.sys.hotssid.ksc5601=\n"
			"wifi.lge.autochannel=\n"
			"# LGE_CHANGE_S, [WiFi][hayun.kim@lge.com], 2013-01-22, Wifi Bring Up\n"
			"\n"
			"#// LGE_CHANGE_S, [Net_Patch_0300][CALL_FRW][COMMON], 2012-05-25, Airplane Mode Pop-Up display property value {\n"
			"ro.airplane.phoneapp=1\n"
			"#// LGE_CHANGE_E, [Net_Patch_0300][CALL_FRW][COMMON], 2012-05-25, Airplane Mode Pop-Up display property value }\n"
			"\n"
			"\n"
			"#disable gapless mode by default\n"
			"audio.gapless.playback.disable=true\n"
			"\n"
			"# LGE_CHANGE_S [gk][framework][common] the screen auto-brightness adjustment setting\n"
			"persist.power.useautobrightadj=true\n"
			"# LGE_CHANGE_E [gk][framework][common] the screen auto-brightness adjustment setting\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.build.target_operator=ATT\n"
			"ro.build.target_country=US\n"
			"persist.gsm.sms.disablelog=64\n"
			"ro.lge.swversion=E98020i\n"
			"ro.lge.factoryversion=LGE980AT-00-V20i-ATT-US-SEP-03-2015+0\n"
			"ro.config.ringtone=ATT_Firefly.ogg\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.config.notification_sound=Optimus.ogg\n"
			"ro.config.alarm_alert=Lifes_Good_Alarm.ogg\n"
			"ro.com.android.dataroaming=false\n"
			"ro.com.google.clientidbase=android-om-lge\n"
			"ro.com.google.clientidbase.ms=android-att-us\n"
			"ro.com.google.clientidbase.am=android-att-us\n"
			"ro.com.google.clientidbase.gmm=android-om-lge\n"
			"ro.com.google.clientidbase.yt=android-om-lge\n"
			"uicc.mobile_equipment.config=0\n"
			"ro.afwdata.LGfeatureset=ATTBASE\n"
			"ro.radio.ratdisplay=true\n"
			"ro.qc.sdk.audio.fluencetype=fluence\n"
			"persist.data_netmgrd_mtu=1410\n"
			"persist.audio.btsco.wb=false\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"wlan.lge.supportsimaka=yes\n"
			"wifi.lge.hanglessid=false\n"
			"wifi.lge.supportp2p5g=gconly\n"
			"keyguard.no_require_sim=true\n"
			"ro.radio.networkmode=disable\n"
			"ro.radio.topreviousmode=disable\n"
			"ro.radio.check_csp=enable\n"
			"persist.service.ecc.hiddenmenu=\n"
			"ro.monkey=0\n"
			"ime_onehand_keyboard=true\n"
			"ime_split_keyboard=true\n"
			"ime_onehand_keyboard_percent=82\n"
			"ime_split_keyboard_width_dp=702\n"
			"ime_keyboard_layout=ko=QWERTY\n"
			"ime_extend_row_keyboard=true\n"
			"ime_theme=true\n"
			"ro.sdcrypto.syscall=378\n"
			"ro.config.vibrate_type=1\n"
			"lge.hw.frontkeyled=true\n"
			"telephony.lteOnCdmaDevice=0\n"
			"ro.hwui.layer_cache_size=48\n"
			"ro.hwui.r_buffer_cache_size=8\n"
			"ro.hwui.path_cache_size=32\n"
			"ro.hwui.gradient_cache_size=1\n"
			"ro.hwui.drop_shadow_cache_size=6\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_large_cache_height=1024\n"
			"lge.normalizer.param=version2.0/true/6.0/true/7000/1.0/4000/0.33\n"
			"persist.sys.language=en\n"
			"persist.sys.country=US\n"
			"ro.telephony.default_network=9\n"
			"ro.sf.lcd_density=480\n"
			"ro.sf.lcd_density_secondary=400\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapsize=256m\n"
			"dalvik.vm.heaputilization=0.25\n"
			"dalvik.vm.heapidealfree=8388608\n"
			"dalvik.vm.heapconcurrentstart=2097152\n"
			"ro.lge.overlay=true\n"
			"wlan.chip.vendor=brcm\n"
			"wlan.chip.version=bcm4334\n"
			"wifi.lge.patch=true\n"
			"dhcp.dlna.using=false\n"
			"wifi.lge.sleeppolicy=0\n"
			"wifi.lge.offdelay=false\n"
			"wlan.lge.concurrency=MCC\n"
			"wlan.lge.wifidisplay=both\n"
			"ro.lge.vib_magnitude_index=0,20,40,60,80,100,120,127\n"
			"persist.sys.strictmode.disable=true\n"
			"wlan.driver.ath=0\n"
			"wlan.driver.config=/data/misc/wifi/WCNSS_qcom_cfg.ini\n"
			"qcom.audio.init=complete\n"
			"lpa.decode=true\n"
			"persist.sys.ats_start=false\n"
			"persist.sys.strictmode.visual=false\n"
			"lgemm.player.use_android_origin=false\n"
			"ro.lge.audio_scenario=SOUNDEXCEPTION\n"
			"ro.lge.audio_soundexception=true\n"
			"ro.config.vc_call_vol_steps=6\n"
			"ro.config.vc_call_vol_default=3\n"
			"ro.airplane.phoneapp=1\n"
			"ro.lge.basebandversion=APQ8064/MDM9x15M\n"
			"lge.version.verified=NONE\n"
			"persist.service.main.enable=0\n"
			"persist.service.system.enable=0\n"
			"persist.service.radio.enable=0\n"
			"persist.service.events.enable=0\n"
			"persist.service.kernel.enable=0\n"
			"persist.service.packet.enable=0\n"
			"persist.service.crash.enable=0\n"
			"persist.sys.ssr.restart_level=3\n"
			"lge.signed_image=true\n"
			"persist.radio.data_no_toggle=1\n"
			"persist.lg.data.block_ssdp=0\n"
			"net.tethering.noprovisioning=true\n"
			"persist.lg.data.fd=-1\n"
			"ro.carrier=unknown\n"
			"ro.vendor.extension_library=/system/lib/libqc-opt.so\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"ro.lge.ps.eco.pv=322\n"
			"ro.lge.ps.freqlowlimit=1026000\n"
			"drm.service.enabled=true\n"
			"bluetooth.chip.vendor=brcm\n"
			"ro.lge.lcd_default_brightness=152\n"
			"ro.lge.lcd_auto_brightness_mode=false\n"
			"ro.lge.capp_ZDi_O=true\n"
			"lge.zdi.actionsend=false\n"
			"lge.zdi.onactivityresult=true\n"
			"lge.zdi.dragdropintent=false\n"
			"ro.lge.capp_emotional_led=true\n"
			"ro.lge.capp_almond=true\n"
			"ro.lge.qslide.max_window=2\n"
			"ro.lge.capp_wfd=true\n"
			"ro.lge.capp_lgevpn=true\n"
			"ro.com.google.gmsversion=4.4.2_r1\n"
			"ro.setupwizard.mode=DISABLED\n"
			"ro.livewallpaper.map=DISABLED\n"
			"ro.com.google.apphider=off\n"
			"lge.nfc.vendor=nxp\n"
			"persist.sys.dalvik.vm.lib=libdvm.so\n"
			"dalvik.vm.dexopt-flags=m=y\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.qc.sdk.izat.premium_enabled=0\n"
			"ro.qc.sdk.izat.service_mask=0x0\n"
			"persist.gps.qc_nlp_in_use=0\n"
			"ro.gps.agps_provider=1\n"
			"\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-2\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1728000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 107,
		.content =
			"384000 486000 594000 702000 810000 918000 1026000 1134000 1242000 1350000 1458000 1566000 1674000 1728000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1026000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 9,
		.content = "ondemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 142,
		.content = "384000 0\n"
			   "486000 0\n"
			   "594000 0\n"
			   "702000 0\n"
			   "810000 0\n"
			   "918000 0\n"
			   "1026000 22\n"
			   "1134000 20\n"
			   "1242000 2882\n"
			   "1350000 0\n"
			   "1458000 0\n"
			   "1566000 0\n"
			   "1674000 0\n"
			   "1728000 1175\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1728000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 107,
		.content =
			"384000 486000 594000 702000 810000 918000 1026000 1134000 1242000 1350000 1458000 1566000 1674000 1728000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1728000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 9,
		.content = "ondemand\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1728000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 145,
		.content = "384000 11\n"
			   "486000 0\n"
			   "594000 0\n"
			   "702000 0\n"
			   "810000 0\n"
			   "918000 70\n"
			   "1026000 337\n"
			   "1134000 10\n"
			   "1242000 484\n"
			   "1350000 24\n"
			   "1458000 30\n"
			   "1566000 0\n"
			   "1674000 0\n"
			   "1728000 987\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 3,
		.content = "55\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 134,
		.content = "384000 0\n"
			   "486000 0\n"
			   "594000 0\n"
			   "702000 0\n"
			   "810000 0\n"
			   "918000 0\n"
			   "1026000 8\n"
			   "1134000 0\n"
			   "1242000 0\n"
			   "1350000 0\n"
			   "1458000 0\n"
			   "1566000 0\n"
			   "1674000 0\n"
			   "1728000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{NULL},
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "DEVICE_PROVISIONED",
		.value = "1",
	},
	{
		.key = "af.resampler.quality",
		.value = "255",
	},
	{
		.key = "audio.gapless.playback.disable",
		.value = "true",
	},
	{
		.key = "bluetooth.a2dp.sink.enabled",
		.value = "false",
	},
	{
		.key = "bluetooth.chip.vendor",
		.value = "brcm",
	},
	{
		.key = "bluetooth.pan",
		.value = "true",
	},
	{
		.key = "dalvik.vm.dexopt-flags",
		.value = "m=y",
	},
	{
		.key = "dalvik.vm.heapconcurrentstart",
		.value = "2097152",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "128m",
	},
	{
		.key = "dalvik.vm.heapidealfree",
		.value = "8388608",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.heaputilization",
		.value = "0.25",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.composition.type",
		.value = "dyn",
	},
	{
		.key = "debug.egl.hw",
		.value = "1",
	},
	{
		.key = "debug.enable.wl_log",
		.value = "1",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.mdpcomp.logs",
		.value = "0",
	},
	{
		.key = "debug.sf.hw",
		.value = "1",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dhcp.ap.macaddress",
		.value = "",
	},
	{
		.key = "dhcp.dlna.using",
		.value = "false",
	},
	{
		.key = "dhcp.p2p.dns1",
		.value = "",
	},
	{
		.key = "dhcp.p2p.dns2",
		.value = "",
	},
	{
		.key = "dhcp.p2p.dns3",
		.value = "",
	},
	{
		.key = "dhcp.p2p.dns4",
		.value = "",
	},
	{
		.key = "dhcp.p2p.gateway",
		.value = "",
	},
	{
		.key = "dhcp.p2p.ipaddress",
		.value = "",
	},
	{
		.key = "dhcp.p2p.leasetime",
		.value = "",
	},
	{
		.key = "dhcp.p2p.mask",
		.value = "",
	},
	{
		.key = "dhcp.p2p.pid",
		.value = "",
	},
	{
		.key = "dhcp.p2p.reason",
		.value = "",
	},
	{
		.key = "dhcp.p2p.result",
		.value = "",
	},
	{
		.key = "dhcp.p2p.server",
		.value = "",
	},
	{
		.key = "dhcp.p2p.vendorInfo",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.dns1",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.dns2",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.dns3",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.dns4",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.gateway",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.ipaddress",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.leasetime",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.mask",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.pid",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.reason",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.result",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.server",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.vendorInfo",
		.value = "",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "M9615A-CEFWMAZM-3.0.113057",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "Qualcomm RIL 1.0",
	},
	{
		.key = "hw.cabl.level",
		.value = "Auto",
	},
	{
		.key = "hw.cabl.version",
		.value = "1.1.20130401",
	},
	{
		.key = "hw.cabl.yuv",
		.value = "0",
	},
	{
		.key = "ime_extend_row_keyboard",
		.value = "true",
	},
	{
		.key = "ime_keyboard_layout",
		.value = "ko=QWERTY",
	},
	{
		.key = "ime_onehand_keyboard",
		.value = "true",
	},
	{
		.key = "ime_onehand_keyboard_percent",
		.value = "82",
	},
	{
		.key = "ime_split_keyboard",
		.value = "true",
	},
	{
		.key = "ime_split_keyboard_width_dp",
		.value = "702",
	},
	{
		.key = "ime_theme",
		.value = "true",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.atd",
		.value = "running",
	},
	{
		.key = "init.svc.atfwd",
		.value = "running",
	},
	{
		.key = "init.svc.bnrd",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.cnd",
		.value = "running",
	},
	{
		.key = "init.svc.config_bluetooth",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.dhcpcd_p2p",
		.value = "",
	},
	{
		.key = "init.svc.dhcpcd_wlan0",
		.value = "",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.gsiff_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.immvibed",
		.value = "stopped",
	},
	{
		.key = "init.svc.imsdatadaemon",
		.value = "running",
	},
	{
		.key = "init.svc.imsqmidaemon",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.iprenew_wlan0",
		.value = "",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.kickstart",
		.value = "running",
	},
	{
		.key = "init.svc.lgdrm",
		.value = "running",
	},
	{
		.key = "init.svc.lge-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.lgsecclk",
		.value = "running",
	},
	{
		.key = "init.svc.log-kernel",
		.value = "stopped",
	},
	{
		.key = "init.svc.log-packet",
		.value = "stopped",
	},
	{
		.key = "init.svc.log-power",
		.value = "stopped",
	},
	{
		.key = "init.svc.logcat-events",
		.value = "stopped",
	},
	{
		.key = "init.svc.logcat-main",
		.value = "stopped",
	},
	{
		.key = "init.svc.logcat-radio",
		.value = "stopped",
	},
	{
		.key = "init.svc.logcat-system",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.modem-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.mpdecision",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.nfsserversetup",
		.value = "stopped",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "",
	},
	{
		.key = "init.svc.postinstaller",
		.value = "stopped",
	},
	{
		.key = "init.svc.ppd",
		.value = "running",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-wifi",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.rctd",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdcard",
		.value = "running",
	},
	{
		.key = "init.svc.secstarter",
		.value = "running",
	},
	{
		.key = "init.svc.sensors",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.sreadahead-check",
		.value = "stopped",
	},
	{
		.key = "init.svc.sreadahead",
		.value = "stopped",
	},
	{
		.key = "init.svc.ssbd",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.thermald",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.ufips",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.write_event_log",
		.value = "stopped",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "lge.hw.frontkeyled",
		.value = "true",
	},
	{
		.key = "lge.nfc.vendor",
		.value = "nxp",
	},
	{
		.key = "lge.normalizer.param",
		.value = "version2.0/true/6.0/true/7000/1.0/4000/0.33",
	},
	{
		.key = "lge.signed_image",
		.value = "true",
	},
	{
		.key = "lge.version.verified",
		.value = "NONE",
	},
	{
		.key = "lge.zdi.actionsend",
		.value = "false",
	},
	{
		.key = "lge.zdi.dragdropintent",
		.value = "false",
	},
	{
		.key = "lge.zdi.onactivityresult",
		.value = "true",
	},
	{
		.key = "lgemm.player.use_android_origin",
		.value = "false",
	},
	{
		.key = "lpa.decode",
		.value = "true",
	},
	{
		.key = "lpa.use-stagefright",
		.value = "true",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "33395",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "mmp.enable.mov",
		.value = "true",
	},
	{
		.key = "net.Is_phone_booted",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.dns1",
		.value = "",
	},
	{
		.key = "net.dns2",
		.value = "",
	},
	{
		.key = "net.dnschange",
		.value = "",
	},
	{
		.key = "net.hostname",
		.value = "android-b2785265a97f7eae",
	},
	{
		.key = "net.max_property",
		.value = "596",
	},
	{
		.key = "net.p2p-p2p0-0.dns1",
		.value = "",
	},
	{
		.key = "net.p2p-p2p0-0.dns2",
		.value = "",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "8096,2687380,3461120,4096,87380,3461120",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "8096,87380,3461120,4096,16384,3461120",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.evdo_b",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "8096,87380,3461120,4096,16384,3461120",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "8096,2687380,3461120,4096,87380,3461120",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "8096,2687380,3461120,4096,87380,3461120",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "8096,2687380,3461120,4096,87380,3461120",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "8096,2687380,3461120,4096,87380,3220608",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "8096,2687380,3461120,4096,87380,3461120",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "net.tethering.noprovisioning",
		.value = "true",
	},
	{
		.key = "net.wlan0.dns1",
		.value = "",
	},
	{
		.key = "net.wlan0.dns2",
		.value = "",
	},
	{
		.key = "nfc.fw_update",
		.value = "pass",
	},
	{
		.key = "persist.audio.btsco.wb",
		.value = "false",
	},
	{
		.key = "persist.audio.fluence.mode",
		.value = "endfire",
	},
	{
		.key = "persist.audio.handset.mic",
		.value = "digital",
	},
	{
		.key = "persist.audio.lowlatency.rec",
		.value = "false",
	},
	{
		.key = "persist.audio.nsenabled",
		.value = "ON",
	},
	{
		.key = "persist.audio.vr.enable",
		.value = "false",
	},
	{
		.key = "persist.boot.reset",
		.value = "pwr",
	},
	{
		.key = "persist.cne.feature",
		.value = "1",
	},
	{
		.key = "persist.data.netmgrd.qos.enable",
		.value = "false",
	},
	{
		.key = "persist.data.tethering_oc",
		.value = "1",
	},
	{
		.key = "persist.data_netmgrd_mtu",
		.value = "1410",
	},
	{
		.key = "persist.debug.wfd.enable",
		.value = "1",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "0",
	},
	{
		.key = "persist.gps.qmienabled",
		.value = "true",
	},
	{
		.key = "persist.gsm.mms.enabled",
		.value = "false",
	},
	{
		.key = "persist.gsm.mms.roaming.enabled",
		.value = "false",
	},
	{
		.key = "persist.gsm.sms.disablelog",
		.value = "64",
	},
	{
		.key = "persist.gsm.sms.forcegsm7",
		.value = "0",
	},
	{
		.key = "persist.hwc.mdpcomp.enable",
		.value = "true",
	},
	{
		.key = "persist.lg.data.block_ssdp",
		.value = "0",
	},
	{
		.key = "persist.lg.data.fd",
		.value = "-1",
	},
	{
		.key = "persist.power.useautobrightadj",
		.value = "true",
	},
	{
		.key = "persist.profiled.build.version",
		.value = "E98020i.1441288955",
	},
	{
		.key = "persist.radio.adb_log_on",
		.value = "0",
	},
	{
		.key = "persist.radio.add_power_save",
		.value = "1",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.data_no_toggle",
		.value = "1",
	},
	{
		.key = "persist.radio.eons.enabled",
		.value = "false",
	},
	{
		.key = "persist.rild.nitz_long_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_3",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_plmn",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_3",
		.value = "",
	},
	{
		.key = "persist.rmnet.mux",
		.value = "disabled",
	},
	{
		.key = "persist.security.sdmediacrypto",
		.value = "0",
	},
	{
		.key = "persist.service.bdroid.bdaddr",
		.value = "C4:43:8F:01:95:D4",
	},
	{
		.key = "persist.service.crash.enable",
		.value = "0",
	},
	{
		.key = "persist.service.ecc.hiddenmenu",
		.value = "",
	},
	{
		.key = "persist.service.events.enable",
		.value = "0",
	},
	{
		.key = "persist.service.kernel.enable",
		.value = "0",
	},
	{
		.key = "persist.service.main.enable",
		.value = "0",
	},
	{
		.key = "persist.service.packet.enable",
		.value = "0",
	},
	{
		.key = "persist.service.radio.enable",
		.value = "0",
	},
	{
		.key = "persist.service.system.enable",
		.value = "0",
	},
	{
		.key = "persist.sys.ats_start",
		.value = "false",
	},
	{
		.key = "persist.sys.cnd.iwlan",
		.value = "1",
	},
	{
		.key = "persist.sys.country",
		.value = "US",
	},
	{
		.key = "persist.sys.dalvik.vm.lib",
		.value = "libdvm.so",
	},
	{
		.key = "persist.sys.hotssid.ksc5601",
		.value = "",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.security",
		.value = "",
	},
	{
		.key = "persist.sys.silent",
		.value = "1",
	},
	{
		.key = "persist.sys.sound_enable",
		.value = "1",
	},
	{
		.key = "persist.sys.ssr.restart_level",
		.value = "3",
	},
	{
		.key = "persist.sys.strictmode.disable",
		.value = "true",
	},
	{
		.key = "persist.sys.strictmode.visual",
		.value = "false",
	},
	{
		.key = "persist.sys.theme0",
		.value = "com.lge.launcher2.theme.optimus",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp_only,adb",
	},
	{
		.key = "persist.sys.wfd.virtual",
		.value = "0",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "persist.web.set",
		.value = "1",
	},
	{
		.key = "qcom.audio.init",
		.value = "complete",
	},
	{
		.key = "qcom.hw.aac.encoder",
		.value = "true",
	},
	{
		.key = "ril.cdma.voiceinservice",
		.value = "false",
	},
	{
		.key = "ril.ecclist.autoprofile",
		.value = "",
	},
	{
		.key = "ril.ecclist",
		.value = "911,112,000,08,110,999,118,119",
	},
	{
		.key = "ril.subscription.types",
		.value = "NV,RUIM",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/smd0",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib/libril-qc-qmi-1.so",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.afwdata.LGfeatureset",
		.value = "ATTBASE",
	},
	{
		.key = "ro.airplane.phoneapp",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "mdm",
	},
	{
		.key = "ro.bluetooth.PANenable",
		.value = "1",
	},
	{
		.key = "ro.bluetooth.dun",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.6",
	},
	{
		.key = "ro.bluetooth.remote.autoconnect",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.request.master",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.sap",
		.value = "true",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8960",
	},
	{
		.key = "ro.boot.baseband",
		.value = "mdm",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.hardware",
		.value = "geefhd",
	},
	{
		.key = "ro.boot.serialno",
		.value = "LGE98052552c16",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1441289277",
	},
	{
		.key = "ro.build.date",
		.value = "Thu Sep  3 23:07:57 KST 2015",
	},
	{
		.key = "ro.build.description",
		.value = "geefhd_att_us-user 4.4.2 KOT49I.E98020i E98020i.1441288955 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "KOT49I.E98020i",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "lge/geefhd_att_us/geefhd:4.4.2/KOT49I.E98020i/E98020i.1441288955:user/release-keys",
	},
	{
		.key = "ro.build.host",
		.value = "betaserver-desktop",
	},
	{
		.key = "ro.build.id",
		.value = "KOT49I.E98020i",
	},
	{
		.key = "ro.build.product",
		.value = "geefhd",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.target_country",
		.value = "US",
	},
	{
		.key = "ro.build.target_operator",
		.value = "ATT",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "hyunjin0828.hwang",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "E98020i.1441288955",
	},
	{
		.key = "ro.build.version.release",
		.value = "4.4.2",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "19",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.apphider",
		.value = "off",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-om-lge",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-om-lge",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-om-lge",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "4.4.2_r1",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Lifes_Good_Alarm.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Optimus.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "ATT_Firefly.ogg",
	},
	{
		.key = "ro.config.vc_call_vol_default",
		.value = "3",
	},
	{
		.key = "ro.config.vc_call_vol_steps",
		.value = "6",
	},
	{
		.key = "ro.config.vibrate_type",
		.value = "1",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "geefhd",
	},
	{
		.key = "ro.hdmi.enable",
		.value = "true",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "6",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "1",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "48",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "32",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "8",
	},
	{
		.key = "ro.hwui.text_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "72",
	},
	{
		.key = "ro.lge.audio_scenario",
		.value = "SOUNDEXCEPTION",
	},
	{
		.key = "ro.lge.audio_soundexception",
		.value = "true",
	},
	{
		.key = "ro.lge.audio_soundprofile",
		.value = "true",
	},
	{
		.key = "ro.lge.basebandversion",
		.value = "APQ8064/MDM9x15M",
	},
	{
		.key = "ro.lge.capp_ZDi_O",
		.value = "true",
	},
	{
		.key = "ro.lge.capp_almond",
		.value = "true",
	},
	{
		.key = "ro.lge.capp_emotional_led",
		.value = "true",
	},
	{
		.key = "ro.lge.capp_lgevpn",
		.value = "true",
	},
	{
		.key = "ro.lge.capp_wfd",
		.value = "true",
	},
	{
		.key = "ro.lge.factoryversion",
		.value = "LGE980AT-00-V20i-ATT-US-SEP-03-2015+0",
	},
	{
		.key = "ro.lge.hiddenreset",
		.value = "0",
	},
	{
		.key = "ro.lge.lcd_auto_brightness_mode",
		.value = "false",
	},
	{
		.key = "ro.lge.lcd_default_brightness",
		.value = "152",
	},
	{
		.key = "ro.lge.overlay",
		.value = "true",
	},
	{
		.key = "ro.lge.ps.eco.pv",
		.value = "322",
	},
	{
		.key = "ro.lge.ps.freqlowlimit",
		.value = "1026000",
	},
	{
		.key = "ro.lge.qslide.max_window",
		.value = "2",
	},
	{
		.key = "ro.lge.swversion",
		.value = "E98020i",
	},
	{
		.key = "ro.lge.vib_magnitude_index",
		.value = "0,20,40,60,80,100,120,127",
	},
	{
		.key = "ro.livewallpaper.map",
		.value = "DISABLED",
	},
	{
		.key = "ro.minios.enable",
		.value = "0",
	},
	{
		.key = "ro.monkey",
		.value = "0",
	},
	{
		.key = "ro.nfc.port",
		.value = "I2C",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.product.board",
		.value = "GKATT",
	},
	{
		.key = "ro.product.brand",
		.value = "lge",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.device",
		.value = "geefhd",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "LGE",
	},
	{
		.key = "ro.product.model",
		.value = "LG-E980",
	},
	{
		.key = "ro.product.name",
		.value = "geefhd_att_us",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "fluence",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qc.sdk.camera.facialproc",
		.value = "true",
	},
	{
		.key = "ro.qc.sdk.gestures.camera",
		.value = "false",
	},
	{
		.key = "ro.qc.sdk.izat.premium_enabled",
		.value = "0",
	},
	{
		.key = "ro.qc.sdk.izat.service_mask",
		.value = "0x0",
	},
	{
		.key = "ro.qc.sdk.sensors.gestures",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.ftp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hfp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hsp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.map",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.nap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.opp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.pbap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "2",
	},
	{
		.key = "ro.radio.check_csp",
		.value = "enable",
	},
	{
		.key = "ro.radio.networkmode",
		.value = "disable",
	},
	{
		.key = "ro.radio.ratdisplay",
		.value = "true",
	},
	{
		.key = "ro.radio.topreviousmode",
		.value = "disable",
	},
	{
		.key = "ro.revision",
		.value = "10",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.ril.transmitpower",
		.value = "true",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "2454404108",
	},
	{
		.key = "ro.sdcrypto.syscall",
		.value = "378",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "LGE98052552c16",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "DISABLED",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "480",
	},
	{
		.key = "ro.sf.lcd_density_secondary",
		.value = "400",
	},
	{
		.key = "ro.ssbd.offset",
		.value = "0",
	},
	{
		.key = "ro.ssbd.session",
		.value = "/dev/block/platform/msm_sdcc.1/by-name/eksst",
	},
	{
		.key = "ro.streaming.video.drs",
		.value = "true",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "true",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "/system/lib/libqc-opt.so",
	},
	{
		.key = "ro.warmboot.capability",
		.value = "1",
	},
	{
		.key = "ro.wifi.channels",
		.value = "11 11",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "service.keyguard.status",
		.value = "1",
	},
	{
		.key = "service.plushome.currenthome",
		.value = "standard",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.factory.qem",
		.value = "0",
	},
	{
		.key = "sys.hdmi.block",
		.value = "unblock",
	},
	{
		.key = "sys.ims.DATA_DAEMON_STATUS",
		.value = "1",
	},
	{
		.key = "sys.ims.QMI_DAEMON_STATUS",
		.value = "1",
	},
	{
		.key = "sys.lge.dsdp.mode",
		.value = "stop",
	},
	{
		.key = "sys.lge.pif",
		.value = "0",
	},
	{
		.key = "sys.lge.touchcrack_mode",
		.value = "0",
	},
	{
		.key = "sys.settings_secure_version",
		.value = "1",
	},
	{
		.key = "sys.settings_system_version",
		.value = "25",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "24300",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp_only,adb",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp_only,adb",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "0",
	},
	{
		.key = "tunnel.audiovideo.decode",
		.value = "false",
	},
	{
		.key = "tunnel.decode",
		.value = "false",
	},
	{
		.key = "uicc.mobile_equipment.config",
		.value = "0",
	},
	{
		.key = "vold.decrypt",
		.value = "",
	},
	{
		.key = "vold.encrypt_progress",
		.value = "",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "vold.sdcard_fs_type",
		.value = "none",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wifi.lge.autochannel",
		.value = "",
	},
	{
		.key = "wifi.lge.hanglessid",
		.value = "false",
	},
	{
		.key = "wifi.lge.offdelay",
		.value = "false",
	},
	{
		.key = "wifi.lge.patch",
		.value = "true",
	},
	{
		.key = "wifi.lge.sleeppolicy",
		.value = "0",
	},
	{
		.key = "wifi.lge.supportp2p5g",
		.value = "gconly",
	},
	{
		.key = "wlan.chip.vendor",
		.value = "brcm",
	},
	{
		.key = "wlan.chip.version",
		.value = "bcm4334",
	},
	{
		.key = "wlan.driver.ath",
		.value = "0",
	},
	{
		.key = "wlan.driver.config",
		.value = "/data/misc/wifi/WCNSS_qcom_cfg.ini",
	},
	{
		.key = "wlan.driver.status",
		.value = "unloaded",
	},
	{
		.key = "wlan.lge.concurrency",
		.value = "MCC",
	},
	{
		.key = "wlan.lge.supportsimaka",
		.value = "yes",
	},
	{
		.key = "wlan.lge.wifidisplay",
		.value = "both",
	},
	{NULL},
};
#endif /* __ANDROID__ */
