/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.io.File;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.IndependentContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;

public class XPathEvaluator {
    private IndependentContext staticContext;
    private boolean stripSpace = false;

    public XPathEvaluator() {
        this(new Configuration());
    }

    public XPathEvaluator(Configuration configuration) {
        this.staticContext = new IndependentContext(configuration);
    }

    public Configuration getConfiguration() {
        return this.staticContext.getConfiguration();
    }

    public void setStripSpace(boolean bl) {
        this.stripSpace = bl;
    }

    public NodeInfo build(Source source) throws XPathException {
        NamePool namePool = source instanceof NodeInfo ? ((NodeInfo)source).getNamePool() : NamePool.getDefaultNamePool();
        AllElementStripper allElementStripper = null;
        if (this.stripSpace) {
            allElementStripper = AllElementStripper.getInstance();
        }
        Configuration configuration = new Configuration();
        configuration.setNamePool(namePool);
        return Builder.build(source, (Stripper)allElementStripper, configuration);
    }

    public void setStaticContext(IndependentContext independentContext) {
        this.staticContext = independentContext;
    }

    public IndependentContext getStaticContext() {
        return this.staticContext;
    }

    public XPathExpression createExpression(String string) throws XPathException {
        Expression expression = ExpressionTool.make(string, this.staticContext, 0, -1, 1);
        expression = expression.typeCheck(this.staticContext, Type.ITEM_TYPE);
        SlotManager slotManager = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expression, 0, slotManager);
        XPathExpression xPathExpression = new XPathExpression(this, expression);
        xPathExpression.setStackFrameMap(slotManager);
        return xPathExpression;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.staticContext.setNamespaceResolver(namespaceResolver);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.staticContext.getNamespaceResolver();
    }

    public void setDefaultElementNamespace(String string) {
        this.staticContext.setDefaultElementNamespace(string);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.println("format: java XPathEvaluator source.xml \"expression\"");
            return;
        }
        XPathEvaluator xPathEvaluator = new XPathEvaluator();
        XPathExpression xPathExpression = xPathEvaluator.createExpression(stringArray[1]);
        List list = xPathExpression.evaluate(new StreamSource(new File(stringArray[0])));
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            System.err.println(e);
        }
    }
}

