/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Xml;

namespace Cowbell.Base
{
	public class Preferences
	{
		/* public fields */
		public bool CacheCoverImage;
		public bool RenameFiles;
		public string RenameFilesPattern;
		public bool ExportPlaylist;
		public string PlaylistType;
		public string LastPath;
		
		/* public methods */
		public Preferences ()
		{
			CacheCoverImage = false;
			RenameFiles = false;
			RenameFilesPattern = Catalog.GetString ("Track - Title");
			ExportPlaylist = false;
			PlaylistType = "m3u";
			LastPath = Environment.GetEnvironmentVariable ("HOME");

			try {
				Runtime.Debug ("Loading preferences file from {0}", config_path);
				Load ();
			} catch (Exception e) {
				Runtime.Debug ("Loading preferences failed");
				Runtime.Debug (e.Message);
			}
		}
		
		public void Save ()
		{
			string conf;
			conf = config_path.Replace ("~", Environment.GetEnvironmentVariable ("HOME"));

			Runtime.Debug ("Saving preferences to {0}", conf);
			XmlTextWriter writer = new XmlTextWriter (conf, System.Text.Encoding.UTF8);
			writer.Formatting = Formatting.Indented;

			writer.WriteStartElement ("Preferences");

			writer.WriteStartElement ("CacheCoverImage");
			writer.WriteAttributeString ("enabled", CacheCoverImage.ToString ());
			writer.WriteEndElement ();
			
			writer.WriteStartElement ("RenameFiles");
			writer.WriteAttributeString ("enabled", RenameFiles.ToString ());
			writer.WriteStartElement ("Pattern");
			writer.WriteString (RenameFilesPattern);
			writer.WriteEndElement ();
			writer.WriteEndElement ();

			writer.WriteStartElement ("ExportPlaylist");
			writer.WriteAttributeString ("enabled", ExportPlaylist.ToString ());
			writer.WriteStartElement ("Type");
			writer.WriteString (PlaylistType);
			writer.WriteEndElement ();
			writer.WriteEndElement ();

			writer.WriteStartElement ("Metadata");
			writer.WriteStartElement ("LastPath");
			writer.WriteString (LastPath);
			writer.WriteEndElement ();
			writer.WriteEndElement ();

			writer.WriteEndElement ();

			writer.Flush ();
			writer.Close ();
		}

		public void Load ()
		{
			string conf;
			conf = config_path.Replace ("~", Environment.GetEnvironmentVariable ("HOME"));

			XmlTextReader reader = new XmlTextReader (conf);
			XmlDocument doc = new XmlDocument ();
			XmlNode node;
			
			doc.Load (reader);

			node = doc.SelectSingleNode ("/Preferences/CacheCoverImage");
			if (node != null) {
				CacheCoverImage = Convert.ToBoolean (node.Attributes["enabled"].InnerXml);
			}

			node = doc.SelectSingleNode ("/Preferences/RenameFiles");
			if (node != null) {
				RenameFiles = Convert.ToBoolean (node.Attributes["enabled"].InnerXml);
				
				node = doc.SelectSingleNode ("/Preferences/RenameFiles/Pattern");
				if (node != null) {
					RenameFilesPattern = node.InnerText;
				}
			}
	
			node = doc.SelectSingleNode ("/Preferences/ExportPlaylist");
			if (node != null) {
				ExportPlaylist = Convert.ToBoolean (node.Attributes["enabled"].InnerXml);

				node = doc.SelectSingleNode ("/Preferences/ExportPlaylist/Type");
				if (node != null) {
					if (node.InnerText == "m3u") {
						PlaylistType = "m3u";
					} else if (node.InnerText == "pls") {
						PlaylistType = "pls";
					}
				}
			}
	
			node = doc.SelectSingleNode ("/Preferences/Metadata/LastPath");
			if (node != null) {
				LastPath = node.InnerText;
			}
		}

		/* private fields */
		private static string config_path = "~/.cowbell";
	}
}
