// Source file for aminoacid atom type data



// Include files

#include "PDB.h"



// Amino acid atom info 
// Group data from Engh & Huber, 1991
// Charge data from Delphi, generated from CHARMM -- (c) 1995 Andreas Windemuth

const PDBAminoAcidAtomData PDBaminoacid_atoms[PDB_NUM_ATOMS] =
{ 
  PDBAminoAcidAtomData(                 0, PDB_NULL_ATOM,     PDB_NULL_ATOM_GROUP,  "    ",  " ",   0.000 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_CB_ATOM,   PDB_CH3E_ATOM_GROUP,  " CB ",  "C",  -0.270 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_HB3_ATOM,  PDB_NULL_ATOM_GROUP,  " HB3",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ALA_AMINOACID, PDB_ALA_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),  
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.110 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_SG_ATOM,   PDB_SH1E_ATOM_GROUP,  " SG ",  "S",  -0.230 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_HG1_ATOM,  PDB_NULL_ATOM_GROUP,  " HG1",  "H",   0.160 ),
  PDBAminoAcidAtomData( PDB_CYS_AMINOACID, PDB_CYS_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_CD_ATOM,   PDB_CH0_ATOM_GROUP,   " CD ",  "C",   0.620 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_CG_ATOM,   PDB_CH2E_ATOM_GROUP,  " CG ",  "C",  -0.280 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_OE1_ATOM,  PDB_OC_ATOM_GROUP,    " OE1",  "O",  -0.760 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_OE2_ATOM,  PDB_OC_ATOM_GROUP,    " OE2",  "O",  -0.760 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_HG1_ATOM,  PDB_NULL_ATOM_GROUP,  " HG1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_HG2_ATOM,  PDB_NULL_ATOM_GROUP,  " HG2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLU_AMINOACID, PDB_GLU_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.280 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_CG_ATOM,   PDB_CH0_ATOM_GROUP,   " CG ",  "C",   0.620 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_OD1_ATOM,  PDB_OC_ATOM_GROUP,    " OD1",  "O",  -0.760 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_OD2_ATOM,  PDB_OC_ATOM_GROUP,    " OD2",  "O",  -0.760 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ASP_AMINOACID, PDB_ASP_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_CD1_ATOM,  PDB_CR1E_ATOM_GROUP,  " CD1",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_CD2_ATOM,  PDB_CR1E_ATOM_GROUP,  " CD2",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_CE1_ATOM,  PDB_CR1E_ATOM_GROUP,  " CE1",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_CE2_ATOM,  PDB_CR1E_ATOM_GROUP,  " CE2",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_CG_ATOM,   PDB_CF_ATOM_GROUP,    " CG ",  "C",   0.000 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_CZ_ATOM,   PDB_CR1E_ATOM_GROUP,  " CZ ",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_HD1_ATOM,  PDB_NULL_ATOM_GROUP,  " HD1",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_HD2_ATOM,  PDB_NULL_ATOM_GROUP,  " HD2",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_HE1_ATOM,  PDB_NULL_ATOM_GROUP,  " HE1",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_HE2_ATOM,  PDB_NULL_ATOM_GROUP,  " HE2",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_HZ_ATOM,   PDB_NULL_ATOM_GROUP,  " HZ ",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_PHE_AMINOACID, PDB_PHE_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_GLY_AMINOACID, PDB_GLY_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_GLY_AMINOACID, PDB_GLY_CA_ATOM,   PDB_CH2G_ATOM_GROUP,  " CA ",  "C",  -0.020 ),
  PDBAminoAcidAtomData( PDB_GLY_AMINOACID, PDB_GLY_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_GLY_AMINOACID, PDB_GLY_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_GLY_AMINOACID, PDB_GLY_HA1_ATOM,  PDB_NULL_ATOM_GROUP,  " HA1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLY_AMINOACID, PDB_GLY_HA2_ATOM,  PDB_NULL_ATOM_GROUP,  " HA2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLY_AMINOACID, PDB_GLY_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.090 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_CD2_ATOM,  PDB_CR1H_ATOM_GROUP,  " CD2",  "C",   0.220 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_CE1_ATOM,  PDB_CRHH_ATOM_GROUP,  " CE1",  "C",   0.250 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_CG_ATOM,   PDB_C5_ATOM_GROUP,    " CG ",  "C",  -0.050 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_ND1_ATOM,  PDB_NH1S_ATOM_GROUP,  " ND1",  "N",  -0.360 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_NE2_ATOM,  PDB_NH1S_ATOM_GROUP,  " NE2",  "N",  -0.700 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_HD1_ATOM,  PDB_NULL_ATOM_GROUP,  " HD1",  "H",   0.320 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_HD2_ATOM,  PDB_NULL_ATOM_GROUP,  " HD2",  "H",   0.100 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_HE1_ATOM,  PDB_NULL_ATOM_GROUP,  " HE1",  "H",   0.130 ), 
  PDBAminoAcidAtomData( PDB_HIS_AMINOACID, PDB_HIS_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_CB_ATOM,   PDB_CH1S_ATOM_GROUP,  " CB ",  "C",  -0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_CD_ATOM,   PDB_CH3E_ATOM_GROUP,  " CD ",  "C",  -0.270 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_CG1_ATOM,  PDB_CH2E_ATOM_GROUP,  " CG1",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_CG2_ATOM,  PDB_CH3E_ATOM_GROUP,  " CG2",  "C",  -0.270 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HB_ATOM,   PDB_NULL_ATOM_GROUP,  " HB ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HD1_ATOM,  PDB_NULL_ATOM_GROUP,  " HD1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HD2_ATOM,  PDB_NULL_ATOM_GROUP,  " HD2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HD3_ATOM,  PDB_NULL_ATOM_GROUP,  " HD3",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HG11_ATOM, PDB_NULL_ATOM_GROUP,  " HG11", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HG12_ATOM, PDB_NULL_ATOM_GROUP,  " HG12", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HG21_ATOM, PDB_NULL_ATOM_GROUP,  " HG21", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HG22_ATOM, PDB_NULL_ATOM_GROUP,  " HG22", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HG23_ATOM, PDB_NULL_ATOM_GROUP,  " HG23", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ILE_AMINOACID, PDB_ILE_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_CD_ATOM,   PDB_CH2E_ATOM_GROUP,  " CD ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_CE_ATOM,   PDB_CH2E_ATOM_GROUP,  " CE ",  "C",   0.210 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_CG_ATOM,   PDB_CH2E_ATOM_GROUP,  " CG ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_NZ_ATOM,   PDB_NH3_ATOM_GROUP,   " NZ ",  "N",  -0.300 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HD1_ATOM,  PDB_NULL_ATOM_GROUP,  " HD1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HD2_ATOM,  PDB_NULL_ATOM_GROUP,  " HD2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HE1_ATOM,  PDB_NULL_ATOM_GROUP,  " HE1",  "H",   0.050 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HE2_ATOM,  PDB_NULL_ATOM_GROUP,  " HE2",  "H",   0.050 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HG1_ATOM,  PDB_NULL_ATOM_GROUP,  " HG1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HG2_ATOM,  PDB_NULL_ATOM_GROUP,  " HG2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HZ1_ATOM,  PDB_NULL_ATOM_GROUP,  " HZ1",  "H",   0.330 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HZ2_ATOM,  PDB_NULL_ATOM_GROUP,  " HZ2",  "H",   0.330 ),
  PDBAminoAcidAtomData( PDB_LYS_AMINOACID, PDB_LYS_HZ3_ATOM,  PDB_NULL_ATOM_GROUP,  " HZ3",  "H",   0.330 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_CD1_ATOM,  PDB_CH3E_ATOM_GROUP,  " CD1",  "C",  -0.270 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_CD2_ATOM,  PDB_CH3E_ATOM_GROUP,  " CD2",  "C",  -0.270 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_CG_ATOM,   PDB_CH1S_ATOM_GROUP,  " CG ",  "C",  -0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HD11_ATOM, PDB_NULL_ATOM_GROUP,  " HD11", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HD12_ATOM, PDB_NULL_ATOM_GROUP,  " HD12", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HD13_ATOM, PDB_NULL_ATOM_GROUP,  " HD13", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HD21_ATOM, PDB_NULL_ATOM_GROUP,  " HD21", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HD22_ATOM, PDB_NULL_ATOM_GROUP,  " HD22", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HD23_ATOM, PDB_NULL_ATOM_GROUP,  " HD23", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HG_ATOM,   PDB_NULL_ATOM_GROUP,  " HG ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_LEU_AMINOACID, PDB_LEU_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_CE_ATOM,   PDB_CH3E_ATOM_GROUP,  " CE ",  "C",  -0.220 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_CG_ATOM,   PDB_CH2E_ATOM_GROUP,  " CG ",  "C",  -0.140 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_SD_ATOM,   PDB_SM_ATOM_GROUP,    " SD ",  "S",  -0.090 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_HE1_ATOM,  PDB_NULL_ATOM_GROUP,  " HE1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_HE2_ATOM,  PDB_NULL_ATOM_GROUP,  " HE2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_HE3_ATOM,  PDB_NULL_ATOM_GROUP,  " HE3",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_HG1_ATOM,  PDB_NULL_ATOM_GROUP,  " HG1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_HG2_ATOM,  PDB_NULL_ATOM_GROUP,  " HG2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_MET_AMINOACID, PDB_MET_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_CG_ATOM,   PDB_CH0_ATOM_GROUP,   " CG ",  "C",   0.550 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_ND2_ATOM,  PDB_NH2_ATOM_GROUP,   " ND2",  "N",  -0.620 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_OD1_ATOM,  PDB_OS_ATOM_GROUP,    " OD1",  "O",  -0.550 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_HD21_ATOM, PDB_NULL_ATOM_GROUP,  " HD21", "H",   0.320 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_HD22_ATOM, PDB_NULL_ATOM_GROUP,  " HD22", "H",   0.300 ),
  PDBAminoAcidAtomData( PDB_ASN_AMINOACID, PDB_ASN_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.020 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_CD_ATOM,   PDB_CH2P_ATOM_GROUP,  " CD ",  "C",   0.000 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_CG_ATOM,   PDB_CH2P_ATOM_GROUP,  " CG ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_N_ATOM,    PDB_N_ATOM_GROUP,     " N  ",  "N",  -0.290 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_HD1_ATOM,  PDB_NULL_ATOM_GROUP,  " HD1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_HD2_ATOM,  PDB_NULL_ATOM_GROUP,  " HD2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_HG1_ATOM,  PDB_NULL_ATOM_GROUP,  " HG1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_PRO_AMINOACID, PDB_PRO_HG2_ATOM,  PDB_NULL_ATOM_GROUP,  " HG2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_CD_ATOM,   PDB_CH0_ATOM_GROUP,   " CD ",  "C",   0.550 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_CG_ATOM,   PDB_CH2E_ATOM_GROUP,  " CG ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_NE2_ATOM,  PDB_NH2_ATOM_GROUP,   " NE2",  "N",  -0.620 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_OE1_ATOM,  PDB_OS_ATOM_GROUP,    " OE1",  "O",  -0.550 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_HE21_ATOM, PDB_NULL_ATOM_GROUP,  " HE21", "H",   0.320 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_HE22_ATOM, PDB_NULL_ATOM_GROUP,  " HE22", "H",   0.300 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_HG1_ATOM,  PDB_NULL_ATOM_GROUP,  " HG1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_HG2_ATOM,  PDB_NULL_ATOM_GROUP,  " HG2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_GLN_AMINOACID, PDB_GLN_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_CD_ATOM,   PDB_CH2E_ATOM_GROUP,  " CD ",  "C",   0.200 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_CG_ATOM,   PDB_CH2E_ATOM_GROUP,  " CG ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_CZ_ATOM,   PDB_CH0_ATOM_GROUP,   " CZ ",  "C",   0.640 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_NE_ATOM,   PDB_NH1S_ATOM_GROUP,  " NE ",  "N",  -0.700 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_NH1_ATOM,  PDB_NC2_ATOM_GROUP,   " NH1",  "N",  -0.800 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_NH2_ATOM,  PDB_NC2_ATOM_GROUP,   " NH2",  "N",  -0.800 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HD1_ATOM,  PDB_NULL_ATOM_GROUP,  " HD1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HD2_ATOM,  PDB_NULL_ATOM_GROUP,  " HD2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HE_ATOM,   PDB_NULL_ATOM_GROUP,  " HE ",  "H",   0.440 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HG1_ATOM,  PDB_NULL_ATOM_GROUP,  " HG1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HG2_ATOM,  PDB_NULL_ATOM_GROUP,  " HG2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HH11_ATOM, PDB_NULL_ATOM_GROUP,  " HH11", "H",   0.460 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HH12_ATOM, PDB_NULL_ATOM_GROUP,  " HH12", "H",   0.460 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HH21_ATOM, PDB_NULL_ATOM_GROUP,  " HH21", "H",   0.460 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HH22_ATOM, PDB_NULL_ATOM_GROUP,  " HH22", "H",   0.460 ),
  PDBAminoAcidAtomData( PDB_ARG_AMINOACID, PDB_ARG_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",   0.050 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_OG_ATOM,   PDB_OH1_ATOM_GROUP,   " OG ",  "O",  -0.660 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_HG1_ATOM,  PDB_NULL_ATOM_GROUP,  " HG1",  "H",   0.430 ),
  PDBAminoAcidAtomData( PDB_SER_AMINOACID, PDB_SER_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_CB_ATOM,   PDB_CH1S_ATOM_GROUP,  " CB ",  "C",   0.140 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_CG2_ATOM,  PDB_CH3E_ATOM_GROUP,  " CG2",  "C",  -0.270 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_OG1_ATOM,  PDB_OH1_ATOM_GROUP,   " OG1",  "O",  -0.660 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_HB_ATOM,   PDB_NULL_ATOM_GROUP,  " HB ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_HG1_ATOM,  PDB_NULL_ATOM_GROUP,  " HG1",  "H",   0.430 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_HG21_ATOM, PDB_NULL_ATOM_GROUP,  " HG21", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_HG22_ATOM, PDB_NULL_ATOM_GROUP,  " HG22", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_HG23_ATOM, PDB_NULL_ATOM_GROUP,  " HG23", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_THR_AMINOACID, PDB_THR_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_CB_ATOM,   PDB_CH1S_ATOM_GROUP,  " CB ",  "C",  -0.090 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_CG1_ATOM,  PDB_CH3E_ATOM_GROUP,  " CG1",  "C",  -0.270 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_CG2_ATOM,  PDB_CH3E_ATOM_GROUP,  " CG2",  "C",  -0.270 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_HB_ATOM,   PDB_NULL_ATOM_GROUP,  " HB ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_HG11_ATOM, PDB_NULL_ATOM_GROUP,  " HG11", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_HG12_ATOM, PDB_NULL_ATOM_GROUP,  " HG12", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_HG13_ATOM, PDB_NULL_ATOM_GROUP,  " HG13", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_HG21_ATOM, PDB_NULL_ATOM_GROUP,  " HG21", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_HG22_ATOM, PDB_NULL_ATOM_GROUP,  " HG22", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_HG23_ATOM, PDB_NULL_ATOM_GROUP,  " HG23", "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_VAL_AMINOACID, PDB_VAL_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CD1_ATOM,  PDB_CR1E_ATOM_GROUP,  " CD1",  "C",   0.035 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CD2_ATOM,  PDB_CW_ATOM_GROUP,    " CD2",  "C",  -0.020 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CE2_ATOM,  PDB_CW_ATOM_GROUP,    " CE2",  "C",   0.130 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CE3_ATOM,  PDB_CR1E_ATOM_GROUP,  " CE3",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CG_ATOM,   PDB_C5W_ATOM_GROUP,   " CG ",  "C",  -0.030 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CH2_ATOM,  PDB_CR1W_ATOM_GROUP,  " CH2",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CZ2_ATOM,  PDB_CR1W_ATOM_GROUP,  " CZ2",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_CZ3_ATOM,  PDB_CR1E_ATOM_GROUP,  " CZ3",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_NE1_ATOM,  PDB_NH1S_ATOM_GROUP,  " NE1",  "N",  -0.610 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HD1_ATOM,  PDB_NULL_ATOM_GROUP,  " HD1",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HE1_ATOM,  PDB_NULL_ATOM_GROUP,  " HE1",  "H",   0.380 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HE3_ATOM,  PDB_NULL_ATOM_GROUP,  " HE3",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HH2_ATOM,  PDB_NULL_ATOM_GROUP,  " HH2",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HZ2_ATOM,  PDB_NULL_ATOM_GROUP,  " HZ2",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_TRP_AMINOACID, PDB_TRP_HZ3_ATOM,  PDB_NULL_ATOM_GROUP,  " HZ3",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_C_ATOM,    PDB_C_ATOM_GROUP,     " C  ",  "C",   0.510 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_CA_ATOM,   PDB_CH1E_ATOM_GROUP,  " CA ",  "C",   0.070 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_CB_ATOM,   PDB_CH2E_ATOM_GROUP,  " CB ",  "C",  -0.180 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_CD1_ATOM,  PDB_CR1E_ATOM_GROUP,  " CD1",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_CD2_ATOM,  PDB_CR1E_ATOM_GROUP,  " CD2",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_CE1_ATOM,  PDB_CR1E_ATOM_GROUP,  " CE1",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_CE2_ATOM,  PDB_CR1E_ATOM_GROUP,   " CE2",  "C",  -0.115 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_CG_ATOM,   PDB_CY_ATOM_GROUP,    " CG ",  "C",   0.000 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_CZ_ATOM,   PDB_CY2_ATOM_GROUP,   " CZ ",  "C",   0.110 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_N_ATOM,    PDB_NH1_ATOM_GROUP,   " N  ",  "N",  -0.470 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_O_ATOM,    PDB_O_ATOM_GROUP,     " O  ",  "O",  -0.510 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_OH_ATOM,   PDB_OH1_ATOM_GROUP,   " OH ",  "O",  -0.540 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_HA_ATOM,   PDB_NULL_ATOM_GROUP,  " HA ",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_HB1_ATOM,  PDB_NULL_ATOM_GROUP,  " HB1",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_HB2_ATOM,  PDB_NULL_ATOM_GROUP,  " HB2",  "H",   0.090 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_HD1_ATOM,  PDB_NULL_ATOM_GROUP,  " HD1",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_HD2_ATOM,  PDB_NULL_ATOM_GROUP,  " HD2",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_HE1_ATOM,  PDB_NULL_ATOM_GROUP,  " HE1",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_HE2_ATOM,  PDB_NULL_ATOM_GROUP,  " HE2",  "H",   0.115 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_HH_ATOM,   PDB_NULL_ATOM_GROUP,  " HH ",  "H",   0.430 ),
  PDBAminoAcidAtomData( PDB_TYR_AMINOACID, PDB_TYR_HN_ATOM,   PDB_NULL_ATOM_GROUP,  " HN ",  "H",   0.310 )
};



int PDBaminoacid_atom_offsets[PDB_NUM_AMINOACIDS] =
{ 
  PDB_ALA_C_ATOM,
  PDB_CYS_C_ATOM,
  PDB_ASP_C_ATOM,
  PDB_GLU_C_ATOM,
  PDB_PHE_C_ATOM,
  PDB_GLY_C_ATOM,
  PDB_HIS_C_ATOM,
  PDB_ILE_C_ATOM,
  PDB_LYS_C_ATOM,
  PDB_LEU_C_ATOM,
  PDB_MET_C_ATOM,
  PDB_ASN_C_ATOM,
  PDB_PRO_C_ATOM,
  PDB_GLN_C_ATOM,
  PDB_ARG_C_ATOM,
  PDB_SER_C_ATOM,
  PDB_THR_C_ATOM,
  PDB_VAL_C_ATOM,
  PDB_TRP_C_ATOM,
  PDB_TYR_C_ATOM
};




PDBAminoAcidAtomData::
PDBAminoAcidAtomData(int aminoacid_id, int atom_id, int group, const char *atom_name, const char *element_name, RNScalar charge)
  : aminoacid_id(aminoacid_id),
    atom_id(atom_id),
    group(group),
    atom_name(atom_name),
    element(PDBFindElement(element_name)),
    charge(charge)
{
  // Check element
  // assert(element);
}



int 
FindAminoAcidAtomType(PDBAtom *atom)
{
  // Check if a hetatm
  if (atom->IsHetAtom()) return PDB_NULL_ATOM;

  // Get residue
  PDBResidue *residue = atom->Residue();
  if (!residue) return PDB_NULL_ATOM;

  // Get amino acid
  PDBAminoAcid *aminoacid = residue->AminoAcid();
  if (!aminoacid) return PDB_NULL_ATOM;

  // Search for atom type
  for (int i = 0; i < aminoacid->NAtoms(); i++) {
    int type = PDBaminoacid_atom_offsets[aminoacid->ID()] + i;
    const PDBAminoAcidAtomData *data = &PDBaminoacid_atoms[type];
    assert(data->aminoacid_id == aminoacid->ID());
    if (!strcmp(atom->Name(), data->atom_name)) return type;
  }

  // Type not found
  return PDB_NULL_ATOM;
}
