#ifndef H_CDW_OFS
#define H_CDW_OFS

#include <stdbool.h>

#include <cdio/cdio.h>
#include <cdio/cd_types.h>
#include <cdio/iso9660.h>

#include "main.h"

#define CDW_OFS_VOLUME_ID_LEN_MAX ISO_MAX_VOLUME_ID




typedef struct {
	/* generic data */
	int fd;             /* file descriptor */
	cdio_fs_t type;     /* optical file system type; module will set it using value of third argument to cdw_ofs_get() */
	char *type_label;   /* label of optical file system type, needs to be set by caller after creating ofs */
	long int n_sectors; /* this should be set by code that uses cdw_ofs module, not by module itself */

	int cdw_tool;       /* tool used to create given file system (this information may not be possible to retrieve) */


	/* ISO9660-specific */
	char *preparer_id;
	char *app_id;
	char *publisher_id;
	char *volume_id;
	char *volumeset_id;

	int joliet_ucs_level;

	iso9660_t *cdio_iso;
} cdw_ofs_t;


/* basic functions */
cdw_ofs_t *cdw_ofs_new(void);
cdw_rv_t   cdw_ofs_get(cdw_ofs_t *ofs, const char *fullpath, cdio_fs_t type);
cdw_ofs_t *cdw_ofs_copy(cdw_ofs_t *ofs);
void       cdw_ofs_delete(cdw_ofs_t **ofs);

/* utility functions */
const char *cdw_ofs_long_label(cdio_fs_t fs);
const char *cdw_ofs_short_label(cdio_fs_t fs);
bool        cdw_ofs_is_iso(cdio_fs_t fs);

/* debug functions */
void cdw_ofs_print_debug(cdw_ofs_t *ofs);

#endif /* H_CDW_OFS */
