/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

//
// $Id: PackArrayArray.H,v 1.1 2000/07/13 18:21:06 sstanley Exp $
//
#ifndef _PackArrayArray__
#define _PackArrayArray_

//
// Includes required for the interface definition
//
#include "Array.H"
#include "REAL.H"


// ================================================================
// ===== Routine:  PackArrayArray(int outerDim, int innerDim, 
//                                Array< Array<Real> > data)
// ================================================================
//
// This routine pack an Array<Array<Real>> into an Array<Real> so it
// can be passed into Fortran.  The ordering of the pack is such that the 
// inner index in the Array<Array<>> is the first index in fortran
// (the slowest varying).
//
Array<Real>  PackArrayArray(int outerDim, 
                            int innerDim, 
                            Array< Array<Real> > data);


// ================================================================
// ===== Routine:  UnPackArrayArray(int outerDim, int innerDim, 
//                                  Array<Real> data)
// ================================================================
//
// This routine unpacks an Array<Real> into an Array<Array<Real>> so it
// can be passed into Fortran.  The ordering of the pack is such that the 
// inner index in the Array<Array<>> is the first index in fortran
// (the slowest varying).  This is the unpack to go with the pack above.
//
Array< Array<Real> >  UnPackArrayArray(int outerDim, 
                                       int innerDim, 
                                       Array<Real> data);
#endif

