/*
 * Copyright 2008 Udai Gupta, Ralf Joachim
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.castor.cpa.query.object.condition;

import org.castor.cpa.query.Condition;
import org.castor.cpa.query.Expression;

/**
 * Abstract base class that represents simple condition.
 * 
 * @author <a href="mailto:mailtoud AT gmail DOT com">Udai Gupta</a>
 * @author <a href="mailto:ralf DOT joachim AT syscon DOT eu">Ralf Joachim</a>
 * @version $Revision: 7121 $ $Date: 2006-04-25 16:09:10 -0600 (Tue, 25 Apr 2006) $
 * @since 1.3
 */
public abstract class SimpleCondition extends AbstractCondition {
    //--------------------------------------------------------------------------
 
    /** Invert test result? */
    private boolean _not;

    /** Expression to test for the simple condition. */
    private Expression _expression;

    //--------------------------------------------------------------------------
 
    /**
     * {@inheritDoc}
     */
    public final Condition not() {
        _not = !_not;
        return this;
    }

    //--------------------------------------------------------------------------

    /**
     * Does test result get inverted?
     * 
     * @return <code>true</code> if test result gets inverted, <code>false</code> otherwise.
     */
    public final boolean isNot() {
        return _not;
    }

    /**
     * Set if test result has to be inverted.
     * 
     * @param not <code>true</code> if test result gets inverted, <code>false</code> otherwise.
     */
    public final void setNot(final boolean not) {
        _not = not;
    }
    
    /**
     * Get expression to test.
     * 
     * @return Expression to test.
     */
    public final Expression getExpression() {
        return _expression;
    }

    /**
     * Set expression to test.
     * 
     * @param expression Expression to test.
     */
    public final void setExpression(final Expression expression) {
        _expression = expression;
    }

    //--------------------------------------------------------------------------
}
