/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

//-- CamiTK
#include "VtkMeshComponentProperties.h"
using namespace camitk;

// -- vtk
#include <vtkMatrix4x4.h>
#include <vtkActor.h>
#include <vtkProperty.h>

//-- Qt
#include <QMap>


//--------------------   constructor   ----------------------------------------
VtkMeshComponentProperties::VtkMeshComponentProperties( VtkMeshComponent * comp ) : QObject( NULL ) {
    myComponent = comp;

    /*
    // Create and initialize intrinsic parameters : Focal and principal point.
    specularColorTable.insert("R", 1.0);
    specularColorTable.insert("G", 1.0);
    specularColorTable.insert("B", 1.0);

    this->setAmbient( 1.0 );
    this->setDiffuse( 1.0 );
    this->setSpecular( 0.0 );
    this->setSpecularPower( 1.0 );
    this->setOpacity( 1.0 );
    */
}


//--------------------   getAmbient   --------------------
double VtkMeshComponentProperties::getAmbient() const {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        return myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->GetAmbient();
    else
        return 1.0;
}

//--------------------   getDiffuse   --------------------
double VtkMeshComponentProperties::getDiffuse() const {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        return myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->GetDiffuse();
    else
        return 1.0;
}

//--------------------   getSpecular   --------------------
double VtkMeshComponentProperties::getSpecular() const {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        return myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->GetSpecular();
    else
        return 0.0;
}

//--------------------   getSpecularPower   --------------------
double VtkMeshComponentProperties::getSpecularPower() const {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        return myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->GetSpecularPower();
    else
        return 1.0;
}

//--------------------   getOpacity   --------------------
double VtkMeshComponentProperties::getOpacity() const {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        return myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->GetOpacity();
    else
        return 1.0;
}

//--------------------  getSpecularColor    --------------------
QColor VtkMeshComponentProperties::getSpecularColor() const {
    double r=1.0,g=1.0,b=1.0;

    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->GetSpecularColor(r,g,b);

    return QColor(r,g,b);
}


//--------------------   setAmbient   --------------------
void VtkMeshComponentProperties::setAmbient( const double input ) {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->SetAmbient( input );
}

//--------------------   setDiffuse   --------------------
void VtkMeshComponentProperties::setDiffuse( const double input ) {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->SetDiffuse( input );
}

//--------------------   setSpecular   --------------------
void VtkMeshComponentProperties::setSpecular( const double input ) {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->SetSpecular( input );
}

//--------------------  setSpecularPower    --------------------
void VtkMeshComponentProperties::setSpecularPower( const double input ) {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->SetSpecularPower( input );
}

//--------------------  setOpacity    --------------------
void VtkMeshComponentProperties::setOpacity( const double input ) {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->SetOpacity( input );
}

//--------------------   setSpecularColor   --------------------
void VtkMeshComponentProperties::setSpecularColor( const QColor input ) {
    if( myComponent->getActor( InterfaceGeometry::Surface ) )
        myComponent->getActor( InterfaceGeometry::Surface )->GetProperty()->SetSpecularColor( input.redF(), input.greenF(), input.blueF() );
}
