/*
*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*
*/

package org.apache.bookkeeper.client;

import java.util.concurrent.CountDownLatch;

import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.client.BookKeeper.DigestType;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.test.BaseTestCase;
import org.junit.Test;

/**
 * Tests of the main BookKeeper client using networkless comunication
 */
public class LocalBookKeeperTest extends BaseTestCase {
    
    protected ServerConfiguration newServerConfiguration() throws Exception {       
        return super
                .newServerConfiguration()
                .setEnableLocalTransport(true);
    }
        
    DigestType digestType;
    
    public LocalBookKeeperTest(DigestType digestType) {
        super(4);            
        this.digestType=digestType;
    }

    @Test
    public void testUseLocalBookie() throws Exception {
        ClientConfiguration conf = new ClientConfiguration()
                .setZkServers(zkUtil.getZooKeeperConnectString())
                .setZkTimeout(20000);

        CountDownLatch l = new CountDownLatch(1);
        zkUtil.sleepServer(5, l);
        l.await();
                
        BookKeeper bkc = new BookKeeper(conf);
        LedgerHandle h = bkc.createLedger(1,1,digestType, "testPasswd".getBytes());
        h.addEntry("test".getBytes());
        h.close();
        bkc.close();
    }

}
