/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import yuku.alkitab.model.FootnoteEntry;
import yuku.bintex.BintexWriter;

public class FootnoteDb {
    final Map<Integer, List<FootnoteEntry>> map = new TreeMap<Integer, List<FootnoteEntry>>();

    public FootnoteDb() {
    }

    public FootnoteDb(LinkedHashMap<Integer, FootnoteEntry> footnoteEntries) {
        for (Map.Entry<Integer, FootnoteEntry> entry : new TreeMap<Integer, FootnoteEntry>(footnoteEntries).entrySet()) {
            int arif = entry.getKey();
            int ari = arif >> 8;
            List<FootnoteEntry> fes = this.map.get(ari);
            if (fes == null) {
                fes = new ArrayList<FootnoteEntry>();
                this.map.put(ari, fes);
            }
            FootnoteEntry fe = entry.getValue();
            fes.add(fe);
        }
    }

    public LinkedHashMap<Integer, FootnoteEntry> toEntries() {
        final LinkedHashMap<Integer, FootnoteEntry> res = new LinkedHashMap<Integer, FootnoteEntry>();
        this.processEach(new FootnoteProcessor(){

            @Override
            public void process(FootnoteEntry fe, int ari, int entryIndex) {
                res.put(ari << 8 | entryIndex + 1, fe);
            }
        });
        return res;
    }

    public int addBegin(int ari) {
        List<FootnoteEntry> list = this.map.get(ari);
        if (list == null) {
            list = new ArrayList<FootnoteEntry>();
            this.map.put(ari, list);
        }
        FootnoteEntry fe = new FootnoteEntry();
        list.add(fe);
        return list.size() - 1;
    }

    public void appendText(int ari, String text) {
        List<FootnoteEntry> list = this.map.get(ari);
        if (list == null) {
            throw new RuntimeException("Must be after addBegin (1)");
        }
        FootnoteEntry fe = list.get(list.size() - 1);
        fe.content = fe.content != null ? fe.content + text : text;
    }

    public void dump() {
        for (Map.Entry<Integer, List<FootnoteEntry>> e : this.map.entrySet()) {
            List<FootnoteEntry> fes = e.getValue();
            for (int i = 0; i < fes.size(); ++i) {
                FootnoteEntry fe = fes.get(i);
                System.out.printf("Footnote 0x%06x(%d): [%s]%n", e.getKey(), i + 1, fe.content);
            }
        }
    }

    public void processEach(FootnoteProcessor processor) {
        for (Map.Entry<Integer, List<FootnoteEntry>> e : this.map.entrySet()) {
            List<FootnoteEntry> fes = e.getValue();
            for (int i = 0; i < fes.size(); ++i) {
                FootnoteEntry fe = fes.get(i);
                processor.process(fe, e.getKey(), i);
            }
        }
    }

    public static void writeFootnoteEntriesTo(LinkedHashMap<Integer, FootnoteEntry> footnoteEntries, BintexWriter bw) throws IOException {
        bw.writeUint8(1);
        bw.writeInt(footnoteEntries.size());
        for (Map.Entry<Integer, FootnoteEntry> entry : footnoteEntries.entrySet()) {
            bw.writeInt(entry.getKey());
        }
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        BintexWriter contentsBw = new BintexWriter(contents);
        for (Map.Entry<Integer, FootnoteEntry> entry : footnoteEntries.entrySet()) {
            bw.writeInt(contentsBw.getPos());
            contentsBw.writeValueString(entry.getValue().content);
        }
        bw.writeRaw(contents.toByteArray());
    }

    public static interface FootnoteProcessor {
        public void process(FootnoteEntry var1, int var2, int var3);
    }
}

