/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_soe_ip_h__
#define __lr10_dev_soe_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_SOE_FALCON_EXTERRADDR                                                                        0x0168     /* R--4R */
#define NV_SOE_FALCON_EXTERRADDR_ADDR                                                                   31:0           /* R--VF */
#define NV_SOE_FALCON_EXTERRSTAT                                                                        0x016c     /* RW-4R */
#define NV_SOE_FALCON_EXTERRSTAT_PC                                                                     23:0           /* R--VF */
#define NV_SOE_FALCON_EXTERRSTAT_STAT                                                                   27:24          /* R--VF */
#define NV_SOE_FALCON_EXTERRSTAT_STAT_ACK_POS                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_EXTERRSTAT_STAT_ACK_TOUT                                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_EXTERRSTAT_VALID                                                                  31:31          /* RWIVF */
#define NV_SOE_FALCON_EXTERRSTAT_VALID_INIT                                                             0x00000000     /* RWI-V */
#define NV_SOE_FALCON_EXTERRSTAT_VALID_FALSE                                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_EXTERRSTAT_VALID_TRUE                                                             0x00000001     /* RW--V */
#define NV_SOE_FALCON_HWCFG1                                                                            0x012c     /* R--4R */
#define NV_SOE_FALCON_HWCFG1_CORE_REV                                                                   3:0            /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_INIT                                                              0x00000006     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_1_0                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_2_0                                                               0x00000002     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_3_0                                                               0x00000003     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_4_0                                                               0x00000004     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_5_0                                                               0x00000005     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_6_0                                                               0x00000006     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_7_0                                                               0x00000007     /* R---V */
#define NV_SOE_FALCON_HWCFG1_SECURITY_MODEL                                                             5:4            /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_SECURITY_MODEL_INIT                                                        0x00000003     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_SECURITY_MODEL_NONE                                                        0x00000000     /* R---V */
#define NV_SOE_FALCON_HWCFG1_SECURITY_MODEL_LIGHT                                                       0x00000002     /* R---V */
#define NV_SOE_FALCON_HWCFG1_SECURITY_MODEL_HEAVY                                                       0x00000003     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_SUBVERSION                                                        7:6            /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_SUBVERSION_INIT                                                   0x00000000     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_SUBVERSION_0                                                      0x00000000     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_SUBVERSION_1                                                      0x00000001     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_SUBVERSION_2                                                      0x00000002     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CORE_REV_SUBVERSION_3                                                      0x00000003     /* R---V */
#define NV_SOE_FALCON_HWCFG1_IMEM_PORTS                                                                 11:8           /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_IMEM_PORTS_INIT                                                            0x00000001     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_DMEM_PORTS                                                                 15:12          /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_DMEM_PORTS_INIT                                                            0x00000001     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_TAG_WIDTH                                                                  20:16          /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_TAG_WIDTH_INIT                                                             0x00000010     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_DMEM_TAG_WIDTH                                                             25:21          /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_DMEM_TAG_WIDTH_INIT                                                        0x00000010     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_DBG_PRIV_BUS                                                               27:27          /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_DBG_PRIV_BUS_INIT                                                          0x00000001     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_DBG_PRIV_BUS_ENABLE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_HWCFG1_DBG_PRIV_BUS_DISABLE                                                       0x00000000     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CSB_SIZE_16M                                                               28:28          /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_CSB_SIZE_16M_INIT                                                          0x00000000     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_CSB_SIZE_16M_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_HWCFG1_CSB_SIZE_16M_FALSE                                                         0x00000000     /* R---V */
#define NV_SOE_FALCON_HWCFG1_PRIV_DIRECT                                                                29:29          /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_PRIV_DIRECT_INIT                                                           0x00000000     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_PRIV_DIRECT_TRUE                                                           0x00000001     /* R---V */
#define NV_SOE_FALCON_HWCFG1_PRIV_DIRECT_FALSE                                                          0x00000000     /* R---V */
#define NV_SOE_FALCON_HWCFG1_DMEM_APERTURES                                                             30:30          /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_DMEM_APERTURES_INIT                                                        0x00000001     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_DMEM_APERTURES_ENABLE                                                      0x00000001     /* R---V */
#define NV_SOE_FALCON_HWCFG1_DMEM_APERTURES_DISABLE                                                     0x00000000     /* R---V */
#define NV_SOE_FALCON_HWCFG1_IMEM_AUTOFILL                                                              31:31          /* R-IVF */
#define NV_SOE_FALCON_HWCFG1_IMEM_AUTOFILL_INIT                                                         0x00000001     /* R-I-V */
#define NV_SOE_FALCON_HWCFG1_IMEM_AUTOFILL_ENABLE                                                       0x00000001     /* R---V */
#define NV_SOE_FALCON_HWCFG1_IMEM_AUTOFILL_DISABLE                                                      0x00000000     /* R---V */
#define NV_SOE_HWCFG                                                                                    0x0abc     /* R--4R */
#define NV_SOE_HWCFG_EMEM_SIZE                                                                          8:0            /* R--VF */
#define NV_SOE_EMEMC(i)                                                                                 (0x0ac0+(i)*8) /* RW-4A */
#define NV_SOE_EMEMC__SIZE_1                                                                            4              /*       */
#define NV_SOE_EMEMC_OFFS                                                                               7:2            /* RWIVF */
#define NV_SOE_EMEMC_OFFS_INIT                                                                          0x00000000     /* RWI-V */
#define NV_SOE_EMEMC_BLK                                                                                15:8           /* RWIVF */
#define NV_SOE_EMEMC_BLK_INIT                                                                           0x00000000     /* RWI-V */
#define NV_SOE_EMEMC_AINCW                                                                              24:24          /* RWIVF */
#define NV_SOE_EMEMC_AINCW_INIT                                                                         0x00000000     /* RWI-V */
#define NV_SOE_EMEMC_AINCW_TRUE                                                                         0x00000001     /* RW--V */
#define NV_SOE_EMEMC_AINCW_FALSE                                                                        0x00000000     /* RW--V */
#define NV_SOE_EMEMC_AINCR                                                                              25:25          /* RWIVF */
#define NV_SOE_EMEMC_AINCR_INIT                                                                         0x00000000     /* RWI-V */
#define NV_SOE_EMEMC_AINCR_TRUE                                                                         0x00000001     /* RW--V */
#define NV_SOE_EMEMC_AINCR_FALSE                                                                        0x00000000     /* RW--V */
#define NV_SOE_EMEMD(i)                                                                                 (0x0ac4+(i)*8) /* RW-4A */
#define NV_SOE_EMEMD__SIZE_1                                                                            4              /*       */
#define NV_SOE_EMEMD_DATA                                                                               31:0           /* RW-VF */
#define NV_SOE_MSGQ_TAIL(i)                                                                             (0x0c84+(i)*8) /* RW-4A */
#define NV_SOE_MSGQ_TAIL__SIZE_1                                                                        8              /*       */
#define NV_SOE_MSGQ_TAIL_VAL                                                                            31:0           /* RWIUF */
#define NV_SOE_MSGQ_TAIL_VAL_INIT                                                                       0x00000000     /* RWI-V */
#define NV_SOE_MSGQ_HEAD(i)                                                                             (0x0c80+(i)*8) /* RW-4A */
#define NV_SOE_MSGQ_HEAD__SIZE_1                                                                        8              /*       */
#define NV_SOE_MSGQ_HEAD_VAL                                                                            31:0           /* RWIUF */
#define NV_SOE_MSGQ_HEAD_VAL_INIT                                                                       0x00000000     /* RWI-V */
#define NV_SOE_QUEUE_TAIL(i)                                                                            (0x0c04+(i)*8) /* RW-4A */
#define NV_SOE_QUEUE_TAIL__SIZE_1                                                                       8              /*       */
#define NV_SOE_QUEUE_TAIL_ADDRESS                                                                       31:0           /* RWIVF */
#define NV_SOE_QUEUE_TAIL_ADDRESS_INIT                                                                  0x00000000     /* RWI-V */
#define NV_SOE_QUEUE_HEAD(i)                                                                            (0x0c00+(i)*8) /* RW-4A */
#define NV_SOE_QUEUE_HEAD__SIZE_1                                                                       8              /*       */
#define NV_SOE_QUEUE_HEAD_ADDRESS                                                                       31:0           /* RWIVF */
#define NV_SOE_QUEUE_HEAD_ADDRESS_INIT                                                                  0x00000000     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG(i)                                                                         (0x0600+(i)*4) /* RW-4A */
#define NV_SOE_FBIF_TRANSCFG__SIZE_1                                                                    8              /*       */
#define NV_SOE_FBIF_TRANSCFG_TARGET                                                                     1:0            /* RWIVF */
#define NV_SOE_FBIF_TRANSCFG_TARGET_INIT                                                                0x00000000     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG_TARGET_LOCAL_FB                                                            0x00000000     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_TARGET_COHERENT_SYSMEM                                                     0x00000001     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_TARGET_NONCOHERENT_SYSMEM                                                  0x00000002     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_MEM_TYPE                                                                   2:2            /* RWIVF */
#define NV_SOE_FBIF_TRANSCFG_MEM_TYPE_INIT                                                              0x00000000     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG_MEM_TYPE_VIRTUAL                                                           0x00000000     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_MEM_TYPE_PHYSICAL                                                          0x00000001     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_L2C_WR                                                                     5:4            /* RWIVF */
#define NV_SOE_FBIF_TRANSCFG_L2C_WR_INIT                                                                0x00000001     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG_L2C_WR_L2_EVICT_FIRST                                                      0x00000000     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_L2C_WR_L2_EVICT_NORMAL                                                     0x00000001     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_L2C_WR_L2_EVICT_LAST                                                       0x00000002     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_L2C_RD                                                                     9:8            /* RWIVF */
#define NV_SOE_FBIF_TRANSCFG_L2C_RD_INIT                                                                0x00000001     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG_L2C_RD_L2_EVICT_FIRST                                                      0x00000000     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_L2C_RD_L2_EVICT_NORMAL                                                     0x00000001     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_L2C_RD_L2_EVICT_LAST                                                       0x00000002     /* R---V */
#define NV_SOE_FBIF_TRANSCFG_WACHK0                                                                     12:12          /* RWIVF */
#define NV_SOE_FBIF_TRANSCFG_WACHK0_INIT                                                                0x00000000     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG_WACHK0_ENABLE                                                              0x00000001     /* RW--V */
#define NV_SOE_FBIF_TRANSCFG_WACHK0_DISABLE                                                             0x00000000     /* RW--V */
#define NV_SOE_FBIF_TRANSCFG_WACHK1                                                                     13:13          /* RWIVF */
#define NV_SOE_FBIF_TRANSCFG_WACHK1_INIT                                                                0x00000000     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG_WACHK1_ENABLE                                                              0x00000001     /* RW--V */
#define NV_SOE_FBIF_TRANSCFG_WACHK1_DISABLE                                                             0x00000000     /* RW--V */
#define NV_SOE_FBIF_TRANSCFG_RACHK0                                                                     14:14          /* RWIVF */
#define NV_SOE_FBIF_TRANSCFG_RACHK0_INIT                                                                0x00000000     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG_RACHK0_ENABLE                                                              0x00000001     /* RW--V */
#define NV_SOE_FBIF_TRANSCFG_RACHK0_DISABLE                                                             0x00000000     /* RW--V */
#define NV_SOE_FBIF_TRANSCFG_RACHK1                                                                     15:15          /* RWIVF */
#define NV_SOE_FBIF_TRANSCFG_RACHK1_INIT                                                                0x00000000     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG_RACHK1_ENABLE                                                              0x00000001     /* RW--V */
#define NV_SOE_FBIF_TRANSCFG_RACHK1_DISABLE                                                             0x00000000     /* RW--V */
#define NV_SOE_FBIF_TRANSCFG_ENGINE_ID_FLAG                                                             16:16          /* RWIVF */
#define NV_SOE_FBIF_TRANSCFG_ENGINE_ID_FLAG_BAR2_FN0                                                    0x00000000     /* RWI-V */
#define NV_SOE_FBIF_TRANSCFG_ENGINE_ID_FLAG_OWN                                                         0x00000001     /* RW--V */
#define NV_SOE_FBIF_CG1                                                                                 0x0674     /* RW-4R */
#define NV_SOE_FBIF_CG1_SLCG                                                                            3:0            /*       */
#define NV_SOE_FBIF_CG1_SLCG_ENABLED                                                                    0              /*       */
#define NV_SOE_FBIF_CG1_SLCG_DISABLED                                                                   0xF            /*       */
#define NV_SOE_FBIF_CG1_SLCG__PROD                                                                      0x0            /*       */
#define NV_SOE_FBIF_CG1_SLCG_MSD0                                                                       0:0            /* RWIVF */
#define NV_SOE_FBIF_CG1_SLCG_MSD0_ENABLED                                                               0x00000000     /* RW--V */
#define NV_SOE_FBIF_CG1_SLCG_MSD0_DISABLED                                                              0x00000001     /* RWI-V */
#define NV_SOE_FBIF_CG1_SLCG_MSD1                                                                       1:1            /* RWIVF */
#define NV_SOE_FBIF_CG1_SLCG_MSD1_ENABLED                                                               0x00000000     /* RW--V */
#define NV_SOE_FBIF_CG1_SLCG_MSD1_DISABLED                                                              0x00000001     /* RWI-V */
#define NV_SOE_FBIF_CG1_SLCG_FB0                                                                        2:2            /* RWIVF */
#define NV_SOE_FBIF_CG1_SLCG_FB0_ENABLED                                                                0x00000000     /* RW--V */
#define NV_SOE_FBIF_CG1_SLCG_FB0_DISABLED                                                               0x00000001     /* RWI-V */
#define NV_SOE_FBIF_CG1_SLCG_FB1                                                                        3:3            /* RWIVF */
#define NV_SOE_FBIF_CG1_SLCG_FB1_ENABLED                                                                0x00000000     /* RW--V */
#define NV_SOE_FBIF_CG1_SLCG_FB1_DISABLED                                                               0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2                                                                               0x0134     /* RWI4R */
#define NV_SOE_FALCON_CG2_SLCG                                                                          17:1           /*       */
#define NV_SOE_FALCON_CG2_SLCG_ENABLED                                                                  0              /*       */
#define NV_SOE_FALCON_CG2_SLCG_DISABLED                                                                 0x1FFFF        /*       */
#define NV_SOE_FALCON_CG2_SLCG__PROD                                                                    0x10004        /*       */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DMA                                                               1:1            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DMA_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DMA_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GC6_SR_FSM                                                        2:2            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GC6_SR_FSM_ENABLED                                                0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GC6_SR_FSM_DISABLED                                               0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PIPE                                                              3:3            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PIPE_ENABLED                                                      0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PIPE_DISABLED                                                     0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DIV                                                               4:4            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DIV_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DIV_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_ICD                                                               5:5            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_ICD_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_ICD_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CFG                                                               6:6            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CFG_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CFG_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CTXSW                                                             7:7            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CTXSW_ENABLED                                                     0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CTXSW_DISABLED                                                    0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PMB                                                               8:8            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PMB_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PMB_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_RF                                                                9:9            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_RF_ENABLED                                                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_RF_DISABLED                                                       0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_MUL                                                               10:10          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_MUL_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_MUL_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_LDST                                                              11:11          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_LDST_ENABLED                                                      0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_LDST_DISABLED                                                     0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSYNC                                                             12:12          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSYNC_ENABLED                                                     0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSYNC_DISABLED                                                    0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GPTMR                                                             13:13          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GPTMR_ENABLED                                                     0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GPTMR_DISABLED                                                    0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_WDTMR                                                             14:14          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_WDTMR_ENABLED                                                     0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_WDTMR_DISABLED                                                    0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_IRQSTAT                                                           15:15          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_IRQSTAT_ENABLED                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_IRQSTAT_DISABLED                                                  0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TOP                                                               16:16          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TOP_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TOP_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FBIF                                                                     17:17          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FBIF_ENABLED                                                             0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FBIF_DISABLED                                                            0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_SHA                                                               18:18          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_SHA_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_SHA_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_MISC_CG1                                                                                 0x083c     /* RW-4R */
#define NV_SOE_MISC_CG1_SLCG                                                                            31:0           /* RWIVF */
#define NV_SOE_MISC_CG1_SLCG_ENABLED                                                                    0x00000000     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_DISABLED                                                                   0x800000ff     /* RWI-V */
#define NV_SOE_MISC_CG1_SLCG__PROD                                                                      0x000000fe     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_FALCON                                                                     0:0            /* RWIVF */
#define NV_SOE_MISC_CG1_SLCG_FALCON_ENABLED                                                             0x00000000     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_FALCON_DISABLED                                                            0x00000001     /* RWI-V */
#define NV_SOE_MISC_CG1_SLCG_SCP                                                                        2:2            /* RWIVF */
#define NV_SOE_MISC_CG1_SLCG_SCP_ENABLED                                                                0x00000000     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_SCP_DISABLED                                                               0x00000001     /* RWI-V */
#define NV_SOE_MISC_CG1_SLCG_CSBMASTER                                                                  3:3            /* RWIVF */
#define NV_SOE_MISC_CG1_SLCG_CSBMASTER_ENABLED                                                          0x00000000     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_CSBMASTER_DISABLED                                                         0x00000001     /* RWI-V */
#define NV_SOE_MISC_CG1_SLCG_BAR0                                                                       4:4            /* RWIVF */
#define NV_SOE_MISC_CG1_SLCG_BAR0_ENABLED                                                               0x00000000     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_BAR0_DISABLED                                                              0x00000001     /* RWI-V */
#define NV_SOE_MISC_CG1_SLCG_MISC                                                                       5:5            /* RWIVF */
#define NV_SOE_MISC_CG1_SLCG_MISC_ENABLED                                                               0x00000000     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_MISC_DISABLED                                                              0x00000001     /* RWI-V */
#define NV_SOE_MISC_CG1_SLCG_TOP                                                                        31:31          /* RWIVF */
#define NV_SOE_MISC_CG1_SLCG_TOP_ENABLED                                                                0x00000000     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_TOP_DISABLED                                                               0x00000001     /* RWI-V */
#define NV_SOE_MISC_TOP_CG                                                                              0x0840     /* RW-4R */
#define NV_SOE_MISC_TOP_CG_IDLE_CG_DLY_CNT                                                              5:0            /* RWEVF */
#define NV_SOE_MISC_TOP_CG_IDLE_CG_DLY_CNT_INIT                                                         0x0000001f     /* RWE-V */
#define NV_SOE_MISC_TOP_CG_IDLE_CG_DLY_CNT__PROD                                                        0x00000002     /* RW--V */
#define NV_SOE_FALCON_ENGINE                                                                            0x03c0     /* RW-4R */
#define NV_SOE_FALCON_ENGINE_RESET                                                                      0:0            /* RWIVF */
#define NV_SOE_FALCON_ENGINE_RESET_TRUE                                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_ENGINE_RESET_FALSE                                                                0x00000000     /* RWI-V */
#define NV_SOE_SCP_CTL_STAT                                                                             0x0408     /* R--4R */
#define NV_SOE_SCP_CTL_STAT_DEBUG_MODE                                                                  20:20          /* R--VF */
#define NV_SOE_SCP_CTL_STAT_DEBUG_MODE_DISABLED                                                         0x00000000     /* R---V */
#define NV_SOE_SCP_CTL_STAT_AES_SCC_DIS                                                                 2:2            /* R--VF */
#define NV_SOE_SCP_CTL_STAT_AES_SCC_DIS_TRUE                                                            0x00000001     /* R---V */
#define NV_SOE_SCP_CTL_STAT_AES_SCC_DIS_FALSE                                                           0x00000000     /* R---V */
#define NV_SOE_SCP_CTL_STAT_HSMODE                                                                      1:1            /* R--VF */
#define NV_SOE_SCP_CTL_STAT_HSMODE_TRUE                                                                 0x00000001     /* R---V */
#define NV_SOE_SCP_CTL_STAT_HSMODE_FALSE                                                                0x00000000     /* R---V */
#define NV_SOE_SCP_CTL_STAT_SBOOT                                                                       0:0            /* R--VF */
#define NV_SOE_SCP_CTL_STAT_SBOOT_TRUE                                                                  0x00000001     /* R---V */
#define NV_SOE_SCP_CTL_STAT_SBOOT_FALSE                                                                 0x00000000     /* R---V */
#define NV_SOE_FALCON_MAILBOX0                                                                          0x0040     /* RW-4R */
#define NV_SOE_FALCON_MAILBOX0_DATA                                                                     31:0           /* RWIVF */
#define NV_SOE_FALCON_MAILBOX0_DATA_INIT                                                                0x00000000     /* RWI-V */
#define NV_SOE_FALCON_MAILBOX1                                                                          0x0044     /* RW-4R */
#define NV_SOE_FALCON_MAILBOX1_DATA                                                                     31:0           /* RWIVF */
#define NV_SOE_FALCON_MAILBOX1_DATA_INIT                                                                0x00000000     /* RWI-V */

#define NV_SOE_FALCON_CPUCTL                                                                            0x0100     /* RW-4R */
#define NV_SOE_FALCON_CPUCTL_IINVAL                                                                     0:0            /* -WXVF */
#define NV_SOE_FALCON_CPUCTL_IINVAL_TRUE                                                                0x00000001     /* -W--V */
#define NV_SOE_FALCON_CPUCTL_IINVAL_FALSE                                                               0x00000000     /* -W--V */
#define NV_SOE_FALCON_CPUCTL_STARTCPU                                                                   1:1            /* -WXVF */
#define NV_SOE_FALCON_CPUCTL_STARTCPU_TRUE                                                              0x00000001     /* -W--V */
#define NV_SOE_FALCON_CPUCTL_STARTCPU_FALSE                                                             0x00000000     /* -W--V */
#define NV_SOE_FALCON_CPUCTL_SRESET                                                                     2:2            /* -WXVF */
#define NV_SOE_FALCON_CPUCTL_SRESET_TRUE                                                                0x00000001     /* -W--V */
#define NV_SOE_FALCON_CPUCTL_SRESET_FALSE                                                               0x00000000     /* -W--V */
#define NV_SOE_FALCON_CPUCTL_HRESET                                                                     3:3            /* -WXVF */
#define NV_SOE_FALCON_CPUCTL_HRESET_TRUE                                                                0x00000001     /* -W--V */
#define NV_SOE_FALCON_CPUCTL_HRESET_FALSE                                                               0x00000000     /* -W--V */
#define NV_SOE_FALCON_CPUCTL_HALTED                                                                     4:4            /* R-XVF */
#define NV_SOE_FALCON_CPUCTL_HALTED_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_CPUCTL_HALTED_FALSE                                                               0x00000000     /* R---V */
#define NV_SOE_FALCON_CPUCTL_STOPPED                                                                    5:5            /* R-XVF */
#define NV_SOE_FALCON_CPUCTL_STOPPED_TRUE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_CPUCTL_STOPPED_FALSE                                                              0x00000000     /* R---V */
#define NV_SOE_FALCON_CPUCTL_ALIAS_EN                                                                   6:6            /* RWIVF */
#define NV_SOE_FALCON_CPUCTL_ALIAS_EN_TRUE                                                              0x00000001     /* RW--V */
#define NV_SOE_FALCON_CPUCTL_ALIAS_EN_FALSE                                                             0x00000000     /* RW--V */
#define NV_SOE_FALCON_CPUCTL_ALIAS_EN_INIT                                                              0x00000000     /* RWI-V */
#define NV_SOE_FALCON_CPUCTL_ALIAS                                                                      0x0130     /* -W-4R */
#define NV_SOE_FALCON_CPUCTL_ALIAS_STARTCPU                                                             1:1            /* -WXVF */
#define NV_SOE_FALCON_CPUCTL_ALIAS_STARTCPU_TRUE                                                        0x00000001     /* -W--V */
#define NV_SOE_FALCON_CPUCTL_ALIAS_STARTCPU_FALSE                                                       0x00000000     /* -W--V */

#define NV_SOE_FALCON_DEBUGINFO                                                                         0x0094     /* RW-4R */
#define NV_SOE_FALCON_DEBUGINFO_DATA                                                                    31:0           /* RWXVF */
#define NV_SOE_FALCON_EXCI                                                                              0x00d0     /* R--4R */
#define NV_SOE_FALCON_EXCI_EXPC                                                                         19:0           /* R-XVF */
#define NV_SOE_FALCON_EXCI_EXCAUSE                                                                      24:20          /* R-XVF */
#define NV_SOE_FALCON_EXCI_EXCAUSE_TRAP0                                                                0x00000000     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_TRAP1                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_TRAP2                                                                0x00000002     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_TRAP3                                                                0x00000003     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_ILL_INS                                                              0x00000008     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_INV_INS                                                              0x00000009     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_MISS_INS                                                             0x0000000a     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_DHIT_INS                                                             0x0000000b     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_SP_OVERFLOW                                                          0x0000000d     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_BRKPT_INS                                                            0x0000000f     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_DMEM_MISS_INS                                                        0x00000010     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_DMEM_DHIT_INS                                                        0x00000011     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_DMEM_PAFAULT_INS                                                     0x00000012     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_DMEM_PERMISSION_INS                                                  0x00000013     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_BROM_CALL_INS                                                        0x00000015     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_KMEM_VIOLATION_INS                                                   0x00000016     /* R---V */
#define NV_SOE_FALCON_EXCI_EXCAUSE_BMEM_PERMISSION_INS                                                  0x00000017     /* R---V */
#define NV_SOE_FALCON_EXCI_EXPC_HIGH                                                                    31:28          /* R-XVF */
#define NV_SOE_FALCON_SCTL                                                                              0x0240     /* RW-4R */
#define NV_SOE_FALCON_SCTL_LSMODE                                                                       0:0            /* RWIVF */
#define NV_SOE_FALCON_SCTL_LSMODE_FALSE                                                                 0x00000000     /* RWI-V */
#define NV_SOE_FALCON_SCTL_LSMODE_TRUE                                                                  0x00000001     /* RW--V */
#define NV_SOE_FALCON_SCTL_HSMODE                                                                       1:1            /* R--VF */
#define NV_SOE_FALCON_SCTL_HSMODE_FALSE                                                                 0x00000000     /* R---V */
#define NV_SOE_FALCON_SCTL_HSMODE_TRUE                                                                  0x00000001     /* R---V */
#define NV_SOE_FALCON_SCTL_LSMODE_LEVEL                                                                 5:4            /* RWIVF */
#define NV_SOE_FALCON_SCTL_LSMODE_LEVEL_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_SCTL_UCODE_LEVEL                                                                  5:4            /*       */
#define NV_SOE_FALCON_SCTL_UCODE_LEVEL_INIT                                                             0              /*       */
#define NV_SOE_FALCON_SCTL_DEBUG_PRIV_LEVEL                                                             9:8            /* RWIVF */
#define NV_SOE_FALCON_SCTL_DEBUG_PRIV_LEVEL_INIT                                                        0x00000000     /* RWI-V */
#define NV_SOE_FALCON_SCTL_RESET_LVLM_EN                                                                12:12          /* RWIVF */
#define NV_SOE_FALCON_SCTL_RESET_LVLM_EN_TRUE                                                           0x00000001     /* RWI-V */
#define NV_SOE_FALCON_SCTL_RESET_LVLM_EN_FALSE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_SCTL_STALLREQ_CLR_EN                                                              13:13          /* RWIVF */
#define NV_SOE_FALCON_SCTL_STALLREQ_CLR_EN_TRUE                                                         0x00000001     /* RWI-V */
#define NV_SOE_FALCON_SCTL_STALLREQ_CLR_EN_FALSE                                                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_SCTL_AUTH_EN                                                                      14:14          /* RWIVF */
#define NV_SOE_FALCON_SCTL_AUTH_EN_TRUE                                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_SCTL_AUTH_EN_FALSE                                                                0x00000000     /* RWI-V */
#define NV_SOE_FALCON_SCTL1                                                                             0x0250     /* RW-4R */
#define NV_SOE_FALCON_SCTL1_CSBLVL_MASK                                                                 1:0            /* RWIVF */
#define NV_SOE_FALCON_SCTL1_CSBLVL_MASK_INIT                                                            0x00000003     /* RWI-V */
#define NV_SOE_FALCON_SCTL1_EXTLVL_MASK                                                                 3:2            /* RWIVF */
#define NV_SOE_FALCON_SCTL1_EXTLVL_MASK_INIT                                                            0x00000003     /* RWI-V */
#define NV_SOE_MISC_EXTIO_IRQSTAT                                                                       0x0850     /* R-I4R */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HUBIRQ0                                                               0:0            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HUBIRQ0_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HUBIRQ0_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HUBIRQ1                                                               1:1            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HUBIRQ1_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HUBIRQ1_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HOST_STALLINTR                                                        2:2            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HOST_STALLINTR_FALSE                                                  0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HOST_STALLINTR_TRUE                                                   0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HOST_NOSTALLINTR                                                      3:3            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HOST_NOSTALLINTR_FALSE                                                0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_HOST_NOSTALLINTR_TRUE                                                 0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_DISP_INTR                                                             4:4            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQSTAT_DISP_INTR_FALSE                                                       0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_DISP_INTR_TRUE                                                        0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_PMGR_INTR                                                             5:5            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQSTAT_PMGR_INTR_FALSE                                                       0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_PMGR_INTR_TRUE                                                        0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_RESERVED                                                              31:6           /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQSTAT_RESERVED_FALSE                                                        0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQSTAT_RESERVED_TRUE                                                         0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQMASK                                                                       0x085c     /* R-I4R */
#define NV_SOE_MISC_EXTIO_IRQMASK_HUBIRQ0                                                               0:0            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQMASK_HUBIRQ0_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQMASK_HUBIRQ0_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQMASK_HUBIRQ1                                                               1:1            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQMASK_HUBIRQ1_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQMASK_HUBIRQ1_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQMASK_HOST_STALLINTR                                                        2:2            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQMASK_HOST_STALLINTR_FALSE                                                  0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQMASK_HOST_STALLINTR_TRUE                                                   0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQMASK_HOST_NOSTALLINTR                                                      3:3            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQMASK_HOST_NOSTALLINTR_FALSE                                                0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQMASK_HOST_NOSTALLINTR_TRUE                                                 0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQMASK_DISP_INTR                                                             4:4            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQMASK_DISP_INTR_FALSE                                                       0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQMASK_DISP_INTR_TRUE                                                        0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQMASK_PMGR_INTR                                                             5:5            /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQMASK_PMGR_INTR_FALSE                                                       0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQMASK_PMGR_INTR_TRUE                                                        0x00000001     /* R---V */
#define NV_SOE_MISC_EXTIO_IRQMASK_RESERVED                                                              31:6           /* R-IVF */
#define NV_SOE_MISC_EXTIO_IRQMASK_RESERVED_FALSE                                                        0x00000000     /* R-I-V */
#define NV_SOE_MISC_EXTIO_IRQMASK_RESERVED_TRUE                                                         0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT                                                                           0x0008     /* R--4R */
#define NV_SOE_FALCON_IRQSTAT_GPTMR                                                                     0:0            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_GPTMR_FALSE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_GPTMR_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_WDTMR                                                                     1:1            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_WDTMR_FALSE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_WDTMR_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_MTHD                                                                      2:2            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_MTHD_FALSE                                                                0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_MTHD_TRUE                                                                 0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_CTXSW                                                                     3:3            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_CTXSW_FALSE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_CTXSW_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_HALT                                                                      4:4            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_HALT_FALSE                                                                0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_HALT_TRUE                                                                 0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXTERR                                                                    5:5            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXTERR_FALSE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXTERR_TRUE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SWGEN0                                                                    6:6            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_SWGEN0_FALSE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_SWGEN0_TRUE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SWGEN1                                                                    7:7            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_SWGEN1_FALSE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_SWGEN1_TRUE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT                                                                       15:8           /*       */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ1                                                               8:8            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ1_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ1_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ2                                                               9:9            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ2_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ2_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ3                                                               10:10          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ3_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ3_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ4                                                               11:11          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ4_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ4_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ5                                                               12:12          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ5_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ5_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ6                                                               13:13          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ6_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ6_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ7                                                               14:14          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ7_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ7_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ8                                                               15:15          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ8_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ8_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_DMA                                                                       16:16          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_DMA_TRUE                                                                  0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_DMA_FALSE                                                                 0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_SHA                                                                       17:17          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_SHA_TRUE                                                                  0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SHA_FALSE                                                                 0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_MEMERR                                                                    18:18          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_MEMERR_TRUE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_MEMERR_FALSE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_FALCON                                                                    19:19          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_FALCON_TURE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_FALCON_FALSE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_RISCV                                                                     20:20          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_RISCV_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_RISCV_FALSE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_TRACE                                                                     21:21          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_TRACE_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_TRACE_FALSE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS                                                                     0x00fc     /* R--4R */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_GPTMR                                                               0:0            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_GPTMR_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_GPTMR_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_WDTMR                                                               1:1            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_WDTMR_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_WDTMR_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_MTHD                                                                2:2            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_MTHD_FALSE                                                          0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_MTHD_TRUE                                                           0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_CTXSW                                                               3:3            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_CTXSW_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_CTXSW_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_HALT                                                                4:4            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_HALT_FALSE                                                          0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_HALT_TRUE                                                           0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXTERR                                                              5:5            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXTERR_FALSE                                                        0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXTERR_TRUE                                                         0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_SWGEN0                                                              6:6            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_SWGEN0_FALSE                                                        0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_SWGEN0_TRUE                                                         0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_SWGEN1                                                              7:7            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_SWGEN1_FALSE                                                        0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_SWGEN1_TRUE                                                         0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT                                                                 15:8           /*       */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ1                                                         8:8            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ1_TRUE                                                    0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ1_FALSE                                                   0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ2                                                         9:9            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ2_TRUE                                                    0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ2_FALSE                                                   0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ3                                                         10:10          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ3_TRUE                                                    0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ3_FALSE                                                   0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ4                                                         11:11          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ4_TRUE                                                    0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ4_FALSE                                                   0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ5                                                         12:12          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ5_TRUE                                                    0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ5_FALSE                                                   0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ6                                                         13:13          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ6_TRUE                                                    0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ6_FALSE                                                   0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ7                                                         14:14          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ7_TRUE                                                    0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ7_FALSE                                                   0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ8                                                         15:15          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ8_TRUE                                                    0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_EXT_EXTIRQ8_FALSE                                                   0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_DMA                                                                 16:16          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_DMA_TRUE                                                            0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_DMA_FALSE                                                           0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_SHA                                                                 17:17          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_SHA_TRUE                                                            0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_SHA_FALSE                                                           0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_MEMERR                                                              18:18          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_MEMERR_TRUE                                                         0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_MEMERR_FALSE                                                        0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_FALCON                                                              19:19          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_FALCON_TURE                                                         0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_FALCON_FALSE                                                        0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_RISCV                                                               20:20          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_RISCV_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_RISCV_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_TRACE                                                               21:21          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_TRACE_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ALIAS_TRACE_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMODE                                                                           0x000c     /* RW-4R */
#define NV_SOE_FALCON_IRQMODE_LVL_GPTMR                                                                 0:0            /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_GPTMR_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_GPTMR_FALSE                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_GPTMR_TRUE                                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_WDTMR                                                                 1:1            /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_WDTMR_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_WDTMR_FALSE                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_WDTMR_TRUE                                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_MTHD                                                                  2:2            /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_MTHD_INIT                                                             0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_MTHD_FALSE                                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_MTHD_TRUE                                                             0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_CTXSW                                                                 3:3            /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_CTXSW_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_CTXSW_FALSE                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_CTXSW_TRUE                                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_HALT                                                                  4:4            /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_HALT_INIT                                                             0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_HALT_FALSE                                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_HALT_TRUE                                                             0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_EXTERR                                                                5:5            /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_EXTERR_INIT                                                           0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_EXTERR_FALSE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_EXTERR_TRUE                                                           0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_SWGEN0                                                                6:6            /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_SWGEN0_INIT                                                           0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_SWGEN0_FALSE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_SWGEN0_TRUE                                                           0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_SWGEN1                                                                7:7            /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_SWGEN1_INIT                                                           0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_SWGEN1_FALSE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_SWGEN1_TRUE                                                           0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT                                                                   15:8           /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_INIT                                                              0x000000fc     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ1                                                           8:8            /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ1_TRUE                                                      1              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ1_FALSE                                                     0              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ2                                                           9:9            /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ2_TRUE                                                      1              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ2_FALSE                                                     0              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ3                                                           10:10          /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ3_TRUE                                                      1              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ3_FALSE                                                     0              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ4                                                           11:11          /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ4_TRUE                                                      1              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ4_FALSE                                                     0              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ5                                                           12:12          /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ5_TRUE                                                      1              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ5_FALSE                                                     0              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ6                                                           13:13          /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ6_TRUE                                                      1              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ6_FALSE                                                     0              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ7                                                           14:14          /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ7_TRUE                                                      1              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ7_FALSE                                                     0              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ8                                                           15:15          /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ8_TRUE                                                      1              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_EXT_EXTIRQ8_FALSE                                                     0              /*       */
#define NV_SOE_FALCON_IRQMODE_LVL_DMA                                                                   16:16          /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_DMA_INIT                                                              0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_DMA_TRUE                                                              0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_DMA_FALSE                                                             0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_SHA                                                                   17:17          /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_SHA_INIT                                                              0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_SHA_TRUE                                                              0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_SHA_FALSE                                                             0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_MEMERR                                                                18:18          /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_MEMERR_INIT                                                           0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_MEMERR_TRUE                                                           0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_MEMERR_FALSE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_FALCON                                                                19:19          /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_FALCON_INIT                                                           0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_FALCON_TRUE                                                           0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_FALCON_FALSE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_RISCV                                                                 20:20          /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_RISCV_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_RISCV_TRUE                                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_RISCV_FALSE                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_TRACE                                                                 21:21          /* RWIVF */
#define NV_SOE_FALCON_IRQMODE_LVL_TRACE_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQMODE_LVL_TRACE_TRUE                                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQMODE_LVL_TRACE_FALSE                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQMASK                                                                           0x0018     /* R--4R */
#define NV_SOE_FALCON_IRQMASK_GPTMR                                                                     0:0            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_GPTMR_DISABLE                                                             0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_GPTMR_ENABLE                                                              0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_WDTMR                                                                     1:1            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_WDTMR_DISABLE                                                             0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_WDTMR_ENABLE                                                              0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_MTHD                                                                      2:2            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_MTHD_DISABLE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_MTHD_ENABLE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_CTXSW                                                                     3:3            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_CTXSW_DISABLE                                                             0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_CTXSW_ENABLE                                                              0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_HALT                                                                      4:4            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_HALT_DISABLE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_HALT_ENABLE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXTERR                                                                    5:5            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_EXTERR_DISABLE                                                            0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_EXTERR_ENABLE                                                             0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_SWGEN0                                                                    6:6            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_SWGEN0_DISABLE                                                            0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_SWGEN0_ENABLE                                                             0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_SWGEN1                                                                    7:7            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_SWGEN1_DISABLE                                                            0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_SWGEN1_ENABLE                                                             0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXT                                                                       15:8           /*       */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ1                                                               8:8            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ1_ENABLE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ1_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ2                                                               9:9            /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ2_ENABLE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ2_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ3                                                               10:10          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ3_ENABLE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ3_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ4                                                               11:11          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ4_ENABLE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ4_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ5                                                               12:12          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ5_ENABLE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ5_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ6                                                               13:13          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ6_ENABLE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ6_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ7                                                               14:14          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ7_ENABLE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ7_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ8                                                               15:15          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ8_ENABLE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_EXT_EXTIRQ8_DISABLE                                                       0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_DMA                                                                       16:16          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_DMA_ENABLE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_DMA_DISABLE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_SHA                                                                       17:17          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_SHA_ENABLE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_SHA_DISABLE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_MEMERR                                                                    18:18          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_MEMERR_ENABLE                                                             0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_MEMERR_DISABLE                                                            0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_FALCON                                                                    19:19          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_FALCON_ENABLE                                                             0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_FALCON_DISABLE                                                            0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_RISCV                                                                     20:20          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_RISCV_ENABLE                                                              0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_RISCV_DISABLE                                                             0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQMASK_TRACE                                                                     21:21          /* R-IVF */
#define NV_SOE_FALCON_IRQMASK_TRACE_ENABLE                                                              0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQMASK_TRACE_DISABLE                                                             0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQDEST                                                                           0x001c     /* RW-4R */
#define NV_SOE_FALCON_IRQDEST_HOST_GPTMR                                                                0:0            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_GPTMR_INIT                                                           0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_GPTMR_FALCON                                                         0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_GPTMR_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_WDTMR                                                                1:1            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_WDTMR_INIT                                                           0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_WDTMR_FALCON                                                         0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_WDTMR_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_MTHD                                                                 2:2            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_MTHD_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_MTHD_FALCON                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_MTHD_HOST                                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_CTXSW                                                                3:3            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_CTXSW_INIT                                                           0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_CTXSW_FALCON                                                         0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_CTXSW_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_HALT                                                                 4:4            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_HALT_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_HALT_FALCON                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_HALT_HOST                                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXTERR                                                               5:5            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_EXTERR_INIT                                                          0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXTERR_FALCON                                                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXTERR_HOST                                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_SWGEN0                                                               6:6            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_SWGEN0_INIT                                                          0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_SWGEN0_FALCON                                                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_SWGEN0_HOST                                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_SWGEN1                                                               7:7            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_SWGEN1_INIT                                                          0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_SWGEN1_FALCON                                                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_SWGEN1_HOST                                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT                                                                  15:8           /*       */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ1                                                          8:8            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ1_HOST                                                     0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ1_FALCON                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ2                                                          9:9            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ2_HOST                                                     0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ2_FALCON                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ3                                                          10:10          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ3_HOST                                                     0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ3_FALCON                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ4                                                          11:11          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ4_HOST                                                     0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ4_FALCON                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ5                                                          12:12          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ5_HOST                                                     0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ5_FALCON                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ6                                                          13:13          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ6_HOST                                                     0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ6_FALCON                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ7                                                          14:14          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ7_HOST                                                     0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ7_FALCON                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ8                                                          15:15          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ8_HOST                                                     0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_HOST_EXT_EXTIRQ8_FALCON                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_GPTMR                                                              16:16          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_GPTMR_INIT                                                         0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_GPTMR_FALCON_IRQ0                                                  0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_GPTMR_FALCON_IRQ1                                                  0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_GPTMR_HOST_NORMAL                                                  0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_GPTMR_HOST_NONSTALL                                                0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_WDTMR                                                              17:17          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_WDTMR_INIT                                                         0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_WDTMR_FALCON_IRQ0                                                  0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_WDTMR_FALCON_IRQ1                                                  0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_WDTMR_HOST_NORMAL                                                  0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_WDTMR_HOST_NONSTALL                                                0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_MTHD                                                               18:18          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_MTHD_INIT                                                          0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_MTHD_FALCON_IRQ0                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_MTHD_FALCON_IRQ1                                                   0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_MTHD_HOST_NORMAL                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_MTHD_HOST_NONSTALL                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_CTXSW                                                              19:19          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_CTXSW_INIT                                                         0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_CTXSW_FALCON_IRQ0                                                  0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_CTXSW_FALCON_IRQ1                                                  0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_CTXSW_HOST_NORMAL                                                  0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_CTXSW_HOST_NONSTALL                                                0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_HALT                                                               20:20          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_HALT_INIT                                                          0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_HALT_FALCON_IRQ0                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_HALT_FALCON_IRQ1                                                   0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_HALT_HOST_NORMAL                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_HALT_HOST_NONSTALL                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXTERR                                                             21:21          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXTERR_INIT                                                        0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXTERR_FALCON_IRQ0                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXTERR_FALCON_IRQ1                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXTERR_HOST_NORMAL                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXTERR_HOST_NONSTALL                                               0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN0                                                             22:22          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN0_INIT                                                        0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN0_FALCON_IRQ0                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN0_FALCON_IRQ1                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN0_HOST_NORMAL                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN0_HOST_NONSTALL                                               0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN1                                                             23:23          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN1_INIT                                                        0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN1_FALCON_IRQ0                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN1_FALCON_IRQ1                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN1_HOST_NORMAL                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_SWGEN1_HOST_NONSTALL                                               0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT                                                                31:24          /*       */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1                                                        24:24          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_INIT                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ1_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2                                                        25:25          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_INIT                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ2_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3                                                        26:26          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_INIT                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ3_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4                                                        27:27          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_INIT                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ4_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5                                                        28:28          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_INIT                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ5_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6                                                        29:29          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_INIT                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ6_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7                                                        30:30          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_INIT                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ7_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8                                                        31:31          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_INIT                                                   0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_FALCON_IRQ0                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_FALCON_IRQ1                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_HOST_NORMAL                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST_TARGET_EXT_EXTIRQ8_HOST_NONSTALL                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2                                                                          0x003c     /* RW-4R */
#define NV_SOE_FALCON_IRQDEST2_HOST_DMA                                                                 0:0            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_HOST_DMA_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_HOST_DMA_FALCON                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_DMA_HOST                                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_SHA                                                                 1:1            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_HOST_SHA_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_HOST_SHA_FALCON                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_SHA_HOST                                                            0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_MEMERR                                                              2:2            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_HOST_MEMERR_INIT                                                         0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_HOST_MEMERR_FALCON                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_MEMERR_HOST                                                         0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_FALCON                                                              3:3            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_HOST_FALCON_INIT                                                         0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_HOST_FALCON_FALCON                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_FALCON_HOST                                                         0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_RISCV                                                               4:4            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_HOST_RISCV_INIT                                                          0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_HOST_RISCV_FALCON                                                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_RISCV_HOST                                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_TRACE                                                               5:5            /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_HOST_TRACE_INIT                                                          0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_HOST_TRACE_FALCON                                                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_HOST_TRACE_HOST                                                          0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_DMA                                                               16:16          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_TARGET_DMA_INIT                                                          0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_DMA_FALCON_IRQ0                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_DMA_FALCON_IRQ1                                                   0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_DMA_HOST_NORMAL                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_DMA_HOST_NONSTALL                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_SHA                                                               17:17          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_TARGET_SHA_INIT                                                          0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_SHA_FALCON_IRQ0                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_SHA_FALCON_IRQ1                                                   0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_SHA_HOST_NORMAL                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_SHA_HOST_NONSTALL                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_MEMERR                                                            18:18          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_TARGET_MEMERR_INIT                                                       0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_MEMERR_FALCON_IRQ0                                                0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_MEMERR_FALCON_IRQ1                                                0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_MEMERR_HOST_NORMAL                                                0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_MEMERR_HOST_NONSTALL                                              0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_FALCON                                                            19:19          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_TARGET_FALCON_INIT                                                       0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_FALCON_FALCON_IRQ0                                                0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_FALCON_FALCON_IRQ1                                                0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_FALCON_HOST_NORMAL                                                0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_FALCON_HOST_NONSTALL                                              0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_RISCV                                                             20:20          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_TARGET_RISCV_INIT                                                        0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_RISCV_FALCON_IRQ0                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_RISCV_FALCON_IRQ1                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_RISCV_HOST_NORMAL                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_RISCV_HOST_NONSTALL                                               0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_TRACE                                                             21:21          /* RWIVF */
#define NV_SOE_FALCON_IRQDEST2_TARGET_TRACE_INIT                                                        0x00000000     /* RWI-V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_TRACE_FALCON_IRQ0                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_TRACE_FALCON_IRQ1                                                 0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_TRACE_HOST_NORMAL                                                 0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQDEST2_TARGET_TRACE_HOST_NONSTALL                                               0x00000001     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK                                                                         0x00e0     /* RW-4R */
#define NV_SOE_FALCON_IRQSCMASK_GPTMR                                                                   0:0            /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_GPTMR_ENABLE                                                            0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_GPTMR_DISABLE                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_WDTMR                                                                   1:1            /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_WDTMR_ENABLE                                                            0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_WDTMR_DISABLE                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_MTHD                                                                    2:2            /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_MTHD_ENABLE                                                             0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_MTHD_DISABLE                                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_CTXSW                                                                   3:3            /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_CTXSW_ENABLE                                                            0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_CTXSW_DISABLE                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_HALT                                                                    4:4            /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_HALT_ENABLE                                                             0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_HALT_DISABLE                                                            0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_EXTERR                                                                  5:5            /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_EXTERR_ENABLE                                                           0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_EXTERR_DISABLE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_SWGEN0                                                                  6:6            /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_SWGEN0_ENABLE                                                           0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_SWGEN0_DISABLE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_SWGEN1                                                                  7:7            /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_SWGEN1_ENABLE                                                           0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_SWGEN1_DISABLE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_EXT                                                                     15:8           /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_EXT_ENABLE                                                              0x000000ff     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_EXT_DISABLE                                                             0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ1                                                             8:8            /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ1_ENABLE                                                      1              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ1_DISABLE                                                     0              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ2                                                             9:9            /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ2_ENABLE                                                      1              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ2_DISABLE                                                     0              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ3                                                             10:10          /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ3_ENABLE                                                      1              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ3_DISABLE                                                     0              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ4                                                             11:11          /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ4_ENABLE                                                      1              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ4_DISABLE                                                     0              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ5                                                             12:12          /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ5_ENABLE                                                      1              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ5_DISABLE                                                     0              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ6                                                             13:13          /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ6_ENABLE                                                      1              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ6_DISABLE                                                     0              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ7                                                             14:14          /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ7_ENABLE                                                      1              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ7_DISABLE                                                     0              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ8                                                             15:15          /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ8_ENABLE                                                      1              /*       */
#define NV_SOE_FALCON_IRQSCMASK_EXT_EXTIRQ8_DISABLE                                                     0              /*       */
#define NV_SOE_FALCON_IRQSCMASK_DMA                                                                     16:16          /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_DMA_ENABLE                                                              0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_DMA_DISABLE                                                             0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_SHA                                                                     17:17          /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_SHA_ENABLE                                                              0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_SHA_DISABLE                                                             0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_MEMERR                                                                  18:18          /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_MEMERR_ENABLE                                                           0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_MEMERR_DISABLE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_FALCON                                                                  19:19          /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_FALCON_ENABLE                                                           0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_FALCON_DISABLE                                                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_RISCV                                                                   20:20          /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_RISCV_ENABLE                                                            0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_RISCV_DISABLE                                                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQSCMASK_TRACE                                                                   21:21          /* RWIVF */
#define NV_SOE_FALCON_IRQSCMASK_TRACE_ENABLE                                                            0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQSCMASK_TRACE_DISABLE                                                           0x00000000     /* RW--V */
#define NV_SOE_MAILBOX(i)                                                                               (0x0804+(i)*4) /* RW-4A */
#define NV_SOE_MAILBOX__SIZE_1                                                                          4              /*       */
#define NV_SOE_MAILBOX_DATA                                                                             31:0           /* RWIVF */
#define NV_SOE_MAILBOX_DATA_INIT                                                                        0x00000000     /* RWI-V */

#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK                                                            0x0290     /* RWI4R */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION                                            2:0            /* RWIVF */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_ALL_LEVELS_ENABLED                         0x00000007     /* RWI-V */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_ALL_LEVELS_DISABLED                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0                                     0:0            /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0_ENABLE                              0x00000001     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0_DISABLE                             0x00000000     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1                                     1:1            /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1_ENABLE                              0x00000001     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1_DISABLE                             0x00000000     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2                                     2:2            /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2_ENABLE                              0x00000001     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2_DISABLE                             0x00000000     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_VIOLATION                                             3:3            /* RWIVF */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_VIOLATION_REPORT_ERROR                                0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_READ_VIOLATION_SOLDIER_ON                                  0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION                                           6:4            /* RWIVF */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_ALL_LEVELS_ENABLED                        0x00000007     /* RWI-V */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_ALL_LEVELS_DISABLED                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0                                    4:4            /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_ENABLE                             0x00000001     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_DISABLE                            0x00000000     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1                                    5:5            /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1_ENABLE                             0x00000001     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1_DISABLE                            0x00000000     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2                                    6:6            /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_ENABLE                             0x00000001     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_DISABLE                            0x00000000     /*       */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_VIOLATION                                            7:7            /* RWIVF */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_VIOLATION_REPORT_ERROR                               0x00000001     /* RWI-V */
#define NV_SOE_FALCON_IRQTMR_PRIV_LEVEL_MASK_WRITE_VIOLATION_SOLDIER_ON                                 0x00000000     /* RW--V */

#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK                                                               0x028c     /* RWI4R */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION                                               2:0            /* RWIVF */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_ALL_LEVELS_ENABLED                            0x00000007     /* RWI-V */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_ALL_LEVELS_DISABLED                           0x00000000     /* RW--V */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0                                        0:0            /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0_ENABLE                                 0x00000001     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0_DISABLE                                0x00000000     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1                                        1:1            /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1_ENABLE                                 0x00000001     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1_DISABLE                                0x00000000     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2                                        2:2            /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2_ENABLE                                 0x00000001     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2_DISABLE                                0x00000000     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_VIOLATION                                                3:3            /* RWIVF */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_VIOLATION_REPORT_ERROR                                   0x00000001     /* RWI-V */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_READ_VIOLATION_SOLDIER_ON                                     0x00000000     /* RW--V */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION                                              6:4            /* RWIVF */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_ALL_LEVELS_ENABLED                           0x00000007     /* RWI-V */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_ALL_LEVELS_DISABLED                          0x00000000     /* RW--V */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0                                       4:4            /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_ENABLE                                0x00000001     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_DISABLE                               0x00000000     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1                                       5:5            /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1_ENABLE                                0x00000001     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1_DISABLE                               0x00000000     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2                                       6:6            /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_ENABLE                                0x00000001     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_DISABLE                               0x00000000     /*       */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_VIOLATION                                               7:7            /* RWIVF */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_VIOLATION_REPORT_ERROR                                  0x00000001     /* RWI-V */
#define NV_SOE_FALCON_EXE_PRIV_LEVEL_MASK_WRITE_VIOLATION_SOLDIER_ON                                    0x00000000     /* RW--V */

#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK                                                             0x03c4     /* RWI4R */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION                                             2:0            /* RWIVF */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_ALL_LEVELS_ENABLED                          0x00000007     /* RWI-V */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2_ENABLED                              0x00000004     /* RW--V */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_ALL_LEVELS_DISABLED                         0x00000000     /* RW--V */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0                                      0:0            /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0_ENABLE                               0x00000001     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0_DISABLE                              0x00000000     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1                                      1:1            /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1_ENABLE                               0x00000001     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1_DISABLE                              0x00000000     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2                                      2:2            /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2_ENABLE                               0x00000001     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2_DISABLE                              0x00000000     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_VIOLATION                                              3:3            /* RWIVF */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_VIOLATION_REPORT_ERROR                                 0x00000001     /* RWI-V */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_READ_VIOLATION_SOLDIER_ON                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION                                            6:4            /* RWIVF */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_ALL_LEVELS_ENABLED                         0x00000007     /* RWI-V */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_ENABLED                             0x00000004     /* RW--V */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_ALL_LEVELS_DISABLED                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0                                     4:4            /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_ENABLE                              0x00000001     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_DISABLE                             0x00000000     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1                                     5:5            /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1_ENABLE                              0x00000001     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1_DISABLE                             0x00000000     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2                                     6:6            /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_ENABLE                              0x00000001     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_DISABLE                             0x00000000     /*       */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_VIOLATION                                             7:7            /* RWIVF */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_VIOLATION_REPORT_ERROR                                0x00000001     /* RWI-V */
#define NV_SOE_FALCON_RESET_PRIV_LEVEL_MASK_WRITE_VIOLATION_SOLDIER_ON                                  0x00000000     /* RW--V */

#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK                                                            0x027c     /* RWI4R */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION                                            2:0            /* RWIVF */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_ALL_LEVELS_ENABLED                         0x00000007     /* RWI-V */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_ALL_LEVELS_DISABLED                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0                                     0:0            /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0_ENABLE                              0x00000001     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL0_DISABLE                             0x00000000     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1                                     1:1            /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1_ENABLE                              0x00000001     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL1_DISABLE                             0x00000000     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2                                     2:2            /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2_ENABLE                              0x00000001     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_PROTECTION_LEVEL2_DISABLE                             0x00000000     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_VIOLATION                                             3:3            /* RWIVF */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_VIOLATION_REPORT_ERROR                                0x00000001     /* RWI-V */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_READ_VIOLATION_SOLDIER_ON                                  0x00000000     /* RW--V */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION                                           6:4            /* RWIVF */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_ALL_LEVELS_ENABLED                        0x00000007     /* RWI-V */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_ALL_LEVELS_DISABLED                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0                                    4:4            /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_ENABLE                             0x00000001     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_DISABLE                            0x00000000     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1                                    5:5            /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1_ENABLE                             0x00000001     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1_DISABLE                            0x00000000     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2                                    6:6            /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_ENABLE                             0x00000001     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_DISABLE                            0x00000000     /*       */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_VIOLATION                                            7:7            /* RWIVF */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_VIOLATION_REPORT_ERROR                               0x00000001     /* RWI-V */
#define NV_SOE_FALCON_ENGCTL_PRIV_LEVEL_MASK_WRITE_VIOLATION_SOLDIER_ON                                 0x00000000     /* RW--V */
#endif // __lr10_dev_soe_ip_h__
