#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Nightmares From the Deep series:
# - Nightmares From the Deep 1: The Cursed Heart
# - Nightmares From the Deep 2: The Siren's Call
# - Nightmares From the Deep 3: Davy Jones
# send your bug reports to contact@dotslashplay.it
###

script_version=20241016.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='nightmares-from-the-deep'
GAME_ID_EPISODE1="${GAME_ID}-1"
GAME_ID_EPISODE2="${GAME_ID}-2"
GAME_ID_EPISODE3="${GAME_ID}-3"

GAME_NAME='Nightmares From the Deep'
GAME_NAME_EPISODE1="${GAME_NAME}: The Cursed Heart"
GAME_NAME_EPISODE2="${GAME_NAME} 2: The Sirenʼs Call"
GAME_NAME_EPISODE3="${GAME_NAME} 3: Davy Jones"

## This installer used to be sold by gog.com,
## but has been dropped from their store on 2022-01-30.
ARCHIVE_BASE_EPISODE1_0_NAME='nightmares_from_the_deep_the_cursed_heart_en_gog_1_22620.sh'
ARCHIVE_BASE_EPISODE1_0_MD5='9978e7f6b340574f855d530c65752bab'
ARCHIVE_BASE_EPISODE1_0_SIZE='1000000'
ARCHIVE_BASE_EPISODE1_0_VERSION='1.0-gog22620'

## This installer used to be sold by gog.com,
## but has been dropped from their store on 2022-01-30.
ARCHIVE_BASE_EPISODE2_0_NAME='nightmares_from_the_deep_2_the_siren_s_call_en_gog_1_22645.sh'
ARCHIVE_BASE_EPISODE2_0_MD5='668260739c20276cfaac8dc3c6efdbb6'
ARCHIVE_BASE_EPISODE2_0_SIZE='1200000'
ARCHIVE_BASE_EPISODE2_0_VERSION='1.0-gog22645'

## This installer used to be sold by gog.com,
## but has been dropped from their store on 2022-01-30.
ARCHIVE_BASE_EPISODE3_0_NAME='nightmares_from_the_deep_3_davy_jones_en_gog_1_22689.sh'
ARCHIVE_BASE_EPISODE3_0_MD5='e5d0d8122840ba20e5d23d4c0524b6b0'
ARCHIVE_BASE_EPISODE3_0_SIZE='1500000'
ARCHIVE_BASE_EPISODE3_0_VERSION='1.0-gog22689'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN64_FILES='
NightmaresFromTheDeep_*_amd64'
CONTENT_GAME_BIN32_FILES='
NightmaresFromTheDeep_*_i386'
CONTENT_GAME_DATA_FILES='
Game
out
Game.cub
Game_en.cub
game.json'

FAKE_HOME_PERSISTENT_DIRECTORIES='
.Artifex Mundi'

APP_MAIN_EXE_BIN64_EPISODE1='NightmaresFromTheDeep_TheCursedHeart_amd64'
APP_MAIN_EXE_BIN64_EPISODE2='NightmaresFromTheDeep_TheSirensCall_amd64'
APP_MAIN_EXE_BIN64_EPISODE3='NightmaresFromTheDeep_DavyJones_amd64'
APP_MAIN_EXE_BIN32_EPISODE1='NightmaresFromTheDeep_TheCursedHeart_i386'
APP_MAIN_EXE_BIN32_EPISODE2='NightmaresFromTheDeep_TheSirensCall_i386'
APP_MAIN_EXE_BIN32_EPISODE3='NightmaresFromTheDeep_DavyJones_i386'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXext.so.6
libXinerama.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN_DEPENDENCIES_LIBRARIES_EPISODE1="$PKG_BIN_DEPENDENCIES_LIBRARIES
libidn.so.11"
PKG_BIN64_DEPENDENCIES_LIBRARIES_EPISODE1="$PKG_BIN_DEPENDENCIES_LIBRARIES_EPISODE1"
PKG_BIN32_DEPENDENCIES_LIBRARIES_EPISODE1="$PKG_BIN_DEPENDENCIES_LIBRARIES_EPISODE1"

PKG_DATA_ID_EPISODE1="${GAME_ID_EPISODE1}-data"
PKG_DATA_ID_EPISODE2="${GAME_ID_EPISODE2}-data"
PKG_DATA_ID_EPISODE3="${GAME_ID_EPISODE3}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

APP_MAIN_EXE_BIN64=$(context_value 'APP_MAIN_EXE_BIN64')
APP_MAIN_EXE_BIN32=$(context_value 'APP_MAIN_EXE_BIN32')
launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
