#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# To The Moon
# send your bug reports to contact@dotslashplay.it
###

script_version=20241219.5

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='to-the-moon'
GAME_NAME='To The Moon'

ARCHIVE_BASE_HUMBLE_0_NAME='ToTheMoon_linux_1389114090.sh'
ARCHIVE_BASE_HUMBLE_0_MD5='706a5c9467328438d412370ffb1454de'
ARCHIVE_BASE_HUMBLE_0_SIZE='89605'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/to-the-moon'

ARCHIVE_BASE_GOG_0_NAME='to_the_moon_1389114090_lang_25959.sh'
ARCHIVE_BASE_GOG_0_MD5='8774a72bdb768d9c5b3c817198363a04'
## FIXME: Set the size of the archive contents
ARCHIVE_BASE_GOG_0_VERSION='1.0-gog25959'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/to_the_moon'

CONTENT_PATH_DEFAULT_HUMBLE='data'
## The game fails to run some sound file on launch
## when using the system-provided build of libSDL_sound.
CONTENT_LIBS_BIN_FILES='
libSDL_sound-1.0.so.1'
## Some text is garbled if the system-provided build of libSDL2_ttf is used.
CONTENT_LIBS_BIN_FILES="$CONTENT_LIBS_BIN_FILES
libSDL2_ttf-2.0.so.0"
CONTENT_LIBS_BIN64_RELATIVE_PATH_HUMBLE='x86_64/lib64'
CONTENT_LIBS_BIN64_RELATIVE_PATH_GOG='lib64'
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_LIBS_BIN32_RELATIVE_PATH_HUMBLE='x86/lib'
CONTENT_LIBS_BIN32_RELATIVE_PATH_GOG='lib'
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_GAME_BIN64_RELATIVE_PATH_HUMBLE='x86_64'
CONTENT_GAME_BIN64_FILES='
ToTheMoon.bin.x86_64'
CONTENT_GAME_BIN32_RELATIVE_PATH_HUMBLE='x86'
CONTENT_GAME_BIN32_FILES='
ToTheMoon.bin.x86'
CONTENT_GAME_DATA_RELATIVE_PATH_HUMBLE='noarch'
CONTENT_GAME_DATA_FILES_HUMBLE='
Audio
Data
Fonts
Graphics
mkxp.conf
Game.ini
ToTheMoon.png'
CONTENT_GAME_DATA_FILES_GOG='
Audio
Data
Fonts
Graphics
mkxp.conf
Audio.dat
lang.dat
Game.ini
icon.png
Game.rgssad'
CONTENT_DOC_DATA_RELATIVE_PATH_HUMBLE='noarch'
CONTENT_DOC_DATA_FILES='
LICENSE.txt
COPYING-*.txt'
CONTENT_DOC0_DATA_FILES_GOG='
Multilingual ReadMe.pdf'

APP_MAIN_EXE_BIN64='ToTheMoon.bin.x86_64'
APP_MAIN_EXE_BIN32='ToTheMoon.bin.x86'
APP_MAIN_ICON_HUMBLE='noarch/ToTheMoon.png'
APP_MAIN_ICON_GOG='icon.png'
## Prevent a game crash when using the Wayland video backend of SDL
APP_MAIN_PRERUN='
# Prevent a game crash when using the Wayland video backend of SDL
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'
## TODO: Check if the default prefix type could be used
APP_MAIN_PREFIX_TYPE='none'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
## TODO: Check if the same dependencies list is used by the Humble Bundle and GOG builds
PKG_BIN_DEPENDENCIES_LIBRARIES='
libcrypt.so.1
libc.so.6
libdl.so.2
libfreetype.so.6
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libsigc-2.0.so.0
libstdc++.so.6
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build package

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
