/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.SelectAreaTracker;

public class DefaultSelectAreaTracker
extends AbstractTool
implements SelectAreaTracker {
    private Rectangle rubberband = new Rectangle();
    private Color rubberbandColor = Color.BLACK;
    private Stroke rubberbandStroke = new BasicStroke();
    private LinkedList<Handle> hoverHandles = new LinkedList();
    private Figure hoverFigure = null;

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.clearRubberBand();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.selectGroup(mouseEvent.isShiftDown());
        this.clearRubberBand();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Rectangle rectangle = (Rectangle)this.rubberband.clone();
        this.rubberband.setBounds(Math.min(this.anchor.x, mouseEvent.getX()), Math.min(this.anchor.y, mouseEvent.getY()), Math.abs(this.anchor.x - mouseEvent.getX()), Math.abs(this.anchor.y - mouseEvent.getY()));
        rectangle = rectangle.isEmpty() ? (Rectangle)this.rubberband.clone() : rectangle.union(this.rubberband);
        this.fireAreaInvalidated(rectangle);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.clearRubberBand();
        Point point = mouseEvent.getPoint();
        DrawingView drawingView = this.editor.findView((Container)mouseEvent.getSource());
        this.updateCursor(drawingView, point);
        if (drawingView == null || this.editor.getActiveView() != drawingView) {
            this.clearHoverHandles();
        } else {
            Figure figure = null;
            Point2D.Double double_ = drawingView.viewToDrawing(point);
            for (Figure figure2 : drawingView.getSelectedFigures()) {
                if (!figure2.contains(double_)) continue;
                figure = figure2;
            }
            if (figure == null) {
                figure = drawingView.findFigure(point);
                while (figure != null && !figure.isSelectable()) {
                    figure = drawingView.getDrawing().findFigureBehind(double_, figure);
                }
            }
            this.updateHoverHandles(drawingView, figure);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        DrawingView drawingView = this.editor.findView((Container)mouseEvent.getSource());
        this.updateHoverHandles(drawingView, null);
    }

    private void clearRubberBand() {
        if (!this.rubberband.isEmpty()) {
            this.fireAreaInvalidated(this.rubberband);
            this.rubberband.width = -1;
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.setStroke(this.rubberbandStroke);
        graphics2D.setColor(this.rubberbandColor);
        graphics2D.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width - 1, this.rubberband.height - 1);
        if (this.hoverHandles.size() > 0 && !this.getView().isFigureSelected(this.hoverFigure)) {
            for (Handle handle : this.hoverHandles) {
                handle.draw(graphics2D);
            }
        }
    }

    private void selectGroup(boolean bl) {
        Collection<Figure> collection = this.getView().findFiguresWithin(this.rubberband);
        for (Figure figure : collection) {
            if (!figure.isSelectable()) continue;
            this.getView().addToSelection(figure);
        }
    }

    protected void clearHoverHandles() {
        this.updateHoverHandles(null, null);
    }

    protected void updateHoverHandles(DrawingView drawingView, Figure figure) {
        if (figure != this.hoverFigure) {
            Rectangle rectangle = null;
            if (this.hoverFigure != null) {
                for (Handle handle : this.hoverHandles) {
                    if (rectangle == null) {
                        rectangle = handle.getDrawingArea();
                    } else {
                        rectangle.add(handle.getDrawingArea());
                    }
                    handle.setView(null);
                    handle.dispose();
                }
                this.hoverHandles.clear();
            }
            this.hoverFigure = figure;
            if (this.hoverFigure != null && figure.isSelectable()) {
                this.hoverHandles.addAll(this.hoverFigure.createHandles(-1));
                for (Handle handle : this.hoverHandles) {
                    handle.setView(drawingView);
                    if (rectangle == null) {
                        rectangle = handle.getDrawingArea();
                        continue;
                    }
                    rectangle.add(handle.getDrawingArea());
                }
            }
            if (rectangle != null) {
                rectangle.grow(1, 1);
                this.fireAreaInvalidated(rectangle);
            }
        }
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
        this.clearHoverHandles();
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        this.clearHoverHandles();
    }
}

