# JavaScript Functional Tests

Our JavaScript client functional tests are written using [Jasmine](https://jasmine.github.io/) and run in [Karma](https://karma-runner.github.io/2.0/index.html).

## Running tests from the command line

### Easy Mode

1. Start in the root of the repository
2. `./build /t:Restore` (Windows) / `./build.sh /t:Restore` (macOS/Linux)
3. `cd clients/ts/FunctionalTests`
4. `npm test`

### Iterating

The `npm test` command will take a while, because it will build the `clients\ts\signalr`, `clients\ts\signalr-protocol-msgpack` and `clients\ts\FunctionalTests` folders as well as `dotnet build` the `clients\ts\FunctionalTests` folder (to build the server-side components). If you are making changes, it's nice to be able to build only the things you need to build. To skip all the optional build steps, you can run `yarn run test:inner` in `clients\ts\FunctionalTests`. This will skip building `clients\ts\signalr` and `clients\signalr-protocol-msgpack` (it will still build the `clients\ts\FunctionalTests` folder). If you make changes to those libraries, you have to manually build those directories.

## Running tests from the browser

1. Start in the root of the repository
2. `./build /t:Restore` (Windows) / `./build.sh /t:Restore` (macOS/Linux)
3. `cd clients/ts`
4. `npm run build` (Builds the `signalr` and `signalr-protocol-msgpack` libraries)
5. `cd FunctionalTests`
6. `npm run build` (Builds the `FunctionalTests` **and** copies in the necessary JavaScript)
7. `dotnet run`

Copy-paste the URL that appears into the browser and the tests will run from the browser. They are easier to debug in the browser and you can use any browser you'd like.

## Running tests on SauceLabs

Prerequisite: You need a SauceLabs account. Running tests this way **will consume test minutes from your account** so be careful!

You must set the `SAUCE_USERNAME` environment variable to your SauceLabs username and the `SAUCE_ACCESS_KEY` environment variable to your SauceLabs access key.

**NOTE:** Running this will open a secure virtual network tunnel from your local machine to SauceLabs using the [Sauce Connect Proxy](https://wiki.saucelabs.com/display/DOCS/Sauce+Connect+Proxy).

1. Start in the root of the repository
2. `./build /t:Restore` (Windows) / `./build.sh /t:Restore` (macOS/Linux)
3. `cd clients/ts/FunctionalTests`
4. `npm run sauce`
