-- (c) bel2125, 2010
-- MIT public licence


local letterCode = {
  [' '] = {0,0,0,0,0},
  ['!'] = {0,0,95,0,0},
  ['"'] = {0,3,4,3,0},
  ['#'] = {34,127,34,127,34},
  ['$'] = {36,42,127,42,18},
  ['%'] = {35,19,8,100,98},
  ['&'] = {54,73,85,34,80},
  ["'"] = {0,11,7,0,0},
  ['('] = {0,28,34,65,0},
  [')'] = {0,65,34,28,0},
  ['*'] = {20,8,62,8,20},
  ['+'] = {8,8,62,8,8},
  [','] = {0,88,56,0,0},
  ['-'] = {8,8,8,8,8},
  ['.'] = {0,96,96,0,0},
  ['/'] = {32,16,8,4,2},
  ['0'] = {62,81,73,69,62},
  ['1'] = {0,66,127,64,0},
  ['2'] = {66,97,81,73,70},
  ['3'] = {65,73,77,75,49},
  ['4'] = {24,20,18,127,16},
  ['5'] = {39,69,69,69,57},
  ['6'] = {60,74,73,73,48},
  ['7'] = {1,1,121,5,3},
  ['8'] = {54,73,73,73,54},
  ['9'] = {6,73,73,41,30},
  [':'] = {0,54,54,0,0},
  [';'] = {0,91,59,0,0},
  ['<'] = {8,20,34,65,0},
  ['='] = {20,20,20,20,20},
  ['>'] = {0,65,34,20,8},
  ['?'] = {2,1,81,9,6},
  ['@'] = {50,73,121,65,62},
  ['A'] = {124,18,17,18,124},
  ['B'] = {65,127,73,73,54},
  ['C'] = {62,65,65,65,34},
  ['D'] = {65,127,65,65,62},
  ['E'] = {127,73,73,73,65},
  ['F'] = {127,9,9,9,1},
  ['G'] = {62,65,65,73,57},
  ['H'] = {127,8,8,8,127},
  ['I'] = {0,65,127,65,0},
  ['J'] = {32,64,65,63,1},
  ['K'] = {127,8,20,34,65},
  ['L'] = {127,64,64,64,64},
  ['M'] = {127,2,12,2,127},
  ['N'] = {127,4,8,16,127},
  ['O'] = {62,65,65,65,62},
  ['P'] = {127,9,9,9,6},
  ['Q'] = {62,65,81,33,94},
  ['R'] = {127,9,25,41,70},
  ['S'] = {38,73,73,73,50},
  ['T'] = {1,1,127,1,1},
  ['U'] = {63,64,64,64,63},
  ['V'] = {7,24,96,24,7},
  ['W'] = {127,32,24,32,127},
  ['X'] = {99,20,8,20,99},
  ['Y'] = {3,4,120,4,3},
  ['Z'] = {97,81,73,69,67},
  ['['] = {0,127,65,65,0},
  ['\\'] = {2,4,8,16,32},
  [']'] = {0,65,65,127,0},
  ['^'] = {24,4,2,4,24},
  ['_'] = {64,64,64,64,64},
  ['`'] = {0,0,7,11,0},
  ['a'] = {56,68,68,60,64},
  ['b'] = {127,72,68,68,56},
  ['c'] = {56,68,68,68,32},
  ['d'] = {56,68,68,72,127},
  ['e'] = {56,84,84,84,24},
  ['f'] = {0,8,126,9,2},
  ['g'] = {8,84,84,60,0},
  ['h'] = {127,4,4,120,0},
  ['i'] = {0,0,125,0,0},
  ['j'] = {32,64,68,61,0},
  ['k'] = {127,16,40,68,0},
  ['l'] = {0,0,127,0,0},
  ['m'] = {120,4,120,4,120},
  ['n'] = {124,8,4,4,120},
  ['o'] = {56,68,68,68,56},
  ['p'] = {124,20,20,20,8},
  ['q'] = {24,36,20,124,64},
  ['r'] = {124,8,4,4,0},
  ['s'] = {72,84,84,84,32},
  ['t'] = {4,62,68,32,0},
  ['u'] = {60,64,64,32,124},
  ['v'] = {28,32,64,32,28},
  ['w'] = {60,64,48,64,60},
  ['x'] = {68,36,124,72,68},
  ['y'] = {12,80,80,60,0},
  ['z'] = {68,100,84,76,68},
  ['{'] = {0,8,54,65,0},
  ['|'] = {0,0,119,0,0},
  ['}'] = {0,65,54,8,0},
  ['~'] = {8,4,8,16,8},
};

letterCode['('] = {0,60,66,129,0}
letterCode[')'] = {0,129,66,60,0}
letterCode[','] = {0,176,112,0,0}
letterCode[';'] = {0,182,118,0,0}
letterCode['['] = {0,255,129,129,0}
letterCode[']'] = {0,129,129,255,0}
letterCode['_'] = {128,128,128,128,128}
letterCode['g'] = {24,164,164,124,0}
letterCode['j'] = {64,128,132,125,0}
letterCode['p'] = {252,36,36,36,24}
letterCode['q'] = {24,36,36,252,128}
letterCode['y'] = {12,80,80,60,0}
letterCode['{'] = {0,24,102,129,0}
letterCode['}'] = {0,129,102,24,0}


local function HugeLetter(letter)
  if letter==' ' then return {"  ", "  ", "  ", "  ", "  ", "  ", "  ", "  "} end
  local code = letterCode[letter]  
  local str = {"", "", "", "", "", "", "", ""}
  for i=1,5 do
    local n = code[i]
    if n and n>0 then
      for b=1,8 do
        if bit32.btest(n, bit32.lshift(1, b-1)) then str[b] = str[b] .. letter else str[b] = str[b] .. ' ' end
      end
    end
  end
  return str
end

function HugeText(str)
  local txt = {"", "", "", "", "", "", "", ""}
  for i=1,string.len(str) do
    local s = HugeLetter(str:sub(i,i))
    for b=1,8 do
      if i>1 then
        txt[b] = txt[b] .. "   " .. s[b]
      else
        txt[b] = txt[b] .. s[b]
      end
    end
  end
  return txt
end

return HugeText
