context('Test Poisson regression model')

set.seed(1994)

test_that("Poisson regression works", {
  data(mtcars)
  bst <- xgb.train(
    data = xgb.DMatrix(as.matrix(mtcars[, -11]), label = mtcars[, 11]),
    objective = 'count:poisson', nrounds = 10, verbose = 0, nthread = 2
  )
  expect_equal(class(bst), "xgb.Booster")
  pred <- predict(bst, as.matrix(mtcars[, -11]))
  expect_equal(length(pred), 32)
  expect_lt(sqrt(mean((pred - mtcars[, 11])^2)), 1.2)
})
