/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.gui.Global;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class PointConstructor
extends ObjectConstructor {
    boolean Fix;
    PointObject P;
    boolean ShowsValue;
    boolean ShowsName;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        PointObject pointObject = zirkelCanvas.selectCreatePoint(mouseEvent.getX(), mouseEvent.getY(), false, true);
        this.Dragging = false;
        if (pointObject == null) {
            return;
        }
        if (pointObject.isPointOn()) {
            if (mouseEvent.isShiftDown() && zirkelCanvas.isNewPoint()) {
                pointObject.setUseAlpha(true);
            }
        } else if (pointObject.moveable() && zirkelCanvas.isNewPoint() && !zirkelCanvas.showGrid()) {
            this.P = pointObject;
            this.P.setDefaults();
            this.Fix = mouseEvent.isShiftDown();
            this.ShowsValue = this.P.showValue();
            this.ShowsName = this.P.showName();
            this.Dragging = true;
            zirkelCanvas.repaint();
        } else if (pointObject.moveable() && zirkelCanvas.isNewPoint() && zirkelCanvas.showGrid() && mouseEvent.isShiftDown()) {
            this.P = pointObject;
            this.P.setDefaults();
            try {
                this.P.setFixed("" + this.P.round(this.P.getX(), ZirkelCanvas.LengthsFactor), "" + this.P.round(this.P.getY(), ZirkelCanvas.LengthsFactor));
                this.P.edit(zirkelCanvas);
                this.P.validate();
            }
            catch (Exception exception) {}
        } else if (mouseEvent.isShiftDown() && !zirkelCanvas.isNewPoint()) {
            PointObject pointObject2 = new PointObject(zirkelCanvas.getConstruction(), pointObject.getX(), pointObject.getY());
            zirkelCanvas.addObject(pointObject2);
            pointObject2.setDefaults();
            pointObject2.setFixed(true);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        if (Global.getParameter("options.movename", false)) {
            this.P.setShowValue(true);
            this.P.setShowName(true);
        }
        this.P.move(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
        zirkelCanvas.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.P.setShowValue(this.ShowsValue);
        this.P.setShowName(this.ShowsName);
        this.P.updateText();
        zirkelCanvas.repaint();
        if (this.Fix) {
            try {
                this.P.setFixed("" + this.P.round(this.P.getX(), ZirkelCanvas.LengthsFactor), "" + this.P.round(this.P.getY(), ZirkelCanvas.LengthsFactor));
                this.P.edit(zirkelCanvas);
                this.P.validate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.point", "Point: Set a point!"));
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Point")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("x") || !xmlTag.hasParam("y")) {
            throw new ConstructionException("Point coordinates missing!");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        try {
            if (xmlTag.hasParam("actx")) {
                d2 = new Double(xmlTag.getValue("actx"));
            }
            if (xmlTag.hasParam("acty")) {
                d3 = new Double(xmlTag.getValue("acty"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        PointObject pointObject = new PointObject(construction, d2, d3);
        try {
            d2 = new Expression(xmlTag.getValue("x"), construction, pointObject).getValue();
            d3 = new Expression(xmlTag.getValue("y"), construction, pointObject).getValue();
            pointObject.move(d2, d3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PointConstructor.setType(xmlTag, pointObject);
        this.setName(xmlTag, pointObject);
        this.set(xmlTree, pointObject);
        construction.add(pointObject);
        this.setConditionals(xmlTree, construction, pointObject);
        if (xmlTag.hasParam("fixed")) {
            pointObject.setFixed(xmlTag.getValue("x"), xmlTag.getValue("y"));
        }
        if (xmlTag.hasParam("increment")) {
            try {
                pointObject.setIncrement(new Double(xmlTag.getValue("increment")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static void setType(XmlTag xmlTag, PointObject pointObject) {
        if (xmlTag.hasParam("shape")) {
            String string = xmlTag.getValue("shape");
            if (string.equals("square")) {
                pointObject.setType(0);
            }
            if (string.equals("diamond")) {
                pointObject.setType(1);
            }
            if (string.equals("circle")) {
                pointObject.setType(2);
            }
            if (string.equals("dot")) {
                pointObject.setType(3);
            }
            if (string.equals("cross")) {
                pointObject.setType(4);
            }
            if (string.equals("dcross")) {
                pointObject.setType(5);
            }
        }
    }

    public String getTag() {
        return "Point";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n == 0) {
            PointObject pointObject = new PointObject(construction, construction.getX() + (Math.random() - 0.5) * construction.getW(), construction.getY() + (Math.random() - 0.5) * construction.getW());
            if (!string.equals("")) {
                pointObject.setNameCheck(string);
            }
            construction.add(pointObject);
            pointObject.setDefaults();
            return;
        }
        if (n == 1) {
            ConstructionObject constructionObject = construction.find(stringArray[0]);
            if (constructionObject == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
            }
            if (!(constructionObject instanceof PrimitiveLineObject) && !(constructionObject instanceof PrimitiveCircleObject)) {
                throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[0]);
            }
            PointObject pointObject = new PointObject(construction, construction.getX() + (Math.random() - 0.5) * construction.getW(), construction.getY() + (Math.random() - 0.5) * construction.getW(), constructionObject);
            if (!string.equals("")) {
                pointObject.setNameCheck(string);
            }
            construction.add(pointObject);
            pointObject.setDefaults();
            return;
        }
        if (n != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        Expression expression = new Expression(stringArray[0], construction, null);
        Expression expression2 = new Expression(stringArray[1], construction, null);
        if (!expression.isValid() || !expression2.isValid()) {
            throw new ConstructionException(Zirkel.name("exception.expression"));
        }
        PointObject pointObject = new PointObject(construction, 0.0, 0.0);
        try {
            double d2 = new Double(stringArray[0]);
            double d3 = new Double(stringArray[1]);
            pointObject.move(d2, d3);
        }
        catch (Exception exception) {
            pointObject.setFixed(stringArray[0], stringArray[1]);
        }
        construction.add(pointObject);
        pointObject.validate();
        pointObject.setDefaults();
        if (!string.equals("")) {
            pointObject.setNameCheck(string);
        }
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        zirkelCanvas.setPrompt(Zirkel.name("prompt.point"));
    }
}

