target=multparm3 multparm4

#include "xiao.inc"

#if #TARGET (multparm3)
 #define DEG 3
#endif
#if #TARGET (multparm4)
 #define DEG 4
#endif

\title{Parametric multiplicity degree DEG}

\text{roots=shuffle(wims(makelist x for x=-20 to 20))}
\integer{mult=2}
\text{rootm=\roots[1]}
\text{roots=item(1 .. DEG,\rootm,\roots)}
\text{poly=wims(makelist (x - y) for y in \roots)}
\function{poly=randitem(1,-1,2,-2,3,-3)*wims(translate internal , to * in \poly)}
\integer{parmdeg=randint(0..2)}
\function{dev=pari(P=\poly;cc=polcoeff(P,\parmdeg);P+(m-cc)*x^\parmdeg)}
\integer{cc=pari(cc)}

\statement{Find a value of \(m) so that the following polynomial has a
multiple root, and find this multiple root.
<p><center>
\(P(x) = \dev)
</center>
<b>WARNING</b>. This exercise does not accept approximative replies! There
is always an integer solution. Find it.
}

\answer{\(m)}{\mm}{type=number}
\answer{The multiple root}{\rm}{type=number}

\function{p=wims(mathsubst m=\mm in \dev)}
\function{deriv=diff(\p,x)}
\real{t1=evalue(\p,x=\rm)}
\real{t2=evalue(\deriv,x=\rm)}

\condition{\(\rm) is a multiple root of \(\p)}{\t1 = 0 and \t2 = 0}

\feedback{\t1 != 0}{
 \(\rm) is not even a root of \(\p)&nbsp;! All wrong.
}

\feedback{\t1 = 0 and \t2 != 0}{
 \(\rm) is in fact a root of \(P(x) = \p). In order for it to be a multiple
 root, \(\rm) must also be a root of the derivative of \(P(x)), which is
 unfortunately not the case. Verify your computation.
}

