How to contribute
=================

Thank you for taking the time to contribute.  Let's keep moving forward
together to make ugrep the best grep utility on the planet.

The following is a set of guidelines for contributing to ugrep.

Contribution and participation in this project requires adherence to our
[code of conduct](CODE_OF_CONDUCT.md).

Did you find a bug?
-------------------

- Ensure the bug was not already reported by searching on GitHub under
  [Issues](https://github.com/Genivia/ugrep/issues).
- If you're unable to find an open issue addressing the problem, open a new one.
  Be sure to include a title and clear description, as much relevant
  information as possible, and a code sample or an executable test case
  demonstrating the expected behavior that is not occurring.

Do you have a patch that fixes a bug?
-------------------------------------

- Use the [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html)
  as a guideline to write the source code for the patch.
- Open a new GitHub pull request with the patch.
- Write a clear log message for your commits.  One-line messages are fine for
  small changes, but bigger changes should look like this:

      $ git commit -m "A brief summary of the commit
      > 
      > A paragraph describing what changed and its impact."

Do you intend to add a new feature or change an existing one?
-------------------------------------------------------------

We love to hear from you!  [Contact us](https://www.genivia.com/contact.html).

Contributions are covered under the [BSD-3 license](LICENSE.txt).

Thanks!

Robert van Engelen, Genivia Inc.
