/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/
#include "types.h"

#include "test.h"


static int test_type8() {
    int8_t i = 127;
    uint8_t u = 127;
    i += 1;	TEST_PASS(i == -128, "(s) 127 + 1 != -128"); 
    u += 1;	TEST_PASS(u == 128, "127 + 1 != 128");
    i += 128;	TEST_PASS(i == 0, "(s) -128 + 128 != 0");
    u += 128;	TEST_PASS(u == 0, "128 + 128 != 0");
    i -= 1;	TEST_PASS(i == -1, "(s) 0 - 1 != -1");
    u -= 1;	TEST_PASS(u == 255, "0 - 1 != 255");
    return 0;
}

static int test_type16() {
    int16_t i = 32767;
    uint16_t u = 32767;
    i += 1;	TEST_PASS(i == -32768, "(s) 32767 + 1 != -32768"); 
    u += 1;	TEST_PASS(u == 32768, "32767 + 1 != 32768");
    i += 32768;	TEST_PASS(i == 0, "(s) -32768 + 32768 != 0");
    u += 32768;	TEST_PASS(u == 0, "32768 + 32768 != 0");
    i -= 1;	TEST_PASS(i == -1, "(s) 0 - 1 != -1");
    u -= 1;	TEST_PASS(u == 65535, "0 - 1 != 65535");
    return 0;
}

static int test_type32() {
    int32_t i = 2147483647;
    uint32_t u = 2147483647;
    /* gcc on 32 bits emits a warning about -2147483648 being "unsigned only
     * in ISO C90", but I don't want it to be unsigned anyway... */
    i += 1; TEST_PASS(i == (-2147483647 - 1),
	    "(s) 2147483647 + 1 != -2147483648");
    u += 1; TEST_PASS(u == 2147483648U, "2147483647 + 1 != 2147483648");
    i += 2147483648U; TEST_PASS(i == 0, "(s) -2147483648 + 2147483648 != 0");
    u += 2147483648U; TEST_PASS(u == 0, "2147483648 + 2147483648 != 0");
    i -= 1; TEST_PASS(i == -1, "(s) 0 - 1 != -1");
    u -= 1; TEST_PASS(u == 4294967295U, "0 - 1 != 4294967295");
    return 0;
}

static int test_type64() {
    int64_t i = _LL(9223372036854775807);
    uint64_t u = _ULL(9223372036854775807);
    /* gcc emits a warning about _LL(-9223372036854775808) being too large,
     * which is wrong. That value is perfectly fine. */
    i += 1; TEST_PASS(i == _LL(-9223372036854775807) - _LL(1),
	    "(s) 9223372036854775807 + 1 != -9223372036854775808");
    u += 1; TEST_PASS(u == _ULL(9223372036854775808),
	    "9223372036854775807 + 1 != 9223372036854775808");
    i += _ULL(9223372036854775808); TEST_PASS(i == 0,
	    "(s) -9223372036854775808 + 9223372036854775808 != 0");
    u += _ULL(9223372036854775808); TEST_PASS(u == 0,
	    "9223372036854775808 + 9223372036854775808 != 0");
    i -= 1; TEST_PASS(i == -1,
	    "(s) 0 - 1 != -1");
    u -= 1; TEST_PASS(u == _ULL(18446744073709551615),
	    "0 - 1 != 18446744073709551615");
    return 0;
}


TESTS(types_test)
    TEST(test_type8);
    TEST(test_type16);
    TEST(test_type32);
    TEST(test_type64);
ENDTESTS
