/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2014 Martin Brehm
                  2012-2014 Martin Thomas

    This file written by Martin Thomas.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef STRUCTUREFACTOR_H
#define STRUCTUREFACTOR_H

#include "xintarray.h"
#include "xobarray.h"
#include "xobject.h"

class CTimeStep;

class CIsotope: public CxObject
{
public:
	CIsotope(const char *label, float neutronFactor, float cma1, float cma2, float cma3, float cma4, float cmb1, float cmb2, float cmb3, float cmb4, float cmc);
	~CIsotope();
	
	const char *label() { return _label; }
	float neutronFactor() { return _neutronFactor; }
	float xrayFactor(float q);
	
private:
	char *_label;
	float _neutronFactor;
	float _cma[4];
	float _cmb[4];
	float _cmc;
};

class CSFacObservation: public CxObject
{
public:
	CSFacObservation(bool global = false);
	~CSFacObservation();
	
	void initialize();
	void process(CTimeStep *ts);
	void finalize();
	
private:
	bool _global;
	char *_name;
	
	CxObArray _agList;
	CxIntArray _atomIndex;
	CxIntArray _isotopeList;
	CxObArray _isotopeTypeList;
	CxIntArray _isotopeTypeCount;
	
	float _rdfMax;
	int _rdfRes;
	float _sfacMax;
	int _sfacRes;
	CxObArray _rdfList;
	
	bool _normFFac;
};

bool gatherStructureFactor();
bool initializeStructureFactor();
void processStructureFactor(CTimeStep *ts);
void finalizeStructureFactor();

// class CStructureFactor : public CxObject
// {
// public:
// 	void TransformRDF(CDF *pin, CDF *pout);
// 	void Finish();
// 	void ProcessStep(CTimeStep *ts);
// 	void Parse();
// 	void Create();
// 	CStructureFactor();
// 	~CStructureFactor();
// 
// 	bool m_bDumpTotalRDF;
// 	bool m_bDumpElementRDFs;
// 	bool m_bDumpElementSFac;
// 	CxObArray m_oaRDFs;
// 	CxObArray m_oaSFacs;
// 	int m_iRDFRes, m_iSQRes;
// 	double m_fRDFRange;
// 	double m_fSQRange;
// };


#endif
