#!/bin/sh
# Use something like
#   "$0" > build/three.js.2 && colordiff -ru build/three.js{.2,} | less -R
# to check that the output of this script closely matches upstream.

cat <<eof
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(factory((global.THREE = global.THREE || {})));
}(this, (function (exports) { 'use strict';

eof
include() {
local f="$1"
shift
sed "$@" \
  -e '/^import { .* } from .*/d' \
  -e 's/_Math/exports.Math/g' \
  -e 's/^export function/function/g' \
  -e 's/^export var/var/g' \
  -e '/^export { .* };/d' \
  -e 's/\bUniformsUtils\b/exports.UniformsUtils/g' \
  -e 's/\bShapeUtils\b/exports.ShapeUtils/g' \
  -e 's/\bCurveUtils\b/exports.CurveUtils/g' \
  -e 's/\bAnimationUtils\b/exports.AnimationUtils/g' \
  -e 's/\bSceneUtils\b/exports.SceneUtils/g' \
  -e 's/\bTHREE.exports\b/THREE/g' \
  -e 's/\bDefaultLoadingManager\b/exports.DefaultLoadingManager/g' \
  -e '/^var [A-Z][a-zA-Z]*Curve3;/d' \
  -e 's/^[A-Z][a-zA-Z]*Curve3 /exports.\0/g' \
  -e 's/\s[A-Z][a-zA-Z]*Curve3\.call/ exports.\0/g' \
  -e 's/\s[A-Z][a-zA-Z]*Curve3\.prototype/ exports.\0/g' \
  "$f"
}

cat src/polyfills.js
include src/core/EventDispatcher.js
sed -e 's/^export //' src/constants.js
include src/math/Math.js -e '/var _Math/d'
include src/math/Vector2.js
include src/textures/Texture.js
include src/math/Matrix4.js
include src/math/Quaternion.js
include src/math/Vector3.js
include src/renderers/webgl/plugins/SpritePlugin.js
include src/math/Box2.js
include src/renderers/webgl/plugins/LensFlarePlugin.js
include src/textures/CubeTexture.js
include src/renderers/webgl/WebGLUniforms.js
include src/renderers/webgl/WebGLTextures.js
include src/math/Vector4.js
include src/renderers/webgl/WebGLState.js
include src/renderers/WebGLRenderTarget.js
include src/materials/Material.js \
  -e 's/^var count =/var count$1 =/' \
  -e 's/return count++; };/return count\$1++; }/'
include src/renderers/shaders/UniformsUtils.js \
  -e '/^var UniformsUtils/d'
include src/materials/ShaderMaterial.js
cat src/renderers/shaders/ShaderChunk.js | {
	while read cmd v from f; do
		case $cmd in
		"import")
		nodejs -e "var fs = require('fs');
var code = fs.readFileSync('src/renderers/shaders/' + process.argv[2].replace(/'/g,''), 'utf8');
var x = JSON.stringify(
	code
		.replace( /[ \t]*\/\/.*\n/g, '' )
		.replace( /[ \t]*\/\*[\s\S]*?\*\//g, '' )
		.replace( /\n{2,}/g, '\n' )
) + ';';
console.log('var ' + process.argv[1] + ' = ' + x + '\n');" \
		 "$v" "${f%;}";;
		"export") echo "$v $from $f"; break;;
		"") continue;;
		*) break;;
		esac
	done
	cat
}
include src/math/Color.js \
  -e '/^var ColorKeywords/d' \
  -e 's/\bColorKeywords\b/exports.ColorKeywords/'
include src/renderers/shaders/UniformsLib.js
include src/renderers/shaders/ShaderLib.js
include src/materials/MeshDepthMaterial.js
include src/math/Box3.js
include src/math/Sphere.js
include src/math/Matrix3.js
include src/math/Plane.js
include src/math/Frustum.js
include src/renderers/webgl/WebGLShadowMap.js
include src/renderers/webgl/WebGLShader.js
include src/renderers/webgl/WebGLProperties.js
include src/renderers/webgl/WebGLProgram.js
include src/renderers/webgl/WebGLPrograms.js
include src/core/BufferAttribute.js \
  -e '/^export {/,/^};/d'
include src/core/Face3.js
include src/math/Euler.js
include src/core/Layers.js
include src/core/Object3D.js \
  -e 's/^var count =/var count$3 =/' \
  -e 's/return count++; };/return count\$3++; }/'
include src/core/Geometry.js \
  -e 's/^var count =/var count$2 =/' \
  -e 's/return count++; };/return count\$2++; }/'
include src/core/DirectGeometry.js
include src/core/BufferGeometry.js
include src/renderers/webgl/WebGLGeometries.js
include src/renderers/webgl/WebGLObjects.js
include src/renderers/webgl/WebGLLights.js
include src/renderers/webgl/WebGLCapabilities.js
include src/renderers/webgl/WebGLExtensions.js
include src/renderers/webgl/WebGLIndexedBufferRenderer.js
include src/renderers/webgl/WebGLClipping.js
include src/renderers/webgl/WebGLBufferRenderer.js
include src/renderers/WebGLRenderTargetCube.js
include src/extras/geometries/BoxBufferGeometry.js
include src/math/Ray.js
include src/math/Line3.js
include src/math/Triangle.js
include src/materials/MeshBasicMaterial.js
include src/objects/Mesh.js
include src/extras/geometries/PlaneBufferGeometry.js
include src/cameras/Camera.js
include src/cameras/PerspectiveCamera.js
include src/cameras/OrthographicCamera.js
include src/renderers/WebGLRenderer.js
include src/scenes/FogExp2.js
include src/scenes/Fog.js
include src/scenes/Scene.js
include src/objects/LensFlare.js
include src/materials/SpriteMaterial.js
include src/objects/Sprite.js
include src/objects/LOD.js
include src/textures/DataTexture.js
include src/objects/Skeleton.js
include src/objects/Bone.js
include src/objects/SkinnedMesh.js
include src/materials/LineBasicMaterial.js
include src/objects/Line.js
include src/objects/LineSegments.js
include src/materials/PointsMaterial.js
include src/objects/Points.js
include src/objects/Group.js
include src/textures/VideoTexture.js
include src/textures/CompressedTexture.js
include src/textures/CanvasTexture.js
include src/textures/DepthTexture.js
include src/materials/ShadowMaterial.js
include src/materials/RawShaderMaterial.js
include src/materials/MultiMaterial.js
include src/materials/MeshStandardMaterial.js
include src/materials/MeshPhysicalMaterial.js
include src/materials/MeshPhongMaterial.js
include src/materials/MeshNormalMaterial.js
include src/materials/MeshLambertMaterial.js
include src/materials/LineDashedMaterial.js
include src/loaders/Cache.js \
  -e '/^var Cache/d' \
  -e 's/^Cache =/exports.Cache =/'
include src/loaders/LoadingManager.js \
  -e '/^var DefaultLoadingManager/d'
include src/loaders/XHRLoader.js \
  -e 's/\bCache\b/exports.Cache/'
include src/loaders/CompressedTextureLoader.js
include src/loaders/BinaryTextureLoader.js
include src/loaders/ImageLoader.js
include src/loaders/CubeTextureLoader.js
include src/loaders/TextureLoader.js
include src/lights/Light.js
include src/lights/HemisphereLight.js
include src/lights/LightShadow.js
include src/lights/SpotLightShadow.js
include src/lights/SpotLight.js
include src/lights/PointLight.js
include src/lights/DirectionalLightShadow.js
include src/lights/DirectionalLight.js
include src/lights/AmbientLight.js
include src/animation/AnimationUtils.js \
  -e '/^var AnimationUtils/d'
include src/math/Interpolant.js
include src/math/interpolants/CubicInterpolant.js
include src/math/interpolants/LinearInterpolant.js
include src/math/interpolants/DiscreteInterpolant.js
include src/animation/KeyframeTrackPrototype.js
include src/animation/KeyframeTrackConstructor.js
include src/animation/tracks/VectorKeyframeTrack.js
include src/math/interpolants/QuaternionLinearInterpolant.js
include src/animation/tracks/QuaternionKeyframeTrack.js
include src/animation/tracks/NumberKeyframeTrack.js
include src/animation/tracks/StringKeyframeTrack.js
include src/animation/tracks/BooleanKeyframeTrack.js
include src/animation/tracks/ColorKeyframeTrack.js
include src/animation/KeyframeTrack.js
include src/animation/AnimationClip.js
include src/loaders/MaterialLoader.js
include src/loaders/BufferGeometryLoader.js
include src/loaders/Loader.js
include src/loaders/JSONLoader.js
include src/loaders/ObjectLoader.js
include src/extras/ShapeUtils.js \
  -e '/^var ShapeUtils/d'
include src/extras/core/Curve.js
include src/extras/curves/LineCurve.js
include src/extras/core/CurvePath.js
include src/extras/curves/EllipseCurve.js
include src/extras/CurveUtils.js \
  -e '/^var CurveUtils/d'
include src/extras/curves/SplineCurve.js
include src/extras/curves/CubicBezierCurve.js
include src/extras/curves/QuadraticBezierCurve.js
include src/extras/core/PathPrototype.js
include src/extras/geometries/TubeGeometry.js
include src/extras/geometries/ExtrudeGeometry.js
include src/extras/geometries/ShapeGeometry.js
include src/extras/core/Shape.js
include src/extras/core/Path.js
include src/extras/core/Font.js
include src/loaders/FontLoader.js
include src/audio/AudioContext.js
include src/loaders/AudioLoader.js
include src/cameras/StereoCamera.js
include src/cameras/CubeCamera.js
include src/audio/AudioListener.js
include src/audio/Audio.js
include src/audio/PositionalAudio.js
include src/audio/AudioAnalyser.js
include src/animation/PropertyMixer.js
include src/animation/PropertyBinding.js
include src/animation/AnimationObjectGroup.js
include src/animation/AnimationAction.js
include src/animation/AnimationMixer.js
include src/core/Uniform.js
include src/core/InstancedBufferGeometry.js
include src/core/InterleavedBufferAttribute.js
include src/core/InterleavedBuffer.js
include src/core/InstancedInterleavedBuffer.js
include src/core/InstancedBufferAttribute.js
include src/core/Raycaster.js
include src/core/Clock.js
include src/math/Spline.js
include src/math/Spherical.js
include src/extras/objects/MorphBlendMesh.js
include src/extras/objects/ImmediateRenderObject.js
include src/extras/geometries/WireframeGeometry.js
include src/extras/helpers/WireframeHelper.js
include src/extras/helpers/VertexNormalsHelper.js
include src/extras/helpers/SpotLightHelper.js
include src/extras/helpers/SkeletonHelper.js
include src/extras/geometries/SphereBufferGeometry.js
include src/extras/helpers/PointLightHelper.js
include src/extras/geometries/SphereGeometry.js
include src/extras/helpers/HemisphereLightHelper.js
include src/extras/helpers/GridHelper.js
include src/extras/helpers/FaceNormalsHelper.js
include src/extras/geometries/EdgesGeometry.js
include src/extras/helpers/EdgesHelper.js
include src/extras/helpers/DirectionalLightHelper.js
include src/extras/helpers/CameraHelper.js
include src/extras/geometries/BoxGeometry.js
include src/extras/helpers/BoundingBoxHelper.js
include src/extras/helpers/BoxHelper.js
include src/extras/geometries/CylinderBufferGeometry.js
include src/extras/helpers/ArrowHelper.js
include src/extras/helpers/AxisHelper.js
include src/extras/geometries/ParametricGeometry.js
include src/extras/geometries/PolyhedronGeometry.js
include src/extras/geometries/TetrahedronGeometry.js
include src/extras/geometries/OctahedronGeometry.js
include src/extras/geometries/IcosahedronGeometry.js
include src/extras/geometries/DodecahedronGeometry.js
include src/extras/geometries/TorusKnotBufferGeometry.js
include src/extras/geometries/TorusKnotGeometry.js
include src/extras/geometries/TorusBufferGeometry.js
include src/extras/geometries/TorusGeometry.js
include src/extras/geometries/TextGeometry.js
include src/extras/geometries/RingBufferGeometry.js
include src/extras/geometries/RingGeometry.js
include src/extras/geometries/PlaneGeometry.js
include src/extras/geometries/LatheBufferGeometry.js
include src/extras/geometries/LatheGeometry.js
include src/extras/geometries/CylinderGeometry.js
include src/extras/geometries/ConeGeometry.js
include src/extras/geometries/ConeBufferGeometry.js
include src/extras/geometries/CircleBufferGeometry.js
include src/extras/geometries/CircleGeometry.js
include src/extras/curves/CatmullRomCurve3.js
include src/extras/curves/ClosedSplineCurve3.js
include src/extras/curves/SplineCurve3.js
include src/extras/curves/CubicBezierCurve3.js
include src/extras/curves/QuadraticBezierCurve3.js
include src/extras/curves/LineCurve3.js
include src/extras/curves/ArcCurve.js
include src/extras/SceneUtils.js \
  -e '/^var SceneUtils/d'
include src/Three.Legacy.js

cat <<eof
exports.SpritePlugin = SpritePlugin;
exports.LensFlarePlugin = LensFlarePlugin;
exports.WebGLUniforms = WebGLUniforms;
exports.WebGLTextures = WebGLTextures;
exports.WebGLState = WebGLState;
exports.WebGLShadowMap = WebGLShadowMap;
exports.WebGLShader = WebGLShader;
exports.WebGLProperties = WebGLProperties;
exports.WebGLPrograms = WebGLPrograms;
exports.WebGLProgram = WebGLProgram;
exports.WebGLObjects = WebGLObjects;
exports.WebGLLights = WebGLLights;
exports.WebGLGeometries = WebGLGeometries;
exports.WebGLCapabilities = WebGLCapabilities;
exports.WebGLExtensions = WebGLExtensions;
exports.WebGLIndexedBufferRenderer = WebGLIndexedBufferRenderer;
exports.WebGLClipping = WebGLClipping;
exports.WebGLBufferRenderer = WebGLBufferRenderer;
exports.WebGLRenderTargetCube = WebGLRenderTargetCube;
exports.WebGLRenderTarget = WebGLRenderTarget;
exports.WebGLRenderer = WebGLRenderer;
exports.ShaderLib = ShaderLib;
exports.UniformsLib = UniformsLib;
exports.ShaderChunk = ShaderChunk;
exports.FogExp2 = FogExp2;
exports.Fog = Fog;
exports.Scene = Scene;
exports.LensFlare = LensFlare;
exports.Sprite = Sprite;
exports.LOD = LOD;
exports.SkinnedMesh = SkinnedMesh;
exports.Skeleton = Skeleton;
exports.Bone = Bone;
exports.Mesh = Mesh;
exports.LineSegments = LineSegments;
exports.Line = Line;
exports.Points = Points;
exports.Group = Group;
exports.VideoTexture = VideoTexture;
exports.DataTexture = DataTexture;
exports.CompressedTexture = CompressedTexture;
exports.CubeTexture = CubeTexture;
exports.CanvasTexture = CanvasTexture;
exports.DepthTexture = DepthTexture;
exports.TextureIdCount = TextureIdCount;
exports.Texture = Texture;
exports.ShadowMaterial = ShadowMaterial;
exports.SpriteMaterial = SpriteMaterial;
exports.RawShaderMaterial = RawShaderMaterial;
exports.ShaderMaterial = ShaderMaterial;
exports.PointsMaterial = PointsMaterial;
exports.MultiMaterial = MultiMaterial;
exports.MeshPhysicalMaterial = MeshPhysicalMaterial;
exports.MeshStandardMaterial = MeshStandardMaterial;
exports.MeshPhongMaterial = MeshPhongMaterial;
exports.MeshNormalMaterial = MeshNormalMaterial;
exports.MeshLambertMaterial = MeshLambertMaterial;
exports.MeshDepthMaterial = MeshDepthMaterial;
exports.MeshBasicMaterial = MeshBasicMaterial;
exports.LineDashedMaterial = LineDashedMaterial;
exports.LineBasicMaterial = LineBasicMaterial;
exports.MaterialIdCount = MaterialIdCount;
exports.Material = Material;
exports.CompressedTextureLoader = CompressedTextureLoader;
exports.BinaryTextureLoader = BinaryTextureLoader;
exports.DataTextureLoader = DataTextureLoader;
exports.CubeTextureLoader = CubeTextureLoader;
exports.TextureLoader = TextureLoader;
exports.ObjectLoader = ObjectLoader;
exports.MaterialLoader = MaterialLoader;
exports.BufferGeometryLoader = BufferGeometryLoader;
exports.LoadingManager = LoadingManager;
exports.JSONLoader = JSONLoader;
exports.ImageLoader = ImageLoader;
exports.FontLoader = FontLoader;
exports.XHRLoader = XHRLoader;
exports.Loader = Loader;
exports.AudioLoader = AudioLoader;
exports.SpotLightShadow = SpotLightShadow;
exports.SpotLight = SpotLight;
exports.PointLight = PointLight;
exports.HemisphereLight = HemisphereLight;
exports.DirectionalLightShadow = DirectionalLightShadow;
exports.DirectionalLight = DirectionalLight;
exports.AmbientLight = AmbientLight;
exports.LightShadow = LightShadow;
exports.Light = Light;
exports.StereoCamera = StereoCamera;
exports.PerspectiveCamera = PerspectiveCamera;
exports.OrthographicCamera = OrthographicCamera;
exports.CubeCamera = CubeCamera;
exports.Camera = Camera;
exports.AudioListener = AudioListener;
exports.PositionalAudio = PositionalAudio;
exports.getAudioContext = getAudioContext;
exports.AudioAnalyser = AudioAnalyser;
exports.Audio = Audio;
exports.VectorKeyframeTrack = VectorKeyframeTrack;
exports.StringKeyframeTrack = StringKeyframeTrack;
exports.QuaternionKeyframeTrack = QuaternionKeyframeTrack;
exports.NumberKeyframeTrack = NumberKeyframeTrack;
exports.ColorKeyframeTrack = ColorKeyframeTrack;
exports.BooleanKeyframeTrack = BooleanKeyframeTrack;
exports.PropertyMixer = PropertyMixer;
exports.PropertyBinding = PropertyBinding;
exports.KeyframeTrack = KeyframeTrack;
exports.AnimationObjectGroup = AnimationObjectGroup;
exports.AnimationMixer = AnimationMixer;
exports.AnimationClip = AnimationClip;
exports.Uniform = Uniform;
exports.InstancedBufferGeometry = InstancedBufferGeometry;
exports.BufferGeometry = BufferGeometry;
exports.DirectGeometry = DirectGeometry;
exports.GeometryIdCount = GeometryIdCount;
exports.Geometry = Geometry;
exports.InterleavedBufferAttribute = InterleavedBufferAttribute;
exports.InstancedInterleavedBuffer = InstancedInterleavedBuffer;
exports.InterleavedBuffer = InterleavedBuffer;
exports.InstancedBufferAttribute = InstancedBufferAttribute;
exports.DynamicBufferAttribute = DynamicBufferAttribute;
exports.Float64Attribute = Float64Attribute;
exports.Float32Attribute = Float32Attribute;
exports.Uint32Attribute = Uint32Attribute;
exports.Int32Attribute = Int32Attribute;
exports.Uint16Attribute = Uint16Attribute;
exports.Int16Attribute = Int16Attribute;
exports.Uint8ClampedAttribute = Uint8ClampedAttribute;
exports.Uint8Attribute = Uint8Attribute;
exports.Int8Attribute = Int8Attribute;
exports.BufferAttribute = BufferAttribute;
exports.Face3 = Face3;
exports.Object3DIdCount = Object3DIdCount;
exports.Object3D = Object3D;
exports.Raycaster = Raycaster;
exports.Layers = Layers;
exports.EventDispatcher = EventDispatcher;
exports.Clock = Clock;
exports.QuaternionLinearInterpolant = QuaternionLinearInterpolant;
exports.LinearInterpolant = LinearInterpolant;
exports.DiscreteInterpolant = DiscreteInterpolant;
exports.CubicInterpolant = CubicInterpolant;
exports.Interpolant = Interpolant;
exports.Triangle = Triangle;
exports.Spline = Spline;
exports.Spherical = Spherical;
exports.Plane = Plane;
exports.Frustum = Frustum;
exports.Sphere = Sphere;
exports.Ray = Ray;
exports.Matrix4 = Matrix4;
exports.Matrix3 = Matrix3;
exports.Box3 = Box3;
exports.Box2 = Box2;
exports.Line3 = Line3;
exports.Euler = Euler;
exports.Vector4 = Vector4;
exports.Vector3 = Vector3;
exports.Vector2 = Vector2;
exports.Quaternion = Quaternion;
exports.Color = Color;
exports.MorphBlendMesh = MorphBlendMesh;
exports.ImmediateRenderObject = ImmediateRenderObject;
exports.WireframeHelper = WireframeHelper;
exports.VertexNormalsHelper = VertexNormalsHelper;
exports.SpotLightHelper = SpotLightHelper;
exports.SkeletonHelper = SkeletonHelper;
exports.PointLightHelper = PointLightHelper;
exports.HemisphereLightHelper = HemisphereLightHelper;
exports.GridHelper = GridHelper;
exports.FaceNormalsHelper = FaceNormalsHelper;
exports.EdgesHelper = EdgesHelper;
exports.DirectionalLightHelper = DirectionalLightHelper;
exports.CameraHelper = CameraHelper;
exports.BoundingBoxHelper = BoundingBoxHelper;
exports.BoxHelper = BoxHelper;
exports.ArrowHelper = ArrowHelper;
exports.AxisHelper = AxisHelper;
exports.WireframeGeometry = WireframeGeometry;
exports.ParametricGeometry = ParametricGeometry;
exports.TetrahedronGeometry = TetrahedronGeometry;
exports.OctahedronGeometry = OctahedronGeometry;
exports.IcosahedronGeometry = IcosahedronGeometry;
exports.DodecahedronGeometry = DodecahedronGeometry;
exports.PolyhedronGeometry = PolyhedronGeometry;
exports.TubeGeometry = TubeGeometry;
exports.TorusKnotGeometry = TorusKnotGeometry;
exports.TorusKnotBufferGeometry = TorusKnotBufferGeometry;
exports.TorusGeometry = TorusGeometry;
exports.TorusBufferGeometry = TorusBufferGeometry;
exports.TextGeometry = TextGeometry;
exports.SphereBufferGeometry = SphereBufferGeometry;
exports.SphereGeometry = SphereGeometry;
exports.RingGeometry = RingGeometry;
exports.RingBufferGeometry = RingBufferGeometry;
exports.PlaneBufferGeometry = PlaneBufferGeometry;
exports.PlaneGeometry = PlaneGeometry;
exports.LatheGeometry = LatheGeometry;
exports.LatheBufferGeometry = LatheBufferGeometry;
exports.ShapeGeometry = ShapeGeometry;
exports.ExtrudeGeometry = ExtrudeGeometry;
exports.EdgesGeometry = EdgesGeometry;
exports.ConeGeometry = ConeGeometry;
exports.ConeBufferGeometry = ConeBufferGeometry;
exports.CylinderGeometry = CylinderGeometry;
exports.CylinderBufferGeometry = CylinderBufferGeometry;
exports.CircleBufferGeometry = CircleBufferGeometry;
exports.CircleGeometry = CircleGeometry;
exports.BoxBufferGeometry = BoxBufferGeometry;
exports.BoxGeometry = BoxGeometry;
exports.ClosedSplineCurve3 = ClosedSplineCurve3;
exports.SplineCurve3 = SplineCurve3;
exports.ArcCurve = ArcCurve;
exports.EllipseCurve = EllipseCurve;
exports.SplineCurve = SplineCurve;
exports.CubicBezierCurve = CubicBezierCurve;
exports.QuadraticBezierCurve = QuadraticBezierCurve;
exports.LineCurve = LineCurve;
exports.Shape = Shape;
exports.ShapePath = ShapePath;
exports.Path = Path;
exports.Font = Font;
exports.CurvePath = CurvePath;
exports.Curve = Curve;
exports.REVISION = REVISION;
exports.MOUSE = MOUSE;
exports.CullFaceNone = CullFaceNone;
exports.CullFaceBack = CullFaceBack;
exports.CullFaceFront = CullFaceFront;
exports.CullFaceFrontBack = CullFaceFrontBack;
exports.FrontFaceDirectionCW = FrontFaceDirectionCW;
exports.FrontFaceDirectionCCW = FrontFaceDirectionCCW;
exports.BasicShadowMap = BasicShadowMap;
exports.PCFShadowMap = PCFShadowMap;
exports.PCFSoftShadowMap = PCFSoftShadowMap;
exports.FrontSide = FrontSide;
exports.BackSide = BackSide;
exports.DoubleSide = DoubleSide;
exports.FlatShading = FlatShading;
exports.SmoothShading = SmoothShading;
exports.NoColors = NoColors;
exports.FaceColors = FaceColors;
exports.VertexColors = VertexColors;
exports.NoBlending = NoBlending;
exports.NormalBlending = NormalBlending;
exports.AdditiveBlending = AdditiveBlending;
exports.SubtractiveBlending = SubtractiveBlending;
exports.MultiplyBlending = MultiplyBlending;
exports.CustomBlending = CustomBlending;
exports.AddEquation = AddEquation;
exports.SubtractEquation = SubtractEquation;
exports.ReverseSubtractEquation = ReverseSubtractEquation;
exports.MinEquation = MinEquation;
exports.MaxEquation = MaxEquation;
exports.ZeroFactor = ZeroFactor;
exports.OneFactor = OneFactor;
exports.SrcColorFactor = SrcColorFactor;
exports.OneMinusSrcColorFactor = OneMinusSrcColorFactor;
exports.SrcAlphaFactor = SrcAlphaFactor;
exports.OneMinusSrcAlphaFactor = OneMinusSrcAlphaFactor;
exports.DstAlphaFactor = DstAlphaFactor;
exports.OneMinusDstAlphaFactor = OneMinusDstAlphaFactor;
exports.DstColorFactor = DstColorFactor;
exports.OneMinusDstColorFactor = OneMinusDstColorFactor;
exports.SrcAlphaSaturateFactor = SrcAlphaSaturateFactor;
exports.NeverDepth = NeverDepth;
exports.AlwaysDepth = AlwaysDepth;
exports.LessDepth = LessDepth;
exports.LessEqualDepth = LessEqualDepth;
exports.EqualDepth = EqualDepth;
exports.GreaterEqualDepth = GreaterEqualDepth;
exports.GreaterDepth = GreaterDepth;
exports.NotEqualDepth = NotEqualDepth;
exports.MultiplyOperation = MultiplyOperation;
exports.MixOperation = MixOperation;
exports.AddOperation = AddOperation;
exports.NoToneMapping = NoToneMapping;
exports.LinearToneMapping = LinearToneMapping;
exports.ReinhardToneMapping = ReinhardToneMapping;
exports.Uncharted2ToneMapping = Uncharted2ToneMapping;
exports.CineonToneMapping = CineonToneMapping;
exports.UVMapping = UVMapping;
exports.CubeReflectionMapping = CubeReflectionMapping;
exports.CubeRefractionMapping = CubeRefractionMapping;
exports.EquirectangularReflectionMapping = EquirectangularReflectionMapping;
exports.EquirectangularRefractionMapping = EquirectangularRefractionMapping;
exports.SphericalReflectionMapping = SphericalReflectionMapping;
exports.CubeUVReflectionMapping = CubeUVReflectionMapping;
exports.CubeUVRefractionMapping = CubeUVRefractionMapping;
exports.RepeatWrapping = RepeatWrapping;
exports.ClampToEdgeWrapping = ClampToEdgeWrapping;
exports.MirroredRepeatWrapping = MirroredRepeatWrapping;
exports.NearestFilter = NearestFilter;
exports.NearestMipMapNearestFilter = NearestMipMapNearestFilter;
exports.NearestMipMapLinearFilter = NearestMipMapLinearFilter;
exports.LinearFilter = LinearFilter;
exports.LinearMipMapNearestFilter = LinearMipMapNearestFilter;
exports.LinearMipMapLinearFilter = LinearMipMapLinearFilter;
exports.UnsignedByteType = UnsignedByteType;
exports.ByteType = ByteType;
exports.ShortType = ShortType;
exports.UnsignedShortType = UnsignedShortType;
exports.IntType = IntType;
exports.UnsignedIntType = UnsignedIntType;
exports.FloatType = FloatType;
exports.HalfFloatType = HalfFloatType;
exports.UnsignedShort4444Type = UnsignedShort4444Type;
exports.UnsignedShort5551Type = UnsignedShort5551Type;
exports.UnsignedShort565Type = UnsignedShort565Type;
exports.UnsignedInt248Type = UnsignedInt248Type;
exports.AlphaFormat = AlphaFormat;
exports.RGBFormat = RGBFormat;
exports.RGBAFormat = RGBAFormat;
exports.LuminanceFormat = LuminanceFormat;
exports.LuminanceAlphaFormat = LuminanceAlphaFormat;
exports.RGBEFormat = RGBEFormat;
exports.DepthFormat = DepthFormat;
exports.DepthStencilFormat = DepthStencilFormat;
exports.RGB_S3TC_DXT1_Format = RGB_S3TC_DXT1_Format;
exports.RGBA_S3TC_DXT1_Format = RGBA_S3TC_DXT1_Format;
exports.RGBA_S3TC_DXT3_Format = RGBA_S3TC_DXT3_Format;
exports.RGBA_S3TC_DXT5_Format = RGBA_S3TC_DXT5_Format;
exports.RGB_PVRTC_4BPPV1_Format = RGB_PVRTC_4BPPV1_Format;
exports.RGB_PVRTC_2BPPV1_Format = RGB_PVRTC_2BPPV1_Format;
exports.RGBA_PVRTC_4BPPV1_Format = RGBA_PVRTC_4BPPV1_Format;
exports.RGBA_PVRTC_2BPPV1_Format = RGBA_PVRTC_2BPPV1_Format;
exports.RGB_ETC1_Format = RGB_ETC1_Format;
exports.LoopOnce = LoopOnce;
exports.LoopRepeat = LoopRepeat;
exports.LoopPingPong = LoopPingPong;
exports.InterpolateDiscrete = InterpolateDiscrete;
exports.InterpolateLinear = InterpolateLinear;
exports.InterpolateSmooth = InterpolateSmooth;
exports.ZeroCurvatureEnding = ZeroCurvatureEnding;
exports.ZeroSlopeEnding = ZeroSlopeEnding;
exports.WrapAroundEnding = WrapAroundEnding;
exports.TrianglesDrawMode = TrianglesDrawMode;
exports.TriangleStripDrawMode = TriangleStripDrawMode;
exports.TriangleFanDrawMode = TriangleFanDrawMode;
exports.LinearEncoding = LinearEncoding;
exports.sRGBEncoding = sRGBEncoding;
exports.GammaEncoding = GammaEncoding;
exports.RGBEEncoding = RGBEEncoding;
exports.LogLuvEncoding = LogLuvEncoding;
exports.RGBM7Encoding = RGBM7Encoding;
exports.RGBM16Encoding = RGBM16Encoding;
exports.RGBDEncoding = RGBDEncoding;
exports.BasicDepthPacking = BasicDepthPacking;
exports.RGBADepthPacking = RGBADepthPacking;
exports.CubeGeometry = BoxGeometry;
exports.Face4 = Face4;
exports.LineStrip = LineStrip;
exports.LinePieces = LinePieces;
exports.MeshFaceMaterial = MultiMaterial;
exports.PointCloud = PointCloud;
exports.Particle = Sprite;
exports.ParticleSystem = ParticleSystem;
exports.PointCloudMaterial = PointCloudMaterial;
exports.ParticleBasicMaterial = ParticleBasicMaterial;
exports.ParticleSystemMaterial = ParticleSystemMaterial;
exports.Vertex = Vertex;
exports.GeometryUtils = GeometryUtils;
exports.ImageUtils = ImageUtils;
exports.Projector = Projector;
exports.CanvasRenderer = CanvasRenderer;

Object.defineProperty(exports, '__esModule', { value: true });


Object.defineProperty( exports, 'AudioContext', {
	get: function () {
		return exports.getAudioContext();
	}
});

})));
eof
