/*   Theorur - A GUI for Ogg/Theora streaming
 *   Copyright (C) 2006-2009 Rafael Diniz <rafael@riseup.net>
 *
 *   This file is part of Theorur.
 *
 *   Theorur is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Theorur is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Theorur.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */


#define __INTERFACE_H__

#ifndef __GTK_H__
#include <gtk/gtk.h>
#endif

/* Callback for button_start click */
void theorur_start (GtkWidget *widget, gpointer data);

/* Callback for button_stop click */
void theorur_stop (GtkWidget *widget, gpointer data);

/* Callback for button_load click */
void theorur_load (GtkWidget *widget, gpointer data);

/* Callback for OK button of the "Open File" file selector, displayed by theorur_open */
void theorur_put_in_box (GtkWidget *widget, gpointer data);

/* Callback for OK button of the "Save File" file selector, displayed by theorur_save */
void theorur_write_config ( GtkWidget *widget, gpointer data );

/* Callback for About Menu Option */
void theorur_about (GtkWidget *widget, gpointer data);

/* Callback for the local dump file enc selector 'ok' button */
void theorur_localdump_enc (GtkWidget *widget, gpointer data);

/* Callback for the local dump file selector 'ok' button */
void theorur_localdump_raw (GtkWidget *widget, gpointer data);

/* Cleans the buffer inside the view box */
void clean_text_view_memory();

/* The function that updates the streaming status */
gboolean status_loop (gboolean foo);

/* The function that updates the theorur output window, when option == 1, means that     */
/* the "streaming_started" flag will be ignored, if option == 0, the "streaming_started" */
/* flag will not be ignored and the debug window will not be updated.                    */
gboolean text_box_loop (int option);

/* Callback that call the gtk_main_quit() */
gboolean delete_event (GtkWidget *widget, GdkEvent *event, gpointer data );

/* Callback that call the gtk_main_quit() without killing streaming */
gboolean delete_event_nd (GtkWidget *widget, GdkEvent *event, gpointer data );

/* Callback that shows a dialog asking for killing or not streaming before quitting */
gboolean main_quit (GtkWidget *widget, GdkEvent  *event, gpointer data);

/* theorur cmds not found function */
void theorurcmds_not_found();

/* callback function that is called when Detail button is clicked */
void theorur_detail (GtkWidget *widget, gpointer data);
