---
myst:
  html_meta:
    keywords: physique, schéma, optique, spectre, asorption, émission, rayonnement thermique, raies,
---
# Comment représenter des spectres d’émission ou d’absorption ?

Le package <ctanpkg:pgf-spectra> permet de tracer très simplement un grand nombre de
spectres lumineux.

Il perment de représenter des spectres continus ainsi que les spectres de raies d’émission et
d’absorptions pour un grand nombre d’éléments chimiques.

## Spectre de la lumière blanche 
### Un spectre basique

La commande principale est `pgfspectra` et donne le résultat suivant 
```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{pgf-spectra}
\usepackage{babel}

\begin{document}
\pgfspectra
\end{document}
```

### Customisation du spectre : 
On peut bien sûr modifier l’aspect et ajouter des éléments à cette figure.

L’exemple ci-dessous donne un exemple avec quelques options possibles.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{pgf-spectra}
\usepackage{babel}

\begin{document}

\pgfspectra[width=\linewidth,back=black!80!white,
axis, axis font color = black, axis font= \large, axis ticks=4, axis step=50, axis color=white,
begin=350, end=800, axis label text={$\lambda$ en  nm}]

\end{document}
```


## Spectre d’émission et d’absorption.
<ctanpkg:pgf-spectra> permet d’obtenir très simplement le spectre d’émission ou
d’absorption d’un élément chimique en ajoutant la clef `element = ⟨symbole de l’élément⟩`.


```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{pgf-spectra}
\usepackage{babel}

\begin{document}

\pgfspectra[element=Ne,width=\linewidth,
label, label position = north , label after text=\ \--- spectre d’émission , back=black,
axis, axis font color = black, axis font= \large, axis ticks=4, axis step=50, axis color=white,
begin=350, end=800, axis label text={$\lambda$ en  nm}]

\end{document}
```


## Affichage des valeurs

Ce package dispose de plusieurs bibliothèques, dont `data` qui perment d’afficher les
valeurs des longueur d’ondes des raies du spectre.

Cette bibliothèque fournit deux commandes : 

- `\pgfspectradata[⟨nom du set de valeurs⟩]{element=⟨élément chimique⟩, ⟨options⟩}` qui charge
les valeurs correspondant à l’élément choisi.
- `\pgfspectratable[⟨options du tableau⟩]{⟨Nom du set de valeur⟩}` qui affiche le tableau
  de valeurs.

:::{note}
- `\pgfspectradata` n’affiche rien.
- `\pgfspectratable` affiche le tableau du dernier set chargé si on ne lui passe aucun paramètre.
:::

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{pgf-spectra}
\usepgfspectralibrary{data}
\usepackage{babel}

\begin{document}

\pgfspectradata{element=H, unit=nm}
\pgfspectratable[title= \Large Raies d’émission de l’hydrogène \\ $\lambda$ en nm]

\end{document}
```
