---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              Not enough room left, nombre de fontes, police non chargée,
              fonte non chargée
---

# Que signifie l'erreur : "Font ⟨nom-interne⟩ = ⟨externe⟩ not loaded : Not enough room left" ?

- **Message** : `Font ⟨nom-interne⟩ = ⟨externe⟩ not loaded : Not enough room left`
- **Origine** : TeX

TeX ne peut charger qu'un certain nombre de fontes et il n'y a plus de place
disponible pour charger `⟨externe⟩`.

Une raison possible pour un chargement excessif de fontes est l'utilisation 
de tailles de fontes pour lesquelles LaTeX doit calculer et charger les fontes
mathématiques correspondantes.

La section 7.10.7 du *LaTeX Companion* donne plus de détails sur le sujet 
de la déclaration de polices mathématiques. La page de Vincent Zoonekynd
"[Les fontes sous LaTeX pour les nuls (et les autres)](http://zoonek.free.fr/LaTeX/Fontes/fontes.html#4.13)" 
évoque également ce sujet.


:::{sources}
- [FAQ erreurs - Lettre F](https://latex.developpez.com/faq/erreurs?page=F), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::