[manpage_begin textutil::string n 0.7]
[moddesc   {Text and string utilities, macro processing}]
[titledesc {Procedures to manipulate texts and strings.}]
[category  {Text processing}]
[require Tcl 8.2]
[require textutil::string [opt 0.7]]
[description]

The package [package textutil::string] provides miscellaneous string
manipulation commands.

[para]

The complete set of procedures is described below.

[list_begin definitions]

[call [cmd ::textutil::string::chop] [arg string]]

A convenience command. Removes the last character of [arg string] and
returns the shortened string.

[call [cmd ::textutil::string::tail] [arg string]]

A convenience command. Removes the first character of [arg string] and
returns the shortened string.

[call [cmd ::textutil::string::cap] [arg string]]

Capitalizes the first character of [arg string] and returns the
modified string.

[call [cmd ::textutil::string::uncap] [arg string]]

The complementary operation to [cmd ::textutil::string::cap]. Forces
the first character of [arg string] to lower case and returns the
modified string.


[call [cmd ::textutil::string::longestCommonPrefixList] [arg list]]
[call [cmd ::textutil::string::longestCommonPrefix] [opt [arg string]...]]

Computes the longest common prefix for either the [arg string]s given
to the command, or the strings specified in the single [arg list], and
returns it as the result of the command.

[para]

If no strings were specified the result is the empty string.  If only
one string was specified, the string itself is returned, as it is its
own longest common prefix.

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph textutil] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[see_also regexp(n) split(n) string(n)]
[keywords string capitalize formatting prefix uncapitalize]
[keywords chop {common prefix}]
[manpage_end]
