from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ConfigDict = _Mock()

LSF = _Mock()

Plugin1DBase = _Mock()

PyMcaDataDir = _Mock()

PyMcaDirs = _Mock()

PyMcaFileDialogs = _Mock()

SF = _Mock()

SFW = _Mock()

SpecfitFuns = _Mock()

gauss = _Mock()

getPlugin1DInstance = _Mock()

numpy = _Mock()

pathjoin = _Mock()

qt = _Mock()

snip = _Mock()

sys = _Mock()

traceback = _Mock()

DEBUG = 0

MENU_TEXT = 'Advanced Alignment Plugin'

class AdvancedAlignmentScanPlugin(_Mock):
  pass


class AlignmentWidget(_Mock):
  pass
  Accepted = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Rejected = 0
  _colLegend = 0
  _colShift = 2
  _colShiftLegend = 1
  _storeCode = 2

