/*----- PROTECTED REGION ID(TestCppTango1022.h) ENABLED START -----*/
/* clang-format on */
//=============================================================================
//
// file :        TestCppTango1022.h
//
// description : Include file for the TestCppTango1022 class
//
//
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
// Copyright (C): 2022
//                European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                France
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================

#ifndef TestCppTango1022_H
#define TestCppTango1022_H

#include <tango/tango.h>

/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022.h

#ifdef TANGO_LOG
	// cppTango after c934adea (Merge branch 'remove-cout-definition' into 'main', 2022-05-23)
	// nothing to do
#else
	// cppTango 9.3-backports and older
	#define TANGO_LOG       cout
	#define TANGO_LOG_INFO  cout2
	#define TANGO_LOG_DEBUG cout3
#endif // TANGO_LOG

/**
 *  TestCppTango1022 class description:
 *
 */


namespace TestCppTango1022_ns
{
/*----- PROTECTED REGION ID(TestCppTango1022::Additional Class Declarations) ENABLED START -----*/
/* clang-format on */
//	Additional Class Declarations
/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022::Additional Class Declarations

class TestCppTango1022 : public TANGO_BASE_CLASS
{

/*----- PROTECTED REGION ID(TestCppTango1022::Data Members) ENABLED START -----*/
    /* clang-format on */
    //	Add your own data members
    /* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022::Data Members



//	Constructors and destructors
public:
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	TestCppTango1022(Tango::DeviceClass *cl,std::string &s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	TestCppTango1022(Tango::DeviceClass *cl,const char *s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device name
	 *	@param d	Device description.
	 */
	TestCppTango1022(Tango::DeviceClass *cl,const char *s,const char *d);
	/**
	 * The device object destructor.
	 */
	~TestCppTango1022();


//	Miscellaneous methods
public:
	/*
	 *	will be called at device destruction or at init command.
	 */
	void delete_device();
	/*
	 *	Initialize the device
	 */
	virtual void init_device();
	/*
	 *	Always executed method before execution command method.
	 */
	virtual void always_executed_hook();


//	Attribute methods
public:
	//--------------------------------------------------------
	/*
	 *	Method      : TestCppTango1022::read_attr_hardware()
	 * Description:  Hardware acquisition for attributes.
	 */
	//--------------------------------------------------------
	virtual void read_attr_hardware(std::vector<long> &attr_list);

//	Dynamic attribute methods
public:

	/**
	 *	Attribute DoubleAttr related methods
	 *
	 *
	 *	Data type:  Tango::DevDouble
	 *	Attr type:	Scalar
	 */
	virtual void read_DoubleAttr(Tango::Attribute &attr);
	virtual void write_DoubleAttr(Tango::WAttribute &attr);
	virtual bool is_DoubleAttr_allowed(Tango::AttReqType type);
	void add_DoubleAttr_dynamic_attribute(std::string attname);
	void remove_DoubleAttr_dynamic_attribute(std::string attname);
	Tango::DevDouble *get_DoubleAttr_data_ptr(std::string &name);
	std::map<std::string,Tango::DevDouble>	   DoubleAttr_data;

	//--------------------------------------------------------
	/**
	 *	Method      : TestCppTango1022::add_dynamic_attributes()
	 * Description:  Add dynamic attributes if any.
	 */
	//--------------------------------------------------------
	void add_dynamic_attributes();




//	Command related methods
public:


	//--------------------------------------------------------
	/**
	 *	Method      : TestCppTango1022::add_dynamic_commands()
	 * Description:  Add dynamic commands if any.
	 */
	//--------------------------------------------------------
	void add_dynamic_commands();

/*----- PROTECTED REGION ID(TestCppTango1022::Additional Method prototypes) ENABLED START -----*/
    /* clang-format on */
    //	Additional Method prototypes
    /* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022::Additional Method prototypes
};

/*----- PROTECTED REGION ID(TestCppTango1022::Additional Classes Definitions) ENABLED START -----*/
/* clang-format on */
//	Additional Classes Definitions
/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022::Additional Classes Definitions

}	//	End of namespace

#endif   //	TestCppTango1022_H
