#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(2); 

    ReferenceTriangle domain; 

    VectorLagrange v_fe;
    v_fe.set_order(2);
    v_fe.set_size(2); 
    v_fe.set_polygon(domain);
    v_fe.compute_basis_functions();

    Lagrange p_fe;
    p_fe.set_order(1);
    p_fe.set_polygon(domain);
    p_fe.compute_basis_functions();

    usage(v_fe, p_fe); 

    Dof dof; 
    std::map<std::pair<unsigned int,unsigned int>, ex> A; 
    compute_Stokes_element_matrix(v_fe, p_fe, dof, A);  
    print(A); 


    // regression test 
    
    archive ar; 
    map<std::pair<unsigned int,unsigned int>,ex>::iterator iter; 
    for (iter = A.begin(); iter != A.end() ; iter++) {
	ar.archive_ex((*iter).second, istr("A_", (*iter).first.first, (*iter).first.second).c_str()); 
    }
    ofstream vfile("taylorhood_ex.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("taylorhood_ex.gar.v", "taylorhood_ex.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }


    return 0; 

}

