// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef MIXED_FE_IS_INCLUDED
#define MIXED_FE_IS_INCLUDED

#include "FE.h"
#include <vector>
#include <string>

namespace SyFi
{

	// FIXME: what about memory management ???
	//
	// FIXME: one assumption when using this MixedFE is that none of the dofs
	// in the vector of finite elements have different dofs. This assumption
	// is valid for all elements I know of.
	// If this is not appropriate, we could add an int to the dof, in a
	// similar way that it is done with the vector elements.
	// The current implementation is more efficient.
	// Could do a consistency check.

	class MixedFE : public FE
	{
		std::string description;
		public:
			std::vector<StandardFE*> mfe;
		public:
			MixedFE();
			MixedFE(StandardFE* fe1, StandardFE* fe2);
			virtual ~MixedFE();

			//FIXME: check that the domain are ok.
								 // Set polygonal domain
			virtual void set_polygon(Polygon& p)
			{
			}
								 // Get polygonal domain
			virtual Polygon& get_polygon()
			{
				return (*(mfe[0])).get_polygon();
			}
			virtual void compute_basis_functions() { }

			StandardFE* get(unsigned int i);
			void append(StandardFE* fe);

								 // The i'th basis function
			virtual GiNaC::ex N(unsigned int i);
								 // The i'th degree of freedom
			virtual GiNaC::ex dof(unsigned int i);
								 // Number of basis functions/degrees of freedom
			virtual unsigned int nbf() const;
			virtual std::string str();

	};

}								 // namespace SyFi
#endif
