; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64le-unknown-linux \
; RUN:   -mcpu=pwr8 | FileCheck %s -check-prefix=CHECK-64B-LE
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64-unknown-linux \
; RUN:   -mcpu=pwr7 | FileCheck %s -check-prefix=CHECK-64B-BE
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64-unknown-aix \
; RUN:   -mcpu=pwr7 | FileCheck %s -check-prefix=CHECK-64B-BE
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc-unknown-aix \
; RUN:   -mcpu=pwr7 | FileCheck %s -check-prefix=CHECK-32B-BE

declare ptr @llvm.returnaddress(i32) nounwind readnone

define ptr @test0() nounwind readnone {
; CHECK-64B-LE-LABEL: test0:
; CHECK-64B-LE:       # %bb.0: # %entry
; CHECK-64B-LE-NEXT:    mflr 0
; CHECK-64B-LE-NEXT:    std 0, 16(1)
; CHECK-64B-LE-NEXT:    stdu 1, -32(1)
; CHECK-64B-LE-NEXT:    ld 3, 48(1)
; CHECK-64B-LE-NEXT:    addi 1, 1, 32
; CHECK-64B-LE-NEXT:    ld 0, 16(1)
; CHECK-64B-LE-NEXT:    mtlr 0
; CHECK-64B-LE-NEXT:    blr
;
; CHECK-64B-BE-LABEL: test0:
; CHECK-64B-BE:       # %bb.0: # %entry
; CHECK-64B-BE-NEXT:    mflr 0
; CHECK-64B-BE-NEXT:    std 0, 16(1)
; CHECK-64B-BE-NEXT:    stdu 1, -48(1)
; CHECK-64B-BE-NEXT:    ld 3, 64(1)
; CHECK-64B-BE-NEXT:    addi 1, 1, 48
; CHECK-64B-BE-NEXT:    ld 0, 16(1)
; CHECK-64B-BE-NEXT:    mtlr 0
; CHECK-64B-BE-NEXT:    blr
;
; CHECK-32B-BE-LABEL: test0:
; CHECK-32B-BE:       # %bb.0: # %entry
; CHECK-32B-BE-NEXT:    mflr 0
; CHECK-32B-BE-NEXT:    stw 0, 8(1)
; CHECK-32B-BE-NEXT:    stwu 1, -32(1)
; CHECK-32B-BE-NEXT:    lwz 3, 40(1)
; CHECK-32B-BE-NEXT:    addi 1, 1, 32
; CHECK-32B-BE-NEXT:    lwz 0, 8(1)
; CHECK-32B-BE-NEXT:    mtlr 0
; CHECK-32B-BE-NEXT:    blr
entry:
  %0 = tail call ptr @llvm.returnaddress(i32 0);
  ret ptr %0
}

define ptr @test1() nounwind readnone {
; CHECK-64B-LE-LABEL: test1:
; CHECK-64B-LE:       # %bb.0: # %entry
; CHECK-64B-LE-NEXT:    mflr 0
; CHECK-64B-LE-NEXT:    std 0, 16(1)
; CHECK-64B-LE-NEXT:    stdu 1, -32(1)
; CHECK-64B-LE-NEXT:    ld 3, 0(1)
; CHECK-64B-LE-NEXT:    ld 3, 0(3)
; CHECK-64B-LE-NEXT:    ld 3, 16(3)
; CHECK-64B-LE-NEXT:    addi 1, 1, 32
; CHECK-64B-LE-NEXT:    ld 0, 16(1)
; CHECK-64B-LE-NEXT:    mtlr 0
; CHECK-64B-LE-NEXT:    blr
;
; CHECK-64B-BE-LABEL: test1:
; CHECK-64B-BE:       # %bb.0: # %entry
; CHECK-64B-BE-NEXT:    mflr 0
; CHECK-64B-BE-NEXT:    std 0, 16(1)
; CHECK-64B-BE-NEXT:    stdu 1, -48(1)
; CHECK-64B-BE-NEXT:    ld 3, 0(1)
; CHECK-64B-BE-NEXT:    ld 3, 0(3)
; CHECK-64B-BE-NEXT:    ld 3, 16(3)
; CHECK-64B-BE-NEXT:    addi 1, 1, 48
; CHECK-64B-BE-NEXT:    ld 0, 16(1)
; CHECK-64B-BE-NEXT:    mtlr 0
; CHECK-64B-BE-NEXT:    blr
;
; CHECK-32B-BE-LABEL: test1:
; CHECK-32B-BE:       # %bb.0: # %entry
; CHECK-32B-BE-NEXT:    mflr 0
; CHECK-32B-BE-NEXT:    stw 0, 8(1)
; CHECK-32B-BE-NEXT:    stwu 1, -32(1)
; CHECK-32B-BE-NEXT:    lwz 3, 0(1)
; CHECK-32B-BE-NEXT:    lwz 3, 0(3)
; CHECK-32B-BE-NEXT:    lwz 3, 8(3)
; CHECK-32B-BE-NEXT:    addi 1, 1, 32
; CHECK-32B-BE-NEXT:    lwz 0, 8(1)
; CHECK-32B-BE-NEXT:    mtlr 0
; CHECK-32B-BE-NEXT:    blr
entry:
  %0 = tail call ptr @llvm.returnaddress(i32 1);
  ret ptr %0
}

define ptr @test2() nounwind readnone {
; CHECK-64B-LE-LABEL: test2:
; CHECK-64B-LE:       # %bb.0: # %entry
; CHECK-64B-LE-NEXT:    mflr 0
; CHECK-64B-LE-NEXT:    std 0, 16(1)
; CHECK-64B-LE-NEXT:    stdu 1, -32(1)
; CHECK-64B-LE-NEXT:    ld 3, 0(1)
; CHECK-64B-LE-NEXT:    ld 3, 0(3)
; CHECK-64B-LE-NEXT:    ld 3, 0(3)
; CHECK-64B-LE-NEXT:    ld 3, 16(3)
; CHECK-64B-LE-NEXT:    addi 1, 1, 32
; CHECK-64B-LE-NEXT:    ld 0, 16(1)
; CHECK-64B-LE-NEXT:    mtlr 0
; CHECK-64B-LE-NEXT:    blr
;
; CHECK-64B-BE-LABEL: test2:
; CHECK-64B-BE:       # %bb.0: # %entry
; CHECK-64B-BE-NEXT:    mflr 0
; CHECK-64B-BE-NEXT:    std 0, 16(1)
; CHECK-64B-BE-NEXT:    stdu 1, -48(1)
; CHECK-64B-BE-NEXT:    ld 3, 0(1)
; CHECK-64B-BE-NEXT:    ld 3, 0(3)
; CHECK-64B-BE-NEXT:    ld 3, 0(3)
; CHECK-64B-BE-NEXT:    ld 3, 16(3)
; CHECK-64B-BE-NEXT:    addi 1, 1, 48
; CHECK-64B-BE-NEXT:    ld 0, 16(1)
; CHECK-64B-BE-NEXT:    mtlr 0
; CHECK-64B-BE-NEXT:    blr
;
; CHECK-32B-BE-LABEL: test2:
; CHECK-32B-BE:       # %bb.0: # %entry
; CHECK-32B-BE-NEXT:    mflr 0
; CHECK-32B-BE-NEXT:    stw 0, 8(1)
; CHECK-32B-BE-NEXT:    stwu 1, -32(1)
; CHECK-32B-BE-NEXT:    lwz 3, 0(1)
; CHECK-32B-BE-NEXT:    lwz 3, 0(3)
; CHECK-32B-BE-NEXT:    lwz 3, 0(3)
; CHECK-32B-BE-NEXT:    lwz 3, 8(3)
; CHECK-32B-BE-NEXT:    addi 1, 1, 32
; CHECK-32B-BE-NEXT:    lwz 0, 8(1)
; CHECK-32B-BE-NEXT:    mtlr 0
; CHECK-32B-BE-NEXT:    blr
entry:
  %0 = tail call ptr @llvm.returnaddress(i32 2);
  ret ptr %0
}
