/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.Cell;
import cds.healpix.Range;
import java.util.Iterator;

public final class ToCellItDecorator
implements Iterator<Cell> {
    private final Iterator<Range> it;
    private int shift;
    private int absoluteDephtMax;
    private long l = 0L;
    private long h = 0L;
    private Cell current;
    private Cell next;

    public ToCellItDecorator(int dim, int absoluteDephtMax, Iterator<Range> decorated) {
        this.it = decorated;
        this.shift = dim - 1;
        this.absoluteDephtMax = absoluteDephtMax;
        if (this.it.hasNext()) {
            Range r = this.it.next();
            this.l = r.from;
            this.h = r.to;
            this.next = this.uncheckedNext();
        }
        this.nextCell();
    }

    private final Cell uncheckedNext() {
        long len = this.h - this.l;
        int ddMaxFromLen = 63 - Long.numberOfLeadingZeros(len) >> this.shift;
        int ddMaxFromLow = Long.numberOfTrailingZeros(this.l) >> this.shift;
        int dd = Math.min(this.absoluteDephtMax, Math.min(ddMaxFromLen, ddMaxFromLow));
        int ddShift = dd << this.shift;
        Cell res = new Cell(this.absoluteDephtMax - dd, this.l >> ddShift);
        this.l += 1L << ddShift;
        return res;
    }

    private final void nextCell() {
        this.current = this.next;
        if (this.l < this.h) {
            this.next = this.uncheckedNext();
        } else if (this.hasNext()) {
            Range r = this.it.next();
            this.l = r.from;
            this.h = r.to;
            this.next = this.uncheckedNext();
        } else {
            this.next = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public Cell next() {
        Cell r = this.current;
        this.nextCell();
        return r;
    }
}

