-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Files;

--# inherit Files,
--#         SPARK.Ada.Command_Line,
--#         SPARK.Ada.Command_Line.Unbounded_String,
--#         SPARK.Ada.Strings.Unbounded,
--#         SPARK.Ada.Text_IO,
--#         SPARK.Ada.Text_IO.Unbounded_String;

package Command_Line is

   type File_Type_Map is array (Files.Known_File_Types) of Boolean;

   type Data_T is record
      Files_To_Delete : File_Type_Map;
   end record;

   type Status_T is (Ok, Error, Help);

   --  Parse command line arguments and options. Status can be one of
   --  the following:
   --  * Ok    - All is well, we can continue.
   --  * Help  - No errors, but we should print a help text and abort.
   --  * Error - Some error occurred, we should print a help text and
   --            abort with a non-zero return code.
   procedure Initialize (Data   : out Data_T;
                         Status : out Status_T);
   --# global in     SPARK.Ada.Command_Line.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Error;
   --# derives Data,
   --#         Status                               from SPARK.Ada.Command_Line.State &
   --#         SPARK.Ada.Text_IO.The_Standard_Error from *,
   --#                                                   SPARK.Ada.Command_Line.State;

end Command_Line;
