-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================
--------------------------------------------------------------------------------
--  Cell_Storage
--
-- Implementation
--    Uses Ada.Containers.Vectors to implement a simple self-extending
-- vector. Implemented in Ada, not SPARK, so hidden.
--------------------------------------------------------------------------------

package body Cell_Storage is
   --# hide Cell_Storage;

   procedure Initialize (Initial_Length : in     SPARK.Ada.Containers.Count_Type;
                         V              :    out Vector) is
   begin
      V :=
        Vector'
        (Vec => Vectors.To_Vector
           (New_Item => Cell_Content'(A_Ptr     => Cell'First,
                                      B_Ptr     => Cell'First,
                                      C_Ptr     => Cell'First,
                                      Copy      => Cell'First,
                                      Lex_Str   => LexTokenManager.Null_String,
                                      Val       => Natural'First,
                                      Assoc_Var => Dictionary.NullSymbol,
                                      Op_Symbol => SP_Symbols.SP_Symbol'First,
                                      Rank      => Cell_Rank'First,
                                      Kind      => Unknown_Kind,
                                      Free      => True,
                                      Marked    => False),
            Length   => Ada.Containers.Count_Type (Initial_Length)));
   end Initialize;

   function Last_Index (V : Vector) return Cell is
   begin
      return Cell (Vectors.Last_Index (V.Vec));
   end Last_Index;

   function Get_Element (V     : in Vector;
                         Index : in Cell) return Cell_Content is
   begin
      return Vectors.Element (Container => V.Vec,
                              Index     => Index);
   end Get_Element;

   procedure Set_Element (V     : in out Vector;
                          Index : in     Cell;
                          Value : in     Cell_Content) is
   begin
      Vectors.Replace_Element (Container => V.Vec,
                               Index     => Index,
                               New_Item  => Value);
   end Set_Element;

   procedure Append (V     : in out Vector;
                     Value : in     Cell_Content) is
   begin
      Vectors.Append (Container => V.Vec,
                      New_Item  => Value);
   end Append;

end Cell_Storage;
