6.2 Efekty w praktyce

# Efekty w praktyce

Pomimo, że na pierwszy rzut oka wyglądają one na zwodniczo łatwe, to 
od środka efekty są tak naprawde bardzo złożonymi bestiami. Ich prostota 
bardzo często kusi ludzi by naduzywać ich w swoich kawałkach. Może to 
być w porządku jeśli masz dobry i wydajny komputer, ale jeśli - tak jak 
ja - korzystasz z Raspberry Pi do jam'owania, musisz być wtedy bardzo 
ostrożny z tym ile pracy mu zlecisz do wykonania, jeśli chcesz być 
pewny, że beat zachowa swą płynność.

Rozważ taki kawałek kodu:

```
loop do
  with_fx :reverb do
    play 60, release: 0.1
    sleep 0.125
  end
end
```

W powyższym kawałku kodu zagraliśmy nutę 60 z bardzo krótkim czasem 
zanikania (release), więc jest to bardzo krótka nuta. Chemy również 
nałożyć na nią efekt reverb, więc opakowaliśmy ją w blok reverb. 
Jak na razie wszystko w porządku. Z wyjątkiem...

Przyjrzyjmy się co ten kod tak naprawdę robi. Na początku mamy 
pętlę `loop` co oznacza, że wszystko wewnątrz niej będzie powtarzane 
w nieskończoność. Następnie mamy blok `with_fx`. Oznacza to, że utworzymy 
nowych efekt FX *dla każdej iteracji pętli `loop`*. To tak jakbyśmy 
chcieli mieć odzielny efekt gitarowowy reverb przy każdym jednym uderzeniu 
w strunę gitary. Fajnie, że możemy tak zrobić, ale nie zawsze jest to 
coś co chciałbyś osiągnąć. Na przykład, ten kawałek kodu czeka niezła 
walka aby został on ładnie uruchomiony na Raspberry Pi. Cała praca 
potrzebna do stworzenia efektu reverb a potem czekanie do momentu,  
w którym będzie wymagał zatrzymania i usunięcia jest obsługiwana 
za Ciebie przez funkcję `with_fx`, zajmie to jednak sporo mocy  
procesora (CPU), która może okazać się bardzo cenna.

A co jeśli sprawimy, by ten kod był bardziej podobny do tradycyjnego 
zestawu, gdzie nasz gitarzysta posiada tylko *jeden* efekt reverb 
i to przez niego przechodzą wszystkie dźwięki? Łatwizna: 

```
with_fx :reverb do
  loop do
    play 60, release: 0.1
    sleep 0.125
  end
end
```

Umieściliśmy naszą pętęlę *wewnątrz* bloku `with_fx`. W ten sposób 
tworzymy tylko jeden efekt reverb dla wszystkich nut, które zostaną 
zagrane w naszej pętli. Taki kod jest dużo bardziej wydajny i na pewno 
będzie działał w porządku na Raspberry Pi. 

Kompromisem może też być użycie efektu `with_fx` wewnątrz pętli loop, 
ale powyżej iteracji wewnętrznej: 

```
loop do
  with_fx :reverb do
    16.times do
      play 60, release: 0.1
      sleep 0.125
    end
  end
end
```

W ten sposób przenieśliśmy efekt `with_fx` na zewnątrz wewnętrznej części 
pętli `loop` i teraz tworzymy nowy efekt reverb tylko co 16 zagranych 
nut. 

Pamiętaj jedno - błędów nie ma, sa tylko nowe możliwości. Jednakże, 
każdy z powyższych podejść będzie miał inne brzmienie oraz inną 
charakterystykę wydajności. Staraj się więc używać takiego podejścia, 
które będzie brzmiało najlepiej mając jednocześnie na uwadze fakt 
pracy z ograniczeniami wydajnościowymi twojego komputera/platformy 
na której pracujesz.
