/* Copyright (c) 2008-2017. The SimGrid Team. All rights reserved.          */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

#ifndef SIMGRID_MC_REPLAY_H
#define SIMGRID_MC_REPLAY_H

#include "xbt/base.h"
#include <string>

/** Replay path (if any) in string representation
 *
 *  This is using the format generated by traceToString().
 */
XBT_PUBLIC_DATA(std::string) MC_record_path;

/** Whether the replay mode is enabled */
static inline int MC_record_replay_is_active()
{
  return not MC_record_path.empty();
}

#endif
