/************************************************************************
 *
 * Copyright (C) 2017-2022 IRCAD France
 * Copyright (C) 2017 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#include "io/itk/helper/Transform.hpp"

namespace sight::io::itk::helper
{

//-----------------------------------------------------------------------------

Transform::MatrixType Transform::convertToITK(const data::Matrix4::csptr& _inTrf)
{
    MatrixType itkMat;

    for(std::uint8_t i = 0 ; i < 4 ; ++i)
    {
        for(std::uint8_t j = 0 ; j < 4 ; ++j)
        {
            itkMat(i, j) = (*_inTrf)(i, j);
        }
    }

    return itkMat;
}

//-----------------------------------------------------------------------------

void Transform::convertFromITK(const MatrixType& _inTrf, data::Matrix4::sptr& _outTrf)
{
    SIGHT_ASSERT("Input itk Matrix should be 4x4", _inTrf.ColumnDimensions == 4 && _inTrf.RowDimensions == 4);

    for(std::uint8_t i = 0 ; i < 4 ; ++i)
    {
        for(std::uint8_t j = 0 ; j < 4 ; ++j)
        {
            (*_outTrf)(i, j) = _inTrf(i, j);
        }
    }
}

//-----------------------------------------------------------------------------

} // namespace sight::io::itk::helper
