/* BookmarkStorage.h */

/* Copyright (C) 2011-2024 Michael Lugmair (Lucio Carreras)
 *
 * This file is part of sayonara player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BOOKMARK_STORAGE_H
#define BOOKMARK_STORAGE_H

#include "Bookmark.h"
#include "Utils/MetaData/MetaData.h"

#include <memory>

class BookmarkStorage
{
	public:
		enum class CreationStatus :
			unsigned char
		{
			Success,
			AlreadyThere,
			NoDBTrack,
			DBError,
			OtherError
		};

		virtual ~BookmarkStorage();
		virtual CreationStatus create(Seconds timestamp) = 0;

		virtual bool remove(int index) = 0;

		[[nodiscard]] virtual const QList<Bookmark>& bookmarks() const = 0;
		[[nodiscard]] virtual Bookmark bookmark(int index) const = 0;

		[[nodiscard]] virtual int count() const = 0;

		virtual void setTrack(const MetaData& track) = 0;
		[[nodiscard]] virtual const MetaData& track() const = 0;

		static std::shared_ptr<BookmarkStorage> create(const MetaData& track = MetaData {});
};

using BookmarkStoragePtr = std::shared_ptr<BookmarkStorage>;

#endif // BOOKMARK_STORAGE_H
