package net.sf.saxon.charcode;

/*

Copyright (C) 2006 Hewlett-Packard Development Company, L.P.

The contents of this file are subject to the Mozilla Public License Version 1.1
(the "License"); you may not use this file except in compliance with the
License. You may obtain a copy of the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: all this file
The Initial Developer of the Original Code is Lauren Ward. All Rights Reserved.
Contributor(s): Integrated into Saxon by Michael Kay. Removed code to perform dynamic
 initialization of the boolean array, replaced it with generated static data.

*************************
Author:
  Lauren Ward
Date:
  February 01, 2006
Address:
  Hewlett-Packard Company
  3404 East Harmony Road
  Fort Collins, CO 80528-9599
Revision:
  1.0 - Initial creation

Description: This class implements the PluggableCharacterSet to support
Big5 encoding.  The character mapping was obtained by extracting the
Unicode values from an iconv character table (big5=ucs2) available on HP-UX 11.23.

The class was tested by transforming numerous manuals and having localization engineers
review the output. The class was also tested by transforming a document with Big5
set as the output encoding, converting Big5 output to utf-8 using iconv,
and then comparing converted content to the same transformed document with utf-8 set
as the output encoding.

*/

public class Big5CharacterSet implements CharacterSet {

    private static Big5CharacterSet THE_INSTANCE = new Big5CharacterSet();

    public static Big5CharacterSet getInstance() {
        return THE_INSTANCE;
    }


	private static long[] flags = {
0xffffffffffffffffL, 0xffffffffffffffffL, 0x3500c100L, 0x10000000100L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x170004000000000L,
0x0L, 0x0L, 0x7fffdfc07fffL, 0xdfc0000000000000L,
0x40000ff81fffffffL, 0xffff400000000000L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x18cc26002412L, 0x0L, 0x0L, 0x0L,
0x1440000000000000L, 0xffc00000L, 0xf3c000000000L, 0x0L,
0x2394720c08L, 0x2000c3000000L, 0x4000001L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0xffc00ffcL, 0x0L, 0x0L,
0xa008888808080808L, 0x80024027f000L, 0x7fff0c00c000300cL, 0x31300003c000000L,
0x640000000000000L, 0xe000000000000000L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0xf4ffec067fc00000L, 0x7fffffffffffffffL, 0xfffff0067fffffffL, 0xfffffffffffffe02L,
0x7ffffffffc00000L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x10000000L, 0x0L,
0x0L, 0x0L, 0x3000e40000000L, 0x802640000000000L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0xd1ffcec30216f0d8L, 0x359732cf00401003L, 0x3a9e7c536e9e1260L, 0xfbf40fef5cc0ff15L,
0xecf7fcc4200d9abfL, 0x53cffffff97b9fffL, 0xffd5efbe00033771L, 0xfd77dbffc00b5fa2L,
0x875f7ffbf7fdd508L, 0xd7ff553ffcf7bf24L, 0xb51e6efe300fffb7L, 0x6ff35f349fefd6d7L,
0xbff8fda9ee66fdfdL, 0xdfdc2d7f75de4788L, 0x81657d82ac28c34eL, 0xebe898ec000d6e4L,
0xd3eaf30e4ce2f7b0L, 0x5b7e2e3f607f2dbdL, 0xf9fc53d1927e001aL, 0xf14437d73a51ddbbL,
0x6f7e76df025c94fL, 0xddec792ad20bf5d9L, 0x28232bef0d0c2850L, 0x10f40b117efff498L,
0x5bffe0df8ffed7deL, 0xf7a30800ff99ffbfL, 0xeb9ee6a0e7ffd3bfL, 0xffc30202eff671bdL,
0x5ffbe920032fffdaL, 0xdeb7e70b7e20071fL, 0xf9ff7ced7fbe7411L, 0xbffffe7d7fc1236fL,
0xeacfbf1d016bbef7L, 0xe6ea11e2befffbc3L, 0xff0f95ec07be3f0eL, 0xf6fc5937cd328161L,
0x79fc3abbb0ef9812L, 0xc57fe0006af5ff1cL, 0xb0191df7bc0206edL, 0x731bac09fd4efffcL,
0xeffe885eddefffd5L, 0xff7df63c954e7fL, 0xf7f3d88fd6db502fL, 0x67c37ef739d9086fL,
0x120f2f68ad7f418aL, 0x8de3dda8e176fbdfL, 0xfc27b3c6ff837e7eL, 0xd7bffabedeee7f3fL,
0xd06957db944617caL, 0xfbecf7bfaf6c81bdL, 0x183bbd3f274bffffL, 0xebfc07fff6fe1fd5L,
0x75d99b76dfafa88fL, 0x959edfbd3c5af5b5L, 0x5ddb35f83f8e9ec1L, 0xef3efac3fffbe6a0L,
0x59ffe6212ca8d1fbL, 0xcf9fceccbdef587aL, 0x2fdfc05ffffd780L, 0x3fbbbf300aecbd5L,
0xc31f6b77bfc2ffedL, 0xf57ae44235d9616fL, 0xebe43d6fe1efedacL, 0xb3556e87e792f947L,
0x3a2a4ff5fcd41b86L, 0xdc3f1dddf3ffbedeL, 0xa9fd0738bfbeffc2L, 0x6ffa7ffff7cb7323L,
0x6db13db53bc6d788L, 0x9afb0bc42d7ddbcfL, 0xe7f8e3dbc6ff275fL, 0xd44defc6dcb75db5L,
0x807fff7eefff3d40L, 0xff4c9cf73fffa001L, 0xdfeeaf3db080efffL, 0xdfff5cfdea00fffbL,
0xdef7bebd11db2b13L, 0xcfff3eb777baff6aL, 0xb07efa3569fffeabL, 0x77fc02839ff6e7ffL,
0xd9eeee71fd76ba27L, 0xf3f6f8fafe07fb7fL, 0xdbeb7f8000ffdedfL, 0x2bfffbf8001fffffL,
0xf1dfde0000fd3afeL, 0xffffcfe005d7e7bcL, 0xfdefebdffdffc006L, 0xbfffb7fdddf7fe40L,
0x27fbfbbffbf9f47L, 0xd016f8dfc7dfbff5L, 0x25f9b7efbe5ef01fL, 0x7d77abf0baddf9bfL,
0xdb4f9fdcfe7f33d7L, 0x56e15fce3fa93ff9L, 0xf908ef5fedbbb3ddL, 0x7e1fb33766cffc3cL,
0xbffffc0def977e60L, 0x7569607f6eabebfaL, 0x8bfccfc5e0f3edf6L, 0x8bf922fe9adebbcbL,
0xdcf5bd95f3be5cffL, 0x7dfd76f802dffffL, 0x5f5efded0003bff0L, 0xfefff8ff3f7fffa9L,
0x3badc6f77cfcL, 0xfedfd80000176fdfL, 0xf779fb1df9fffc00L, 0xbdeffafdbfbfffcL,
0xfbffd000421bdddL, 0xecfb7bffb6ffcff0L, 0x3206df7adfffdf5fL, 0x7a7f98402f9e7b9fL,
0xefe55fd7d7802cffL, 0xcbd7cef7ebf50203L, 0xdd4eff3bfe8f1bf4L, 0x371dd07fc5bbd0f8L,
0xb8f1f3e2d48d7bffL, 0x77fece5bff2423d3L, 0xbaef4fd3bf37b72dL, 0x9ffdbbb2bb99b1dfL,
0xfedddef5dfbb9a93L, 0xf23fad5fc7f5fab6L, 0xffffbefc001edbffL, 0xff6dff7ef5dff440L,
0xd9ffe3f7a5ffffffL, 0xe00000e3ffef8fffL, 0xbffefd80003b3dbfL, 0xaffdfffffeffff7cL,
0x9400007dff9ffeffL, 0xdf767ebfffd379c0L, 0xc7bbdfff33fb6fL, 0xfffffe88001f6fdfL,
0xf7e73cebf77ff7fbL, 0xd003fdb7fb7fb3bfL, 0xafdebf02fffffaedL, 0xfbff0c9ffbdfe93bL,
0xcf7f4ffdfbf1fdfbL, 0xfee867b7fef0caacL, 0x3e227ee1485fdda2L, 0x7b779eee8019bfdL,
0xaa7e917bf683e220L, 0x7b5ebaefffeaa094L, 0xef61a97fcde9f4cfL, 0xfff3aef9ef8ee8dfL,
0x772c987733ec86f7L, 0x6bf932f7f16bbbdfL, 0xcedef7b67feb8c25L, 0xfe7aebe9daf01bffL,
0xc1b973de3744ff3bL, 0xbc6ee1f7e7fbb7bfL, 0xfff23f05eedc3fdbL, 0xb7bc3bfe95f60eafL,
0xdffc0234fefffe21L, 0xea37ed7b3967f44fL, 0xd7f0adabd7f5e7b7L, 0xf4310ffffeca0f17L,
0xb99dffad66fff1e7L, 0x819b087d3e3983c7L, 0x8b39cce43d30b6ffL, 0xed3fedf7fb05ffffL,
0xd0fdde7fffc5fcacL, 0x33c8b3e9ec6ee4dfL, 0x6bf3367e0a378cb7L, 0x3ee6383f5f6ffdfaL,
0x5df0f475b5c57ffeL, 0xf3f2e7bf7ff004fL, 0xfddf457ff5bcff3dL, 0x296f9dfab5cff1fcL,
0x364ff805f7fffd80L, 0x14eea00eacffc05bL, 0x9f4b5fe3fdfcb83aL, 0x5cffcc37f5ed397fL,
0x6c4af95e5ffd44e7L, 0xeff9ff3fddf4b86dL, 0x60b7bfb8ebbefbf7L, 0xc4d7668f9b7e03b0L,
0xbcbcfdfba293c15dL, 0x8bbe0bb9e1decef3L, 0xcff9afc3b0fb7fa3L, 0xcd3040c19e170375L,
0xcee3f0f6bebffc90L, 0x8fffea80df46ff80L, 0x2dbfcfdcc80d4dc2L, 0xcb7a0cfffff0f9d7L,
0xf77fc04ff7fc91dfL, 0x95ec99799f7b34e5L, 0xccec6f8374817c7fL, 0x4baef4fa1abeb96L,
0xffffffffe0dbf6ffL, 0xff23fe9b73f7f07dL, 0xde8f7a0ff36fedffL, 0xef7a21f7d3ebfb70L,
0x10ffff3ffc77ffffL, 0xffc8ffebf0f5bffeL, 0xe3bd5ff800000000L, 0x0L,
0x2e7L, 0x1cbdcc9fd7feb77fL, 0x17fe6e3eefcdf7ffL, 0xf57fed1bf6fffddfL,
0xdf1fefdb4ae89f47L, 0x13a1e2ae0909f7c7L, 0x2f79b6fc74776ca0L, 0x3defcffede05fcfeL,
0xe6a006d77d5d8066L, 0x1b3ffc1aef53fbe1L, 0xb3fd05ffb3dafd7fL, 0xbf6de5f7f7ee39fbL,
0xedfcee1fe4b93fedL, 0xad53f7fb5adf6d8fL, 0x9c37f8f7fddfdffeL, 0xb0007f5bdfbdfe72L,
0xffcc035aaffd7ff9L, 0xfdfffa0000001fbfL, 0x53ffbff6bff38005L, 0xfffb4fdffdfbfeffL,
0x5b7ff010105dfffdL, 0xbf5eeb77d7df9fe6L, 0x2207c9ffe9fbeaf9L, 0xef7ffb1001fbfb7fL,
0xa3ff7fefdfffc016L, 0xdfe65fd6fffe47faL, 0xffffcefffbe1dfe7L, 0xbfd7e5ef7efde3f7L,
0xcf7841fbff6e7efbL, 0x939ebe5b7df7d978L, 0x73edfee7de1dfffL, 0xffd8dbff3afc07f2L,
0xfffe70faffeefdbbL, 0xf20fffffffff1ff0L, 0x7dc5fbbf383fbfffL, 0xbef879dfffbd3b7bL,
0xf6fcdf5dfefbf7dfL, 0xd8be377471f5ef4fL, 0xf0de77f369b863eeL, 0xe07eafff419bfbfeL,
0x677affe3777ff79eL, 0x6a59f3fffa7f7a7bL, 0x7691179f7a2f2367L, 0x80003e7dfedcfbbbL,
0xb9abf797352cca7bL, 0xceafefd2f2deff79L, 0x7f1d76e2dfb0a2ffL, 0xbfd57fdfeb97ffbbL,
0xefb7fffebfbbd77eL, 0xe7f3ffed97bd89f7L, 0xaeba3eeb00000000L, 0x0L,
0x15fL, 0x77ff8f2d6efdf7f4L, 0xee6dfdeefdf9bfffL, 0xfda9756fffaedcfeL,
0xafe59f5000000000L, 0xbdfbbd4L, 0xcc6ffe59d5bf3f6bL, 0x679fd7fdfbfbf82fL,
0xbf65ffffff52decfL, 0xedfe9f7fff6d3ab8L, 0x6ffeffa7def82024L, 0xa07d799fc7db4ffbL,
0xf7f6ffbf9e6b3fd3L, 0xbfd7fff7f8000000L, 0x191287e801L, 0x2e567f00feb68fbfL,
0xfe1dcf7ff8076e8fL, 0x6977fcdeb1d7bfffL, 0xffb5cdd3f721fe87L, 0x55b20ffdfcfdfc7fL,
0xffd7ebfffbfffef3L, 0xdfffb7a1fceb3de0L, 0xff75f07ff5bffd6eL, 0xf75fddec3bfe5dc5L,
0xff6def6a1f06fbe7L, 0x86fffb32df0da2ffL, 0xb7be5ffcfff83f18L, 0xfffff5c7cbe3c1fbL,
0xeadfbef7fff71ec8L, 0x37feffadd2cc77aL, 0xb0ef6ff77febfd00L, 0xb9afefef7b8a07ffL,
0x937ffec080faf7fdL, 0x8ff9e506b8f7ff8fL, 0xf000000000000000L, 0x0L,
0x0L, 0x13cL, 0xb2dff89b5cdec77fL, 0x97fcfe3bfc000000L,
0xaf8afe07dL, 0xb83fd89f783dff8eL, 0x9ff67dda69ead8d9L, 0xfffe3fff74e1e7f5L,
0xafd7f2cfbffba4e7L, 0x3bd022bae2eabbbfL, 0xfcb709eefebe1351L, 0x5f5f9fcf5404d2f7L,
0xffaff39ecbd5a5d0L, 0x5eeff1dfbd71f800L, 0xcf72bfL, 0xea58001135752a6eL,
0xb5e8ffb34dfff42fL, 0x55daffdb40000000L, 0x3ce579ffc74L, 0x715fffdd3d6ecbffL,
0x7f774e7ebd7eefe7L, 0xfeefbf73aff00000L, 0x95d9dbL, 0xe325fe89531f737eL,
0x5ebee7e3bdd3753bL, 0x7ebf6ef1cb89cf3eL, 0xa780f432eeb706c5L, 0xdbe01f7aefb88184L,
0x7d6390c5cdc7b5fL, 0xcafeafc3b3865de0L, 0x0L, 0x7647f7dL,
0x9fc0add7b6c7d397L, 0xf4397bfdc1f9fdd5L, 0xeff8abfffbed7ffbL, 0x75bff7ff7edfbff7L,
0xff55fd7600000000L, 0x46dL, 0xb3fe797dcd468f1aL, 0xb08fdebf8f97bf7dL,
0xc363b6fabcffff96L, 0xf3ff2fdfdf3beff2L, 0x4ec88a8000000L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0xc000000000000L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0x0L, 0x0L, 0x0L, 0x0L,
0xdfffL, 0xf87faf7ffe700000L, 0x0L, 0x0L,
0x5effffffffffffe9L, 0x7ffffffc08000000L, 0x0L, 0x0L
    };


    public Big5CharacterSet() {

	}

    // Determine if it is a valid character
    public final boolean inCharset(int ch) {
        if (ch > 65535) {
            return false;
        }
        long g = flags[ch>>6];
        long h = (g>>(63 - (ch&0x3f))) & 1L;
        return h == 1L;
    }


	public final String getEncodingName() {
		// Canonical Name for java.io and java.lang API
		return "Big5";
	}
}

