/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : plcDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/20
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#define _PLCDLG_
#include "plcDlg.h"





/* -------------------------------------------------------------------
 * CANCEL
 */
void plc_dlg_cancel_select(GtkWidget *widget, PLC_DLG *plc_dlg)
{
	plc_dlg->value = 0;
}

/* -------------------------------------------------------------------
 * POINT
 */
void plc_dlg_point_select(GtkWidget *widget, PLC_DLG *plc_dlg)
{
	plc_dlg->value = 1;
}

/* -------------------------------------------------------------------
 * LINE
 */
void plc_dlg_line_select(GtkWidget *widget, PLC_DLG *plc_dlg)
{
	plc_dlg->value = 2;
}

/* -------------------------------------------------------------------
 * CIRCLE
 */
void plc_dlg_circle_select(GtkWidget *widget, PLC_DLG *plc_dlg)
{
	plc_dlg->value = 3;
}



/* -------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint plc_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, PLC_DLG *plc_dlg)
{
//	g_print("sagcad.c : plc_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


	return TRUE; 
}



/* -------------------------------------------------------------------
 * コピー【移動/複写】設定
 * 
 */
gint plcDialog(PLC_DLG *plc_dlg)
{
//	GtkWidget *dialog;

	GtkWidget *main_vbox;
		GtkWidget *hbox;
			GtkWidget *point_button;
			GtkWidget *line_button;
			GtkWidget *circle_button;
		GtkWidget *separator;
		GtkWidget *action_hbox;
			GtkWidget *cancel_buttun;


	/* ダイアログ生成 */
	plc_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(plc_dlg->dialog), GTK_WIN_POS_MOUSE);
	gtk_window_set_title(GTK_WINDOW(plc_dlg->dialog), "Select Object");
	g_signal_connect( G_OBJECT(plc_dlg->dialog), "key_press_event",
						G_CALLBACK(plc_dlg_key_press_event), plc_dlg);


	main_vbox = gtk_vbox_new(0, 5);
	gtk_container_add(GTK_CONTAINER(plc_dlg->dialog), main_vbox);
	gtk_container_set_border_width(GTK_CONTAINER(plc_dlg->dialog), 5);
	gtk_widget_show(main_vbox);



		hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), hbox, TRUE, TRUE, 0);
		gtk_widget_show(hbox);

			point_button = gtk_button_new_with_label( _( _("POINT") ) );
			gtk_box_pack_start(GTK_BOX(hbox), point_button, TRUE, TRUE, 2);
			g_signal_connect(G_OBJECT(point_button), "clicked", G_CALLBACK(plc_dlg_point_select), plc_dlg);
			g_signal_connect(G_OBJECT(point_button), "clicked", G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(point_button);

			line_button = gtk_button_new_with_label( _( _("LINE") ) );
			gtk_box_pack_start(GTK_BOX(hbox), line_button, TRUE, TRUE, 2);
			g_signal_connect(G_OBJECT(line_button), "clicked", G_CALLBACK(plc_dlg_line_select), plc_dlg);
			g_signal_connect(G_OBJECT(line_button), "clicked", G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(line_button);

			circle_button = gtk_button_new_with_label( _( _("CIRCLE") ) );
			gtk_box_pack_start(GTK_BOX(hbox), circle_button, TRUE, TRUE, 2);
			g_signal_connect(G_OBJECT(circle_button), "clicked", G_CALLBACK(plc_dlg_circle_select), plc_dlg);
			g_signal_connect(G_OBJECT(circle_button), "clicked", G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(circle_button);


		/* セパレーター(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);


		action_hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
		gtk_widget_show(action_hbox);


			/* CANCELボタンの生成 */
			cancel_buttun = gtk_button_new_with_label("CANCEL");
			//gtk_widget_set_size_request(cancel_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
			g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(plc_dlg_cancel_select), plc_dlg);
			g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(cancel_buttun);





	/*  フォーカスを line_button に設定 */
	gtk_window_set_focus(GTK_WINDOW(plc_dlg->dialog), line_button);


	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(plc_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(plc_dlg->dialog), GTK_WINDOW(plc_dlg->parent));


	/* ダイアログを可視状態へ */
	gtk_widget_show(plc_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(plc_dlg->dialog);
	return plc_dlg->value;
; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : plcDlg.c
 * ====================================================================
 */
